/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.reports;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.egov.commons.Installment;
import org.egov.dcb.bean.DCBDisplayInfo;
import org.egov.dcb.bean.DCBReport;
import org.egov.dcb.bean.Receipt;
import org.egov.dcb.service.DCBService;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgdmCollectedReceipt;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.CurrentDcbService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.collection.WaterConnectionBillable;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.utils.DemandComparatorByInstallmentOrder;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.egov.wtms.utils.WaterTaxUtils;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/viewDcb"})
public class CurrentViewDcbController {
    @Autowired
    private DCBService dcbService;
    @Autowired
    private CurrentDcbService currentDcbService;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private UserService userService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired(required=true)
    protected WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;

    @ModelAttribute(value="citizenRole")
    public Boolean getCitizenUserRole() {
        Boolean citizenrole = Boolean.FALSE;
        if (ApplicationThreadLocals.getUserId() != null) {
            User currentUser = this.userService.getUserById(ApplicationThreadLocals.getUserId());
            for (Role userrole : currentUser.getRoles()) {
                if (!userrole.getName().equals("CITIZEN")) continue;
                citizenrole = Boolean.TRUE;
                break;
            }
        } else {
            citizenrole = Boolean.TRUE;
        }
        return citizenrole;
    }

    @ModelAttribute
    public WaterConnectionDetails getWaterConnectionDetails(@PathVariable String applicationCode) {
        return this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(applicationCode, ConnectionStatus.ACTIVE);
    }

    @Autowired
    @ModelAttribute(value="connectionTypes")
    public Map<String, String> connectionTypes() {
        return this.waterConnectionDetailsService.getConnectionTypesMap();
    }

    @RequestMapping(value={"/showMigData/{consumerNumber}/{applicationCode}"}, method={RequestMethod.GET})
    public String showMigData(Model model, @PathVariable String consumerNumber, @PathVariable String applicationCode, HttpServletRequest request) throws ParseException {
        List waterChargesReceiptInfo = this.currentDcbService.getMigratedReceipttDetails(consumerNumber);
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByOldConsumerNumberAndConnectionStatus(consumerNumber, ConnectionStatus.ACTIVE);
        if (waterConnectionDetails == null) {
            waterConnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(consumerNumber, ConnectionStatus.ACTIVE);
        }
        SQLQuery sqlQuery = this.currentDcbService.getMigratedReceiptDetails(waterConnectionDetails.getId());
        List waterChargesReceiptInfoList = sqlQuery.list();
        waterChargesReceiptInfoList.addAll(waterChargesReceiptInfo);
        model.addAttribute("waterChargesReceiptInfo", (Object)waterChargesReceiptInfoList);
        model.addAttribute("consumerCode", (Object)consumerNumber);
        return "dcbview-migdata";
    }

    @RequestMapping(value={"/consumerCodeWis/{applicationCode}"}, method={RequestMethod.GET})
    public String search(Model model, @PathVariable String applicationCode, HttpServletRequest request) {
        WaterConnectionDetails waterConnectionDetails = this.getWaterConnectionDetails(applicationCode);
        DCBReport dCBReport = new DCBReport();
        TreeMap finalResultMap = new TreeMap();
        ArrayList<String> installmentList = new ArrayList<String>();
        model.addAttribute("consumerCode", (Object)waterConnectionDetails.getApplicationNumber());
        model.addAttribute("connectionType", this.waterConnectionDetailsService.getConnectionTypesMap().get(waterConnectionDetails.getConnectionType().name()));
        if (this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand() != null) {
            DCBDisplayInfo dcbDispInfo = this.currentDcbService.getDcbDispInfo();
            WaterConnectionBillable waterConnectionBillable = (WaterConnectionBillable)this.context.getBean("waterConnectionBillable");
            AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
            waterConnectionBillable.setWaterConnectionDetails(waterConnectionDetails);
            waterConnectionBillable.setAssessmentDetails(assessmentDetails);
            this.dcbService.setBillable((Billable)waterConnectionBillable);
            dCBReport = this.dcbService.getCurrentDCBAndReceipts(dcbDispInfo);
            EgDemand demand = this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand();
            ArrayList egDemandDetailsList = new ArrayList(0);
            egDemandDetailsList.addAll(demand.getEgDemandDetails());
            Collections.sort(egDemandDetailsList, new DemandComparatorByInstallmentOrder());
            for (EgDemandDetails demandDetails : egDemandDetailsList) {
                if (!"WTAXCHARGES".equals(demandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode())) continue;
                installmentList.add(demandDetails.getEgDemandReason().getEgInstallmentMaster().getDescription());
            }
            for (String installment : installmentList) {
                for (Map.Entry dcbMap : dCBReport.getRecords().entrySet()) {
                    if (!installment.equals(((Installment)dcbMap.getKey()).getDescription())) continue;
                    finalResultMap.put(dcbMap.getKey(), dcbMap.getValue());
                }
            }
            dCBReport.setRecords(finalResultMap);
            List activeRcpts = this.populateActiveReceiptsOnly(dCBReport.getReceipts());
            List cancelRcpt = this.populateCancelledReceiptsOnly(dCBReport.getReceipts());
            model.addAttribute("activeRcpts", (Object)activeRcpts);
            model.addAttribute("cancelRcpt", (Object)cancelRcpt);
            model.addAttribute("totalRcptAmt", (Object)this.calculateReceiptTotal(activeRcpts));
            model.addAttribute("CanceltotalRcptAmt", (Object)this.calculateCancelledReceiptTotal(cancelRcpt));
            model.addAttribute("applicationTypeCode", (Object)waterConnectionDetails.getApplicationType().getCode());
            model.addAttribute("dcbReport", (Object)dCBReport);
            BigDecimal waterTaxDueforParent = this.waterConnectionDetailsService.getTotalAmount(waterConnectionDetails);
            model.addAttribute("waterTaxDueforParent", (Object)waterTaxDueforParent);
            model.addAttribute("mode", (Object)"viewdcb");
        } else {
            model.addAttribute("dcbReport", (Object)dCBReport);
            model.addAttribute("waterTaxDueforParent", (Object)BigDecimal.ZERO);
            model.addAttribute("mode", (Object)"viewdcb");
            model.addAttribute("applicationTypeCode", (Object)waterConnectionDetails.getApplicationType().getCode());
        }
        return "currentDcb-new";
    }

    public BigDecimal calculateReceiptTotal(List<Receipt> activeRcpts) {
        ArrayList<Receipt> rcpts = new ArrayList<Receipt>();
        BigDecimal totalRcptAmt = BigDecimal.ZERO;
        for (Receipt r : activeRcpts) {
            if (rcpts.contains(r) || !r.getReceiptStatus().equals(Character.valueOf('A'))) continue;
            rcpts.add(r);
            totalRcptAmt = totalRcptAmt.add(r.getReceiptAmt());
        }
        return totalRcptAmt;
    }

    public BigDecimal calculateCancelledReceiptTotal(List<Receipt> cancelRcpt) {
        ArrayList<Receipt> rcpts = new ArrayList<Receipt>();
        BigDecimal totalRcptAmt = BigDecimal.ZERO;
        for (Receipt r : cancelRcpt) {
            if (rcpts.contains(r) || !r.getReceiptStatus().equals(EgdmCollectedReceipt.RCPT_CANCEL_STATUS)) continue;
            rcpts.add(r);
            totalRcptAmt = totalRcptAmt.add(r.getReceiptAmt());
        }
        return totalRcptAmt;
    }

    private List<Receipt> populateActiveReceiptsOnly(Map<Installment, List<Receipt>> receipts) {
        ArrayList<Receipt> rcpt = new ArrayList<Receipt>();
        for (Map.Entry<Installment, List<Receipt>> entry : receipts.entrySet()) {
            for (Receipt r : entry.getValue()) {
                if (rcpt.contains(r) || r.getReceiptStatus().equals(EgdmCollectedReceipt.RCPT_CANCEL_STATUS)) continue;
                rcpt.add(r);
            }
        }
        return this.receiptsInDescendingOrderOfReceiptDate(rcpt);
    }

    private List<Receipt> receiptsInDescendingOrderOfReceiptDate(List<Receipt> receipts) {
        Collections.sort(receipts, (r1, r2) -> r2.getReceiptDate().compareTo(r1.getReceiptDate()));
        return receipts;
    }

    private List<Receipt> populateCancelledReceiptsOnly(Map<Installment, List<Receipt>> receipts) {
        ArrayList<Receipt> rcpt = new ArrayList<Receipt>();
        for (Map.Entry<Installment, List<Receipt>> entry : receipts.entrySet()) {
            for (Receipt r : entry.getValue()) {
                if (rcpt.contains(r) || !r.getReceiptStatus().equals(EgdmCollectedReceipt.RCPT_CANCEL_STATUS)) continue;
                rcpt.add(r);
            }
        }
        return this.receiptsInDescendingOrderOfReceiptDate(rcpt);
    }
}

