/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.masters;

import org.egov.infra.web.support.ui.DataTable;
import org.egov.infstr.services.Page;
import org.egov.wtms.application.entity.UsageSlabSearchRequest;
import org.egov.wtms.masters.entity.UsageSlab;
import org.egov.wtms.masters.entity.UsageSlabJsonAdapter;
import org.egov.wtms.masters.service.MeteredRatesService;
import org.egov.wtms.masters.service.UsageSlabService;
import org.egov.wtms.masters.service.UsageTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/masters"})
public class UsageSlabMasterController {
    private static final String MODE_VALUE = "mode";
    private static final String USAGESLAB_SEARCH_REQUEST = "usageSlabSearchRequest";
    @Autowired
    private UsageSlabService usageSlabService;
    @Autowired
    private UsageTypeService usageTypeService;
    @Autowired
    private MeteredRatesService meteredRatesService;

    @RequestMapping(value={"/usageslab-create"}, method={RequestMethod.GET})
    public String createUsageSlab(@ModelAttribute UsageSlab usageSlab, Model model) {
        model.addAttribute("usageType", (Object)this.usageTypeService.getActiveUsageTypes());
        return "usageslab-create";
    }

    @RequestMapping(value={"/usageslab-create"}, method={RequestMethod.POST})
    public String saveUsageSlab(@ModelAttribute UsageSlab usageSlab, BindingResult bindingResult, RedirectAttributes redirectAttrs, Model model) {
        this.usageSlabService.save(usageSlab);
        model.addAttribute(MODE_VALUE, (Object)"create");
        model.addAttribute("usageSlab", (Object)usageSlab);
        model.addAttribute("message", (Object)"Usage Slab Created Successfully");
        return "usageslab-success";
    }

    @RequestMapping(value={"usageslab-view"}, method={RequestMethod.GET})
    public String viewUsageSlab(@ModelAttribute(value="usageSlabSearchRequest") UsageSlabSearchRequest usageSlabSearchRequest, Model model) {
        model.addAttribute(MODE_VALUE, (Object)"view");
        model.addAttribute("usageType", (Object)this.usageTypeService.getActiveUsageTypes());
        model.addAttribute("slabNameList", (Object)this.usageSlabService.getActiveUsageSlabs());
        return "usageslab-search";
    }

    @RequestMapping(value={"/usageslab-view/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxSearchResult(UsageSlabSearchRequest usageSlabSearchRequest, @PathVariable String mode, Model model) {
        Page page = this.usageSlabService.search(usageSlabSearchRequest);
        long draw = usageSlabSearchRequest.draw();
        return new DataTable(page, draw).toJson(UsageSlabJsonAdapter.class);
    }

    @RequestMapping(value={"/usageslab-edit"}, method={RequestMethod.GET})
    public String searchForModify(@ModelAttribute UsageSlabSearchRequest usageSlabSearchRequest, Model model) {
        model.addAttribute(MODE_VALUE, (Object)"edit");
        model.addAttribute("usageType", (Object)this.usageTypeService.getActiveUsageTypes());
        model.addAttribute("slabNameList", (Object)this.usageSlabService.getActiveUsageSlabs());
        return "usageslab-search";
    }

    @RequestMapping(value={"/usageslab-edit/{id}"}, method={RequestMethod.GET})
    public String modifyUsageSlabRecord(@ModelAttribute(value="usageSlabSearchRequest") UsageSlabSearchRequest usageSlabSearchRequest, @PathVariable(value="id") String id, Model model) {
        UsageSlab existingUsageSlab = null;
        if (id != null) {
            existingUsageSlab = this.usageSlabService.findById(Long.valueOf(id));
        }
        model.addAttribute(MODE_VALUE, (Object)"edit");
        model.addAttribute(USAGESLAB_SEARCH_REQUEST, (Object)existingUsageSlab);
        return "usageslab-edit";
    }

    @RequestMapping(value={"/usageslab-edit/{id}"}, method={RequestMethod.POST})
    public String updteUsageSlab(@ModelAttribute(value="usageSlabSearchRequest") UsageSlabSearchRequest usageSlabSearchRequest, @PathVariable(value="id") String id, RedirectAttributes redirectAttrs, Model model) {
        UsageSlab existingObject = null;
        if (id != null) {
            existingObject = this.usageSlabService.findById(Long.valueOf(id));
        }
        if (existingObject != null) {
            if (usageSlabSearchRequest.getUsage() != null) {
                existingObject.setUsage(usageSlabSearchRequest.getUsage());
            }
            if (usageSlabSearchRequest.getSlabName() != null) {
                existingObject.setSlabName(usageSlabSearchRequest.getSlabName());
            }
            if (usageSlabSearchRequest.getFromVolume() != null) {
                existingObject.setFromVolume(usageSlabSearchRequest.getFromVolume());
            }
            if (usageSlabSearchRequest.getToVolume() != null) {
                existingObject.setToVolume(usageSlabSearchRequest.getToVolume());
            }
            existingObject.setActive(usageSlabSearchRequest.isActive());
            this.usageSlabService.save(existingObject);
        }
        model.addAttribute("usageSlab", (Object)existingObject);
        model.addAttribute("message", (Object)"Usage Slab Updated Successfully");
        return "usageslab-success";
    }

    @RequestMapping(value={"/usageslab-overlap-ajax"}, method={RequestMethod.GET})
    @ResponseBody
    public UsageSlab usageSlabOverlapCheck(@RequestParam String usage, @RequestParam String slabName, @RequestParam Long fromVolume, @RequestParam Long toVolume) {
        return this.usageSlabService.checkSlabOverlap(usage, fromVolume, toVolume);
    }

    @RequestMapping(value={"/usageslab-gap-ajax"}, method={RequestMethod.GET})
    @ResponseBody
    public UsageSlab usageSlabGapCheck(@RequestParam String usage, @RequestParam String slabName, @RequestParam Long fromVolume, @RequestParam Long toVolume) {
        return this.usageSlabService.checkSlabGap(usage, fromVolume, toVolume);
    }

    @RequestMapping(value={"/usageslab-rate-exists-ajax"}, method={RequestMethod.GET})
    @ResponseBody
    public Boolean usageSlabRateExistsCheck(@RequestParam String slabName) {
        UsageSlab slabNameVal = this.usageSlabService.findBySlabName(slabName);
        if (slabNameVal != null && slabNameVal.isActive()) {
            return this.meteredRatesService.isRateExists(slabName);
        }
        return false;
    }
}

