/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.masters;

import java.util.ArrayList;
import java.util.Collections;
import javax.validation.Valid;
import org.egov.wtms.masters.entity.MeteredRates;
import org.egov.wtms.masters.entity.MeteredRatesDetail;
import org.egov.wtms.masters.service.MeteredRatesDetailComparatorById;
import org.egov.wtms.masters.service.MeteredRatesService;
import org.egov.wtms.masters.service.UsageSlabService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/masters"})
public class MeteredRatesMasterController {
    private static final String SLABNAME_LIST = "slabNameList";
    private static final String METERED_RATES = "meteredRates";
    private static final String METERED_RATE_CREATE = "metered-rate-create";
    @Autowired
    private MeteredRatesService meteredRatesService;
    @Autowired
    private UsageSlabService usageSlabService;

    @RequestMapping(value={"/metered-rate-create"}, method={RequestMethod.GET})
    public String createMeteredRate(@ModelAttribute MeteredRates meteredRates, Model model) {
        model.addAttribute(SLABNAME_LIST, (Object)this.usageSlabService.getActiveUsageSlabs());
        model.addAttribute(METERED_RATES, (Object)meteredRates);
        return METERED_RATE_CREATE;
    }

    @RequestMapping(value={"/metered-rate-create/{slabName}"}, method={RequestMethod.GET})
    public String viewMeteredRateForm(@PathVariable(value="slabName") String slabName, Model model) {
        MeteredRatesDetailComparatorById rateDetailComparatorById = new MeteredRatesDetailComparatorById();
        model.addAttribute(SLABNAME_LIST, (Object)this.usageSlabService.getActiveUsageSlabs());
        model.addAttribute("mode", (Object)"edit");
        model.addAttribute("usageSlab", (Object)this.usageSlabService.findBySlabName(slabName));
        MeteredRates meteredRatesObj = this.meteredRatesService.findBySlabName(slabName);
        if (meteredRatesObj != null) {
            ArrayList<MeteredRatesDetail> rateList = new ArrayList<MeteredRatesDetail>();
            for (MeteredRatesDetail rates : meteredRatesObj.getRatesDetail()) {
                if (rates.getId() == null) continue;
                rateList.add(rates);
            }
            meteredRatesObj.setRatesDetail(rateList);
            Collections.sort(meteredRatesObj.getRatesDetail(), rateDetailComparatorById);
        } else {
            meteredRatesObj = new MeteredRates();
            ArrayList tempList = new ArrayList();
            meteredRatesObj.setSlabName(slabName);
            meteredRatesObj.setRatesDetail(tempList);
        }
        model.addAttribute(METERED_RATES, (Object)meteredRatesObj);
        return METERED_RATE_CREATE;
    }

    @RequestMapping(value={"/metered-rate-create"}, method={RequestMethod.POST})
    public String saveMeteredRates(@Valid @ModelAttribute(value="meteredRates") MeteredRates meteredRates, BindingResult errors, Model model) {
        if (errors.hasErrors()) {
            model.addAttribute(SLABNAME_LIST, (Object)this.usageSlabService.getActiveUsageSlabs());
            model.addAttribute(METERED_RATES, (Object)meteredRates);
            return METERED_RATE_CREATE;
        }
        for (MeteredRatesDetail detail : meteredRates.getRatesDetail()) {
            if (detail.getId() != null) continue;
            detail.setMeteredRate(meteredRates);
        }
        this.meteredRatesService.save(meteredRates);
        model.addAttribute("message", (Object)"Metered Rates Created Successfully");
        return "metered-rate-success";
    }

    @RequestMapping(value={"/metered-rate-view"}, method={RequestMethod.GET})
    public String getMeteredRates(@ModelAttribute MeteredRates meteredRates, Model model) {
        model.addAttribute(SLABNAME_LIST, (Object)this.usageSlabService.getActiveUsageSlabs());
        return "metered-rate-search";
    }

    @RequestMapping(value={"/metered-rate-search/{slabName}"}, method={RequestMethod.GET})
    public String viewSearchResult(@PathVariable(value="slabName") String slabName, Model model) {
        MeteredRates meteredRates = this.meteredRatesService.findBySlabName(slabName);
        model.addAttribute(SLABNAME_LIST, (Object)this.usageSlabService.getActiveUsageSlabs());
        if (meteredRates != null) {
            model.addAttribute(METERED_RATES, (Object)meteredRates);
        } else {
            MeteredRates meterRates = new MeteredRates();
            meterRates.setSlabName(slabName);
            model.addAttribute(METERED_RATES, (Object)meterRates);
        }
        model.addAttribute("mode", (Object)"view");
        return "metered-rate-search";
    }
}

