/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.io.ByteArrayInputStream;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.WordUtils;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.pims.commons.Designation;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/application"})
public class WorkOrderController {
    public static final String CONNECTIONWORKORDER = "connectionWorkOrder";
    @Autowired
    private ReportService reportService;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private WaterConnectionDetailsService wcdService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private SecurityUtils securityUtils;

    @RequestMapping(value={"/workorder"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> createWorkOrderReport(HttpServletRequest request, HttpSession session) {
        String errorMessage = "";
        WaterConnectionDetails connectionDetails = this.wcdService.findByApplicationNumber(request.getParameter("pathVar"));
        String workFlowAction = (String)session.getAttribute("workFlowAction");
        Boolean isDigSignPending = Boolean.parseBoolean(request.getParameter("isDigSignPending"));
        if (isDigSignPending.booleanValue()) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (null != workFlowAction && !workFlowAction.isEmpty() && workFlowAction.equalsIgnoreCase("Generate WorkOrder")) {
            errorMessage = this.validateWorkOrder(connectionDetails, Boolean.valueOf(true));
        }
        if (!errorMessage.isEmpty()) {
            return this.redirect(errorMessage);
        }
        return this.generateReport(connectionDetails, session, workFlowAction);
    }

    private ResponseEntity<byte[]> generateReport(WaterConnectionDetails connectionDetails, HttpSession session, String workFlowAction) {
        ReportRequest reportInput = null;
        if (null != connectionDetails) {
            Object assignList;
            HashMap<String, Object> reportParams = new HashMap<String, Object>();
            AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(connectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ACTIVE);
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            String[] doorno = assessmentDetails.getPropertyAddress().split(",");
            String ownerName = "";
            String commissionerName = "";
            Designation desgn = this.designationService.getDesignationByName("Commissioner");
            if (desgn != null) {
                assignList = this.assignmentService.getAllActiveAssignments(desgn.getId());
                String string = commissionerName = !assignList.isEmpty() ? ((Assignment)assignList.get(0)).getEmployee().getName() : "";
            }
            if ((assignList = assessmentDetails.getOwnerNames().iterator()).hasNext()) {
                OwnerName names = (OwnerName)assignList.next();
                ownerName = names.getOwnerName();
            }
            if ("NEWCONNECTION".equalsIgnoreCase(connectionDetails.getApplicationType().getCode())) {
                reportParams.put("conntitle", WordUtils.capitalize((String)connectionDetails.getApplicationType().getName()).toString());
                reportParams.put("applicationType", this.messageSource.getMessage("msg.new.watertap.conn", null, null));
            } else if ("ADDNLCONNECTION".equalsIgnoreCase(connectionDetails.getApplicationType().getCode())) {
                reportParams.put("conntitle", WordUtils.capitalize((String)connectionDetails.getApplicationType().getName()).toString());
                reportParams.put("applicationType", this.messageSource.getMessage("msg.add.watertap.conn", null, null));
            } else {
                reportParams.put("conntitle", WordUtils.capitalize((String)connectionDetails.getApplicationType().getName()).toString());
                reportParams.put("applicationType", this.messageSource.getMessage("msg.changeofuse.watertap.conn", null, null));
            }
            reportParams.put("municipality", session.getAttribute("citymunicipalityname"));
            reportParams.put("district", session.getAttribute("districtName"));
            reportParams.put("purpose", connectionDetails.getUsageType().getName());
            User user = this.securityUtils.getCurrentUser();
            Assignment assignment = this.assignmentService.getPrimaryAssignmentForUser(user.getId());
            String userDesignation = assignment.getDesignation().getName();
            if (null != workFlowAction) {
                if (workFlowAction.equalsIgnoreCase("Generate WorkOrder")) {
                    reportParams.put("workOrderDate", formatter.format(connectionDetails.getWorkOrderDate()));
                    reportParams.put("workOrderNo", connectionDetails.getWorkOrderNumber());
                }
                if (workFlowAction.equalsIgnoreCase("Preview")) {
                    reportParams.put("workOrderDate", "");
                    reportParams.put("workOrderNo", "");
                }
                if (workFlowAction.equalsIgnoreCase("Sign")) {
                    reportParams.put("workOrderDate", formatter.format(connectionDetails.getWorkOrderDate()));
                    reportParams.put("workOrderNo", connectionDetails.getWorkOrderNumber());
                    reportParams.put("userId", user.getId());
                }
            }
            reportParams.put("designation", userDesignation);
            reportParams.put("workFlowAction", workFlowAction);
            reportParams.put("consumerNumber", connectionDetails.getConnection().getConsumerCode());
            reportParams.put("applicantName", WordUtils.capitalize((String)ownerName));
            reportParams.put("applicantionDate", formatter.format(connectionDetails.getApplicationDate()));
            reportParams.put("address", assessmentDetails.getPropertyAddress());
            reportParams.put("doorno", doorno[0]);
            reportParams.put("userSignature", this.securityUtils.getCurrentUser().getSignature() != null ? new ByteArrayInputStream(this.securityUtils.getCurrentUser().getSignature()) : null);
            reportParams.put("applicationDate", formatter.format(connectionDetails.getApplicationDate()));
            reportParams.put("donationCharges", connectionDetails.getDonationCharges());
            reportParams.put("securityDeposit", connectionDetails.getFieldInspectionDetails().getSecurityDeposit());
            reportParams.put("roadCuttingCharges", connectionDetails.getFieldInspectionDetails().getRoadCuttingCharges());
            reportParams.put("superVisionCharges", connectionDetails.getFieldInspectionDetails().getSupervisionCharges());
            reportParams.put("locality", assessmentDetails.getBoundaryDetails().getLocalityName());
            reportParams.put("commissionerName", commissionerName);
            double total = connectionDetails.getDonationCharges() + connectionDetails.getFieldInspectionDetails().getSecurityDeposit() + connectionDetails.getFieldInspectionDetails().getRoadCuttingCharges() + connectionDetails.getFieldInspectionDetails().getSupervisionCharges();
            reportParams.put("total", total);
            reportInput = new ReportRequest(CONNECTIONWORKORDER, (Object)connectionDetails, reportParams);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=Work Order.pdf");
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    public String validateWorkOrder(WaterConnectionDetails connectionDetails, Boolean isView) {
        String errorMessage = "";
        if (connectionDetails != null) {
            if (connectionDetails.getLegacy().booleanValue()) {
                errorMessage = this.messageSource.getMessage("err.validate.workorder.for.legacy", (Object[])new String[]{""}, null);
            } else if (isView.booleanValue() && connectionDetails.getWorkOrderNumber() == null) {
                errorMessage = this.messageSource.getMessage("err.validate.workorder.view", (Object[])new String[]{connectionDetails.getApplicationNumber()}, null);
            } else if (!isView.booleanValue() && !connectionDetails.getStatus().getCode().equalsIgnoreCase("WORKORDERGENERATED")) {
                errorMessage = this.messageSource.getMessage("err.validate.workorder.view", (Object[])new String[]{connectionDetails.getApplicationNumber()}, null);
            }
        }
        return errorMessage;
    }

    @RequestMapping(value={"/workorder/view/{applicationNumber}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> viewReport(@PathVariable String applicationNumber, HttpSession session) {
        WaterConnectionDetails connectionDetails = this.wcdService.findByApplicationNumber(applicationNumber);
        String errorMessage = this.validateWorkOrder(connectionDetails, Boolean.valueOf(true));
        if (!errorMessage.isEmpty()) {
            return this.redirect(errorMessage);
        }
        return this.generateReport(connectionDetails, session, null);
    }

    private ResponseEntity<byte[]> redirect(String errorMessage) {
        String formattedErrorMsg = "<html><body><p style='color:red;border:1px solid gray;padding:15px;'>" + errorMessage + "</p></body></html>";
        byte[] byteData = formattedErrorMsg.getBytes();
        return new ResponseEntity((Object)byteData, HttpStatus.CREATED);
    }
}

