/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.util.ArrayList;
import javax.validation.ValidationException;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.ConnectionDetails;
import org.egov.wtms.application.entity.ConnectionRectification;
import org.egov.wtms.application.entity.PropertyAssessmentDetails;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/application"})
public class ConnectionRectificationController {
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;

    @RequestMapping(value={"/connectionrectification"}, method={RequestMethod.GET})
    public String viewForm(Model model) {
        ConnectionRectification connectionRectification = new ConnectionRectification();
        model.addAttribute("connectionRectification", (Object)connectionRectification);
        model.addAttribute("mode", (Object)"disable");
        return "connection-rectification";
    }

    @RequestMapping(value={"/connectionrectification"}, method={RequestMethod.POST})
    public String searchConnections(@ModelAttribute ConnectionRectification connectionRectification, BindingResult resultBinder, RedirectAttributes redirectAttrs, Model model) {
        ArrayList<WaterConnectionDetails> waterConnectionDetailsList = new ArrayList<WaterConnectionDetails>(0);
        WaterConnectionDetails waterconnectionDetails = null;
        if (connectionRectification.getConsumerNo() != null) {
            waterconnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(connectionRectification.getConsumerNo(), ConnectionStatus.ACTIVE);
            if (waterconnectionDetails == null) {
                waterconnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(connectionRectification.getConsumerNo(), ConnectionStatus.INACTIVE);
            }
            if (waterconnectionDetails != null) {
                waterConnectionDetailsList.add(waterconnectionDetails);
                connectionRectification.setAssessmentNo(waterconnectionDetails.getConnection().getPropertyIdentifier());
            }
        } else {
            waterConnectionDetailsList.addAll(this.waterConnectionDetailsService.getAllConnectionDetailsByPropertyID(connectionRectification.getAssessmentNo()));
        }
        PropertyAssessmentDetails propertyAssessmentDetails = new PropertyAssessmentDetails();
        ArrayList<ConnectionDetails> connectionDetailsList = new ArrayList<ConnectionDetails>();
        if (!waterConnectionDetailsList.isEmpty()) {
            AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(connectionRectification.getAssessmentNo(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
            if (!assessmentDetails.isStatus()) {
                throw new ValidationException("err.inactive.property");
            }
            propertyAssessmentDetails.setAssessmentNumber(connectionRectification.getAssessmentNo());
            propertyAssessmentDetails.setStatus(assessmentDetails.isStatus() ? "ACTIVE" : "INACTIVE");
            propertyAssessmentDetails.setOwnerName(((OwnerName)new ArrayList(assessmentDetails.getOwnerNames()).get(0)).getOwnerName().toString());
            propertyAssessmentDetails.setAddress(assessmentDetails.getPropertyAddress());
            for (WaterConnectionDetails waterConnectionDetails : waterConnectionDetailsList) {
                ConnectionDetails connectionDetails = new ConnectionDetails();
                connectionDetails.setConsumerNumber(waterConnectionDetails.getConnection().getConsumerCode());
                connectionDetails.setIsPrimary(waterConnectionDetails.getConnection().getParentConnection() != null ? "NO" : "YES");
                connectionDetails.setDemandDue(this.waterConnectionDetailsService.getTotalDemandTillCurrentFinYear(waterConnectionDetails).doubleValue());
                connectionDetails.setStatus(waterConnectionDetails.getConnectionStatus().toString());
                connectionDetailsList.add(connectionDetails);
            }
        } else {
            return "connection-rectification";
        }
        connectionRectification.setPropertyAssessmentDetails(propertyAssessmentDetails);
        connectionRectification.setConnectionDetailsList(connectionDetailsList);
        model.addAttribute("connectionRectification", (Object)connectionRectification);
        model.addAttribute("mode", (Object)"enable");
        return "connection-rectification";
    }
}

