/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import com.google.gson.JsonObject;
import java.util.Date;
import java.util.List;
import org.egov.commons.entity.ChairPerson;
import org.egov.commons.service.ChairPersonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/application"})
public class ChairPersonMasterController {
    @Autowired
    private ChairPersonService chairPersonService;
    public static final String CONTENTTYPE_JSON = "application/json";

    @RequestMapping(value={"/chairperson-create"}, method={RequestMethod.GET})
    public String createForm(@ModelAttribute ChairPerson chairPerson) {
        return "chairperson-create";
    }

    @RequestMapping(value={"/chairperson-create"}, method={RequestMethod.POST})
    public String createChairPerson(@ModelAttribute ChairPerson chairPerson, Model model) {
        ChairPerson chairPersonFromDb = this.chairPersonService.getActiveChairPerson();
        this.chairPersonService.createChairPerson(chairPerson);
        if (chairPersonFromDb != null) {
            chairPersonFromDb.setActive(false);
            this.chairPersonService.updateChairPerson(chairPersonFromDb);
        }
        model.addAttribute("mode", (Object)"create");
        model.addAttribute("message", (Object)"Chair Person Created Successfully");
        return "chairperson-success";
    }

    @RequestMapping(value={"/ajax-activeChairPersonExistsAsOnCurrentDate"}, method={RequestMethod.GET})
    @ResponseBody
    public ChairPerson getChairPersonName(@RequestParam String name) {
        if (this.chairPersonService.getActiveChairPerson() != null) {
            return this.chairPersonService.getActiveChairPerson();
        }
        return new ChairPerson();
    }

    @RequestMapping(value={"/chairperson-view"}, method={RequestMethod.GET})
    public String getChairPersonMasterList(Model model) {
        List chairPersonList = this.chairPersonService.findAll();
        model.addAttribute("chairPersonList", (Object)chairPersonList);
        return "chairperson-view";
    }

    @RequestMapping(value={"/chairperson-edit"}, method={RequestMethod.GET})
    public String getChairPersonMaster(Model model) {
        model.addAttribute("mode", (Object)"edit");
        return this.getChairPersonMasterList(model);
    }

    @RequestMapping(value={"/chairperson-edit/{chairpersonid}"}, method={RequestMethod.GET})
    public String modifyChairPerson(@ModelAttribute ChairPerson chairPerson, @PathVariable Long chairpersonid, Model model) {
        ChairPerson chairPersonFromDb = this.chairPersonService.findById(chairpersonid);
        if (chairPersonFromDb != null) {
            model.addAttribute("chairPerson", (Object)chairPersonFromDb);
        }
        return "chairpersondetails-edit";
    }

    @RequestMapping(value={"/chairperson-edit/{chairpersonid}"}, method={RequestMethod.POST})
    public String saveModifiedChairPerson(@ModelAttribute ChairPerson chairPerson, Model model, RedirectAttributes redirectAttrs, @PathVariable(value="chairpersonid") Long chairpersonid) {
        ChairPerson chairPersonFromDB;
        ChairPerson oldActiveChairPerson = this.chairPersonService.getActiveChairPerson();
        if (oldActiveChairPerson != null && oldActiveChairPerson.getId() != chairpersonid) {
            oldActiveChairPerson.setActive(false);
            this.chairPersonService.updateChairPerson(oldActiveChairPerson);
        }
        if ((chairPersonFromDB = this.chairPersonService.findById(chairpersonid)) != null) {
            chairPersonFromDB.setActive(chairPerson.isActive());
            chairPersonFromDB.setName(chairPerson.getName());
            chairPersonFromDB.setFromDate(chairPerson.getFromDate());
            chairPersonFromDB.setToDate(chairPerson.getToDate());
            this.chairPersonService.updateChairPerson(chairPersonFromDB);
        }
        model.addAttribute("message", (Object)"Chair Person Updated Successfully");
        return "chairperson-success";
    }

    @RequestMapping(value={"/ajax-activeChairPersonExistsAsOnGivenDate"}, method={RequestMethod.GET})
    @ResponseBody
    public String getChairPersonNameOnGivenDate(@RequestParam Date fromdate, @RequestParam Date toDate) {
        JsonObject jsonObj = new JsonObject();
        ChairPerson chairperson = this.chairPersonService.getActiveChairPersonByGivenDate(fromdate, toDate);
        if (chairperson != null) {
            jsonObj.addProperty("fromDate", chairperson.getFromDate().toString());
            jsonObj.addProperty("toDate", chairperson.getToDate().toString());
        }
        return jsonObj.toString();
    }
}

