/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.AssignmentAdaptor;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.pims.commons.Designation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AjaxController {
    @Autowired
    private DesignationService designationService;
    @Autowired
    private AssignmentService assignmentService;

    @RequestMapping(value={"/ajax-designationsByDepartment"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Designation> getDesignationsByDepartmentId(@ModelAttribute(value="designations") @RequestParam Long approvalDepartment) {
        List<Object> designations = new ArrayList<Designation>();
        if (approvalDepartment != null && approvalDepartment != 0L && approvalDepartment != -1L) {
            designations = this.designationService.getAllDesignationByDepartment(approvalDepartment, new Date());
        }
        designations.forEach(designation -> designation.toString());
        return designations;
    }

    @RequestMapping(value={"/ajax-positionsByDepartmentAndDesignation"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String getPositionByDepartmentAndDesignation(@RequestParam Long approvalDepartment, @RequestParam Long approvalDesignation, HttpServletResponse response) {
        List assignmentList = new ArrayList();
        if (approvalDepartment != null && approvalDepartment != 0L && approvalDepartment != -1L && approvalDesignation != null && approvalDesignation != 0L && approvalDesignation != -1L) {
            assignmentList = this.assignmentService.findAllAssignmentsByDeptDesigAndDates(approvalDepartment, approvalDesignation, new Date());
            Gson jsonCreator = new GsonBuilder().registerTypeAdapter(Assignment.class, (Object)new AssignmentAdaptor()).create();
            return jsonCreator.toJson(assignmentList, new /* Unavailable Anonymous Inner Class!! */.getType());
        }
        return "[]";
    }
}

