/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.masters;

import java.util.List;
import javax.validation.Valid;
import org.egov.wtms.masters.entity.WaterSource;
import org.egov.wtms.masters.service.WaterSourceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/masters"})
public class WaterSourceMasterController {
    @Autowired
    private WaterSourceService waterSourceService;

    @RequestMapping(value={"/waterSourceTypeMaster"}, method={RequestMethod.GET})
    public String viewForm(Model model) {
        WaterSource waterSource = new WaterSource();
        model.addAttribute("waterSource", (Object)waterSource);
        model.addAttribute("reqAttr", (Object)false);
        model.addAttribute("mode", (Object)"create");
        return "water-source-master";
    }

    @RequestMapping(value={"/waterSourceTypeMaster"}, method={RequestMethod.POST})
    public String createWaterSourceTypeMaster(@Valid @ModelAttribute WaterSource waterSource, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            return "water-source-master";
        }
        this.waterSourceService.createWaterSource(waterSource);
        redirectAttrs.addFlashAttribute("waterSource", (Object)waterSource);
        model.addAttribute("message", (Object)"Water Source created successfully.");
        model.addAttribute("mode", (Object)"create");
        return "water-source-master-success";
    }

    @RequestMapping(value={"/waterSourceTypeMaster/list"}, method={RequestMethod.GET})
    public String getWaterSourceTypeList(Model model) {
        List waterSourceList = this.waterSourceService.findAll();
        model.addAttribute("waterSourceList", (Object)waterSourceList);
        return "water-source-master-list";
    }

    @RequestMapping(value={"/waterSourceTypeMaster/edit"}, method={RequestMethod.GET})
    public String getWaterSourceType(Model model) {
        model.addAttribute("mode", (Object)"edit");
        return this.getWaterSourceTypeList(model);
    }

    @RequestMapping(value={"/waterSourceTypeMaster/edit/{waterSourceId}"}, method={RequestMethod.GET})
    public String getWaterSourceTypeDetails(Model model, @PathVariable String waterSourceId) {
        WaterSource waterSource = this.waterSourceService.findOne(Long.valueOf(Long.parseLong(waterSourceId)));
        model.addAttribute("waterSource", (Object)waterSource);
        model.addAttribute("reqAttr", (Object)"true");
        return "water-source-master";
    }

    @RequestMapping(value={"/waterSourceTypeMaster/edit/{waterSourceId}"}, method={RequestMethod.POST})
    public String editWaterSourceTypeData(@Valid @ModelAttribute WaterSource waterSource, BindingResult errors, RedirectAttributes redirectAttrs, Model model, @PathVariable long waterSourceId) {
        if (errors.hasErrors()) {
            return "water-source-master";
        }
        this.waterSourceService.updateWaterSource(waterSource);
        redirectAttrs.addFlashAttribute("WaterSource", (Object)waterSource);
        model.addAttribute("message", (Object)"Water Source updated successfully.");
        return "water-source-master-success";
    }
}

