/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.masters;

import java.util.List;
import javax.validation.Valid;
import org.egov.wtms.masters.entity.PipeSize;
import org.egov.wtms.masters.service.PipeSizeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/masters"})
public class PipeSizeMasterController {
    @Autowired
    private PipeSizeService pipeSizeService;

    @RequestMapping(value={"/pipesizeMaster"}, method={RequestMethod.GET})
    public String viewForm(Model model) {
        PipeSize pipeSize = new PipeSize();
        model.addAttribute("pipeSize", (Object)pipeSize);
        model.addAttribute("reqAttr", (Object)false);
        model.addAttribute("mode", (Object)"create");
        return "pipesize-master";
    }

    @RequestMapping(value={"/pipesizeMaster"}, method={RequestMethod.POST})
    public String addPipeSizeMasterData(@Valid @ModelAttribute PipeSize pipeSize, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            return "pipesize-master";
        }
        this.pipeSizeService.createPipeSize(pipeSize);
        redirectAttrs.addFlashAttribute("pipeSize", (Object)pipeSize);
        model.addAttribute("message", (Object)"PipeSize created successfully.");
        model.addAttribute("mode", (Object)"create");
        return "pipesize-master-success";
    }

    @RequestMapping(value={"/pipesizeMaster/list"}, method={RequestMethod.GET})
    public String getPipeSizeMasterList(Model model) {
        List pipeSizeList = this.pipeSizeService.findAll();
        model.addAttribute("pipeSizeList", (Object)pipeSizeList);
        return "pipesize-master-list";
    }

    @RequestMapping(value={"/pipesizeMaster/edit"}, method={RequestMethod.GET})
    public String getPipeSizeMaster(Model model) {
        model.addAttribute("mode", (Object)"edit");
        return this.getPipeSizeMasterList(model);
    }

    @RequestMapping(value={"/pipesizeMaster/edit/{pipeSizeId}"}, method={RequestMethod.GET})
    public String getPipeSizeMasterDetails(Model model, @PathVariable String pipeSizeId) {
        PipeSize pipeSize = this.pipeSizeService.findOne(Long.valueOf(Long.parseLong(pipeSizeId)));
        model.addAttribute("pipeSize", (Object)pipeSize);
        model.addAttribute("reqAttr", (Object)"true");
        return "pipesize-master";
    }

    @RequestMapping(value={"/pipesizeMaster/edit/{pipeSizeId}"}, method={RequestMethod.POST})
    public String editPipeSizeMasterData(@Valid @ModelAttribute PipeSize pipeSize, BindingResult errors, RedirectAttributes redirectAttrs, Model model, @PathVariable long pipeSizeId) {
        if (errors.hasErrors()) {
            return "pipesize-master";
        }
        this.pipeSizeService.updatePipeSize(pipeSize);
        redirectAttrs.addFlashAttribute("pipeSize", (Object)pipeSize);
        model.addAttribute("message", (Object)"PipeSize updated successfully.");
        return "pipesize-master-success";
    }
}

