/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.dashboard;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.egov.wtms.bean.dashboard.TaxPayerResponseDetails;
import org.egov.wtms.bean.dashboard.WaterChargeConnectionTypeResponse;
import org.egov.wtms.bean.dashboard.WaterChargeDashBoardRequest;
import org.egov.wtms.bean.dashboard.WaterChargeDashBoardResponse;
import org.egov.wtms.bean.dashboard.WaterTaxDefaulters;
import org.egov.wtms.service.dashboard.WaterChargeDashboardService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/public/dashboard", "/dashboard"})
public class WaterChargeCMDashboardController {
    private static final Logger LOGGER = LoggerFactory.getLogger(WaterChargeCMDashboardController.class);
    @Autowired
    private WaterChargeDashboardService waterChargeDashboardService;

    @RequestMapping(value={"/waterchargecollectiondashboard"}, method={RequestMethod.POST}, produces={"application/json"})
    public Map<String, List<WaterChargeDashBoardResponse>> getCollectionDetails(@RequestBody WaterChargeDashBoardRequest collectionDetailsRequest) throws IOException {
        Long startTime = System.currentTimeMillis();
        Map collectionDetails = this.waterChargeDashboardService.getCollectionIndexDetails(collectionDetailsRequest);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve collectiondashboard is (millisecs): " + timeTaken);
        }
        return collectionDetails;
    }

    @RequestMapping(value={"/waterchargereceipttransactions"}, method={RequestMethod.POST}, produces={"application/json"})
    public Map<String, List<WaterChargeDashBoardResponse>> getReceiptTransactions(@RequestBody WaterChargeDashBoardRequest collectionDetailsRequest) throws IOException {
        Long startTime = System.currentTimeMillis();
        Map collReceiptDetails = this.waterChargeDashboardService.getReceiptDetails(collectionDetailsRequest);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve receipttransactions is  (millisecs): " + timeTaken);
        }
        return collReceiptDetails;
    }

    @RequestMapping(value={"/waterchargeconnectionType"}, method={RequestMethod.POST}, produces={"application/json"})
    public Map<String, List<WaterChargeConnectionTypeResponse>> getConnectionTypeDashBoard(@RequestBody WaterChargeDashBoardRequest collectionDetailsRequest) throws IOException {
        Long startTime = System.currentTimeMillis();
        Map collReceiptDetails = this.waterChargeDashboardService.getCollectionTypeIndexDetails(collectionDetailsRequest);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve receipttransactions is  (millisecs): " + timeTaken);
        }
        return collReceiptDetails;
    }

    @RequestMapping(value={"/waterchargetoptentaxers"}, method={RequestMethod.POST}, produces={"application/json"})
    public TaxPayerResponseDetails getTopTenTaxProducers(@RequestBody WaterChargeDashBoardRequest collectionDetailsRequest) throws IOException {
        Long startTime = System.currentTimeMillis();
        TaxPayerResponseDetails taxPayerDetails = this.waterChargeDashboardService.getTopTenTaxProducers(collectionDetailsRequest);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve toptentaxers is :  (millisecs)" + timeTaken);
        }
        return taxPayerDetails;
    }

    @RequestMapping(value={"/waterchargebottomtentaxers"}, method={RequestMethod.POST}, produces={"application/json"})
    public TaxPayerResponseDetails getBottomTenTaxProducers(@RequestBody WaterChargeDashBoardRequest waterChargeDashBoardRequest) throws IOException {
        Long startTime = System.currentTimeMillis();
        LOGGER.debug("waterChargeDashBoardRequest input : regionName = " + waterChargeDashBoardRequest.getRegionName() + ", districtName = " + waterChargeDashBoardRequest.getDistrictName() + ", ulbGrade = " + waterChargeDashBoardRequest.getUlbGrade() + ", ulbCode = " + waterChargeDashBoardRequest.getUlbCode() + ", fromDate = " + waterChargeDashBoardRequest.getFromDate() + ", toDate = " + waterChargeDashBoardRequest.getToDate() + ", type = " + waterChargeDashBoardRequest.getType());
        TaxPayerResponseDetails taxPayerDetails = this.waterChargeDashboardService.getBottomTenTaxProducers(waterChargeDashBoardRequest);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve bottomtentaxers is millisecs) : " + timeTaken);
        }
        return taxPayerDetails;
    }

    @RequestMapping(value={"/waterchargetopdefaulters"}, method={RequestMethod.POST}, produces={"application/json"})
    public List<WaterTaxDefaulters> getTopTaxDefaulters(@RequestBody WaterChargeDashBoardRequest waterChargeDashBoardRequest) throws IOException {
        Long startTime = System.currentTimeMillis();
        List taxDefaulters = this.waterChargeDashboardService.getTaxDefaulters(waterChargeDashBoardRequest);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve topdefaulters is  (millisecs): " + timeTaken);
        }
        return taxDefaulters;
    }
}

