/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.utils.WaterTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/application"})
public class ViewConnectionController {
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private ConnectionDemandService connectionDemandService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private UserService userService;

    @RequestMapping(value={"/view/{applicationNumber}"}, method={RequestMethod.GET})
    public String view(Model model, @PathVariable String applicationNumber, HttpServletRequest request) {
        WaterConnectionDetails details = null;
        details = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(applicationNumber, ConnectionStatus.ACTIVE);
        if (details == null) {
            details = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(applicationNumber, ConnectionStatus.CLOSED);
        }
        if (details == null) {
            details = this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCode(applicationNumber);
        }
        model.addAttribute("applicationDocList", (Object)this.waterConnectionDetailsService.getApplicationDocForExceptClosureAndReConnection(details));
        model.addAttribute("waterConnectionDetails", (Object)details);
        model.addAttribute("connectionType", this.waterConnectionDetailsService.getConnectionTypesMap().get(details.getConnectionType().name()));
        model.addAttribute("feeDetails", (Object)this.connectionDemandService.getSplitFee(details));
        model.addAttribute("checkOperator", (Object)this.waterTaxUtils.checkCollectionOperatorRole());
        model.addAttribute("citizenRole", (Object)this.waterTaxUtils.getCitizenUserRole());
        BigDecimal waterTaxDueforParent = this.waterConnectionDetailsService.getTotalAmount(details);
        model.addAttribute("waterTaxDueforParent", (Object)waterTaxDueforParent);
        model.addAttribute("mode", (Object)"search");
        return "application-view";
    }

    @ModelAttribute(value="cscUserRole")
    public String getCurrentUserRole() {
        String cscUserRole = "";
        User currentUser = null;
        currentUser = ApplicationThreadLocals.getUserId() != null ? this.userService.getUserById(ApplicationThreadLocals.getUserId()) : this.securityUtils.getCurrentUser();
        for (Role userrole : currentUser.getRoles()) {
            if (!userrole.getName().equals("CSC Operator")) continue;
            cscUserRole = userrole.getName();
            break;
        }
        return cscUserRole;
    }

    @ModelAttribute(value="ulbUserRole")
    public String getUlbOperatorUserRole() {
        String userRole = "";
        User currentUser = null;
        currentUser = ApplicationThreadLocals.getUserId() != null ? this.userService.getUserById(ApplicationThreadLocals.getUserId()) : this.securityUtils.getCurrentUser();
        for (Role userrole : currentUser.getRoles()) {
            if (!userrole.getName().equals("ULB Operator")) continue;
            userRole = userrole.getName();
            break;
        }
        return userRole;
    }
}

