/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.util.List;
import javax.validation.ValidationException;
import org.egov.wtms.application.entity.LinkedAssessment;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.service.ApplicationTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/application"})
public class LinkedAssessmentController {
    public static final String LINKED_ASSESSMENT = "linked-assessment";
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private ApplicationTypeService applicationTypeService;

    @RequestMapping(value={"/linkedAssessment"}, method={RequestMethod.GET})
    public String viewForm(Model model) {
        model.addAttribute("linkedAssessment", (Object)new LinkedAssessment());
        return LINKED_ASSESSMENT;
    }

    @RequestMapping(value={"/linkedAssessment"}, method={RequestMethod.POST})
    public String linkActiveAssessments(@ModelAttribute LinkedAssessment linkedAssessment, BindingResult resultBinder, RedirectAttributes redirectAttrs, Model model) {
        if (linkedAssessment.getPropertyAssessmentDetails().getStatus().equalsIgnoreCase("ACTIVE")) {
            throw new ValidationException("err.assessment.no.active");
        }
        if (linkedAssessment.getActiveAssessmentDetails().getStatus().equalsIgnoreCase("INACTIVE")) {
            throw new ValidationException("err.assessment.no.inactive");
        }
        List waterconnectiondetailslist = this.waterConnectionDetailsService.getAllConnectionDetailsByPropertyID(linkedAssessment.getPropertyAssessmentDetails().getAssessmentNumber());
        List activeWaterConnectionDetailsList = this.waterConnectionDetailsService.getAllConnectionDetailsByPropertyID(linkedAssessment.getActiveAssessmentDetails().getAssessmentNumber());
        if (!waterconnectiondetailslist.isEmpty()) {
            for (WaterConnectionDetails connectionDetails : waterconnectiondetailslist) {
                WaterConnectionDetails waterconnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(connectionDetails.getConnection().getConsumerCode(), ConnectionStatus.ACTIVE);
                waterconnectionDetails.getConnection().setPropertyIdentifier(linkedAssessment.getActiveAssessmentDetails().getAssessmentNumber());
                if (!activeWaterConnectionDetailsList.isEmpty()) {
                    waterconnectionDetails.getConnection().setParentConnection(null);
                    waterconnectionDetails.setApplicationType(this.applicationTypeService.findByCode("ADDNLCONNECTION"));
                }
                this.waterConnectionDetailsService.save(waterconnectionDetails);
            }
            model.addAttribute("linkedAssessment", (Object)linkedAssessment);
            return LINKED_ASSESSMENT;
        }
        throw new ValidationException("err.no.active.connections");
    }
}

