/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ValidationException;
import org.egov.wtms.application.entity.DuplicateConnection;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/application"})
public class DuplicateConnectionController {
    public static final String DUPLICATECONSUMERCODE = "duplicate-consumercode";
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;

    @RequestMapping(value={"/duplicateConsumerCode/{consumerCode}"}, method={RequestMethod.GET})
    public String view(Model model, @PathVariable String consumerCode, HttpServletRequest request) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(consumerCode, ConnectionStatus.ACTIVE);
        if (waterConnectionDetails == null) {
            throw new ValidationException("err.hsc.no.inactive");
        }
        List waterConnectionDetailsList = this.waterConnectionDetailsService.getAllConnectionDetailsByPropertyID(waterConnectionDetails.getConnection().getPropertyIdentifier());
        ArrayList<String> consumerCodes = new ArrayList<String>(0);
        for (WaterConnectionDetails waterconnectionDetails : waterConnectionDetailsList) {
            if (waterconnectionDetails.getConnection().getConsumerCode().equalsIgnoreCase(consumerCode)) continue;
            consumerCodes.add(waterconnectionDetails.getConnection().getConsumerCode());
        }
        DuplicateConnection duplicateConnection = new DuplicateConnection();
        duplicateConnection.setConsumerCodes(consumerCodes);
        duplicateConnection.setConsumerNo(consumerCode);
        model.addAttribute("duplicateConnection", (Object)duplicateConnection);
        return DUPLICATECONSUMERCODE;
    }

    @RequestMapping(value={"/duplicateConsumerCode/{consumerCode}"}, method={RequestMethod.POST})
    public String closeConnection(@ModelAttribute DuplicateConnection duplicateConnection, @PathVariable String consumerCode, BindingResult resultBinder, RedirectAttributes redirectAttrs, Model model) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(consumerCode, ConnectionStatus.ACTIVE);
        if (waterConnectionDetails == null) {
            throw new ValidationException("err.hsc.no.inactive");
        }
        waterConnectionDetails.setReferenceNumber(duplicateConnection.getReferenceNumber());
        waterConnectionDetails.setDeactivateReason(duplicateConnection.getDeactivateReason());
        waterConnectionDetails.setConnectionStatus(ConnectionStatus.INACTIVE);
        if (!duplicateConnection.getConsumerCodes().isEmpty()) {
            waterConnectionDetails.getConnection().setOldConsumerNumber((String)duplicateConnection.getConsumerCodes().get(0));
        }
        this.waterConnectionDetailsService.save(waterConnectionDetails);
        return "connection-rectification";
    }
}

