/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.ValidationException;
import org.apache.commons.io.FileUtils;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.repository.FileStoreMapperRepository;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.WorkflowTypes;
import org.egov.infra.workflow.inbox.InboxRenderServiceDeligate;
import org.egov.infra.workflow.service.WorkflowTypeService;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ReportGenerationService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.autonumber.WorkOrderNumberGenerator;
import org.egov.wtms.masters.service.UsageTypeService;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/digitalSignature"})
public class DigitalSignatureConnectionController {
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private InboxRenderServiceDeligate<StateAware> inboxRenderServiceDeligate;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private WorkflowTypeService workflowTypeService;
    @Autowired
    protected UsageTypeService usageTypeService;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private ReportGenerationService reportGenerationService;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;
    @Autowired
    private FileStoreMapperRepository fileStoreMapperRepository;

    @RequestMapping(value={"/waterTax/transitionWorkflow"})
    public String transitionWorkflow(HttpServletRequest request, Model model) {
        String fileStoreIds = request.getParameter("fileStoreId");
        String[] fileStoreIdArr = fileStoreIds.split(",");
        HttpSession session = request.getSession();
        String sourceChannel = request.getParameter("Source");
        Long approvalPosition = (Long)session.getAttribute("approvalPosition");
        String approvalComent = (String)session.getAttribute("approvalComment");
        Map appNoFileStoreIdsMap = (Map)session.getAttribute("fileStoreIdApplicationNumber");
        for (String fileStoreId : fileStoreIdArr) {
            String applicationNumber = (String)appNoFileStoreIdsMap.get(fileStoreId);
            if (null == applicationNumber || applicationNumber.isEmpty()) continue;
            WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumber(applicationNumber);
            if (null == approvalPosition) {
                String additionalRule = waterConnectionDetails.getApplicationType().getCode();
                if (additionalRule.equalsIgnoreCase("CLOSINGCONNECTION")) {
                    additionalRule = "CLOSECONNECTION";
                }
                approvalPosition = this.waterConnectionDetailsService.getApprovalPositionByMatrixDesignation(waterConnectionDetails, approvalPosition, additionalRule, "", "Sign");
            }
            this.waterConnectionDetailsService.updateWaterConnection(waterConnectionDetails, approvalPosition, approvalComent, waterConnectionDetails.getApplicationType().getCode(), "Sign", "", null, sourceChannel);
        }
        model.addAttribute("successMessage", (Object)"Digitally Signed Successfully");
        model.addAttribute("fileStoreId", (Object)(fileStoreIdArr.length == 1 ? fileStoreIdArr[0] : ""));
        return "digitalSignature-success";
    }

    @RequestMapping(value={"/waterTax/downloadSignedWorkOrderConnection"})
    public void downloadSignedWorkOrderConnection(HttpServletRequest request, HttpServletResponse response) {
        String signedFileStoreId = request.getParameter("signedFileStoreId");
        File file = this.fileStoreService.fetch(signedFileStoreId, "WTMS");
        try {
            FileStoreMapper fileStoreMapper = this.fileStoreMapperRepository.findByFileStoreId(signedFileStoreId);
            ArrayList<ByteArrayInputStream> pdfs = new ArrayList<ByteArrayInputStream>();
            byte[] bFile = FileUtils.readFileToByteArray((File)file);
            pdfs.add(new ByteArrayInputStream(bFile));
            this.getServletResponse(response, pdfs, fileStoreMapper.getFileName());
        }
        catch (FileNotFoundException fileNotFoundExcep) {
            throw new ApplicationRuntimeException("Exception while loading file : " + fileNotFoundExcep);
        }
        catch (IOException ioExcep) {
            throw new ApplicationRuntimeException("Exception while generating work order : " + ioExcep);
        }
    }

    private HttpServletResponse getServletResponse(HttpServletResponse response, List<InputStream> pdfs, String filename) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] data = this.concatPDFs(pdfs, output);
            response.setHeader("Content-disposition", "attachment;filename=" + filename + ".pdf");
            response.setContentType("application/pdf");
            response.setContentLength(data.length);
            response.getOutputStream().write(data);
            return response;
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }

    private byte[] concatPDFs(List<InputStream> streamOfPDFFiles, ByteArrayOutputStream outputStream) {
        Document document = null;
        try {
            List<InputStream> pdfs = streamOfPDFFiles;
            ArrayList<PdfReader> readers = new ArrayList<PdfReader>();
            for (InputStream pdf : pdfs) {
                PdfReader pdfReader = new PdfReader(pdf);
                readers.add(pdfReader);
                if (null != document) continue;
                document = new Document(pdfReader.getPageSize(1));
            }
            PdfWriter writer = PdfWriter.getInstance(document, (OutputStream)outputStream);
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            int pageOfCurrentReaderPDF = 0;
            for (PdfReader pdfReader : readers) {
                while (pageOfCurrentReaderPDF < pdfReader.getNumberOfPages()) {
                    document.newPage();
                    PdfImportedPage page = writer.getImportedPage(pdfReader, ++pageOfCurrentReaderPDF);
                    cb.addTemplate((PdfTemplate)page, 0.0f, 0.0f);
                }
                pageOfCurrentReaderPDF = 0;
            }
            outputStream.flush();
            document.close();
            outputStream.close();
        }
        catch (Exception e) {
            throw new ValidationException(e.getMessage());
        }
        finally {
            if (document.isOpen()) {
                document.close();
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException ioe) {
                throw new ValidationException(ioe.getMessage());
            }
        }
        return outputStream.toByteArray();
    }

    @RequestMapping(value={"/digitalSignaturePending-form"}, method={RequestMethod.GET})
    public String searchForm(HttpServletRequest request, Model model) {
        String cityMunicipalityName = (String)request.getSession().getAttribute("citymunicipalityname");
        String districtName = (String)request.getSession().getAttribute("districtName");
        List resultList = this.getRecordsForDigitalSignature();
        model.addAttribute("digitalSignatureReportList", (Object)resultList);
        model.addAttribute("noticeType", (Object)"Special Notice");
        model.addAttribute("cityMunicipalityName", (Object)cityMunicipalityName);
        model.addAttribute("districtName", (Object)districtName);
        return "digitalSignaturePending-form";
    }

    @RequestMapping(value={"/waterTax/signWorkOrder"}, method={RequestMethod.POST})
    public String signWorkOrder(HttpServletRequest request, Model model) {
        String[] appNumberConTypePair = null;
        HashMap<String, String> fileStoreIdsApplicationNoMap = new HashMap<String, String>();
        StringBuilder fileStoreIds = new StringBuilder();
        String pathVar = request.getParameter("pathVar");
        String applicationNoStatePair = request.getParameter("applicationNoStatePair");
        String currentState = request.getParameter("currentState");
        String signAll = request.getParameter("signAll");
        WorkOrderNumberGenerator workOrderGen = (WorkOrderNumberGenerator)this.beanResolver.getAutoNumberServiceFor(WorkOrderNumberGenerator.class);
        if (pathVar != null) {
            String[] applicationNumbers = request.getParameter("pathVar").split(",");
            if (applicationNoStatePair != null) {
                appNumberConTypePair = applicationNoStatePair.split(",");
            }
            for (int i = 0; i < applicationNumbers.length; ++i) {
                String fileName;
                ReportOutput reportOutput;
                WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumber(applicationNumbers[i]);
                String cityMunicipalityName = (String)request.getSession().getAttribute("citymunicipalityname");
                String districtName = (String)request.getSession().getAttribute("districtName");
                waterConnectionDetails.setWorkOrderDate(new Date());
                waterConnectionDetails.setWorkOrderNumber(workOrderGen.generateWorkOrderNumber());
                if (signAll != null && signAll.equalsIgnoreCase("SIGN_ALL")) {
                    for (String element : appNumberConTypePair) {
                        String[] appNoStatePair = element.split(":");
                        if (!applicationNumbers[i].equalsIgnoreCase(appNoStatePair[0])) continue;
                        currentState = appNoStatePair[1];
                    }
                }
                if (currentState.equalsIgnoreCase("CLOSECONNECTION")) {
                    reportOutput = this.reportGenerationService.generateClosureConnectionReport(waterConnectionDetails, "Sign", cityMunicipalityName, districtName);
                    fileName = "SN/" + waterConnectionDetails.getApplicationNumber() + ".pdf";
                } else if (currentState.equalsIgnoreCase("RECONNECTION")) {
                    reportOutput = this.reportGenerationService.generateReconnectionReport(waterConnectionDetails, "Sign", cityMunicipalityName, districtName);
                    fileName = "SN/" + waterConnectionDetails.getApplicationNumber() + ".pdf";
                } else {
                    reportOutput = this.reportGenerationService.getReportOutput(waterConnectionDetails, "Sign", cityMunicipalityName, districtName);
                    fileName = "SN/" + waterConnectionDetails.getWorkOrderNumber() + ".pdf";
                }
                if (reportOutput == null) continue;
                ByteArrayInputStream fileStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
                FileStoreMapper fileStore = this.fileStoreService.store((InputStream)fileStream, fileName, "application/pdf", "WTMS");
                waterConnectionDetails.setFileStore(fileStore);
                waterConnectionDetails = this.waterConnectionDetailsService.updateWaterConnectionDetailsWithFileStore(waterConnectionDetails);
                fileStoreIdsApplicationNoMap.put(waterConnectionDetails.getFileStore().getFileStoreId(), applicationNumbers[i]);
                fileStoreIds.append(waterConnectionDetails.getFileStore().getFileStoreId());
                if (i >= applicationNumbers.length - 1) continue;
                fileStoreIds.append(",");
            }
            request.getSession().setAttribute("fileStoreIdApplicationNumber", fileStoreIdsApplicationNoMap);
            model.addAttribute("fileStoreIds", (Object)fileStoreIds.toString());
            model.addAttribute("ulbCode", (Object)ApplicationThreadLocals.getCityCode());
        }
        return "newConnection-digitalSignatureRedirection";
    }

    public List<HashMap<String, Object>> getRecordsForDigitalSignature() {
        ArrayList<HashMap<String, Object>> resultList = new ArrayList<HashMap<String, Object>>();
        List stateAwareList = this.fetchItems();
        if (null != stateAwareList && !stateAwareList.isEmpty()) {
            for (StateAware record : stateAwareList) {
                if (record == null || record.getState() == null || record.getState().getNextAction() == null || !record.getState().getNextAction().equalsIgnoreCase("Digital Signature Pending")) continue;
                HashMap<String, String> tempMap = new HashMap<String, String>();
                WorkflowTypes workflowTypes = this.workflowTypeService.getEnabledWorkflowTypeByType(record.getStateType());
                if (!"Water Tax Management".equalsIgnoreCase(workflowTypes.getModule().getName())) continue;
                WaterConnectionDetails waterConnectionDetails = (WaterConnectionDetails)record;
                tempMap.put("objectId", ((WaterConnectionDetails)record).getApplicationNumber());
                tempMap.put("type", record.getState().getNatureOfTask());
                tempMap.put("module", workflowTypes.getModule().getDisplayName());
                tempMap.put("details", record.getStateDetails());
                tempMap.put("hscNumber", waterConnectionDetails.getConnection().getConsumerCode());
                tempMap.put("status", record.getCurrentState().getValue());
                tempMap.put("applicationNumber", waterConnectionDetails.getApplicationNumber());
                tempMap.put("waterConnectionDetails", (String)waterConnectionDetails);
                tempMap.put("ownerName", this.getOwnerName(waterConnectionDetails));
                tempMap.put("propertyAddress", this.getPropertyAddress(waterConnectionDetails));
                String additionalRule = waterConnectionDetails.getApplicationType().getCode();
                if ("CLOSINGCONNECTION".equals(additionalRule)) {
                    additionalRule = "CLOSECONNECTION";
                }
                tempMap.put("state", additionalRule);
                resultList.add(tempMap);
            }
        }
        return resultList;
    }

    public List<StateAware> fetchItems() {
        ArrayList<StateAware> digitalSignWFItems = new ArrayList<StateAware>();
        digitalSignWFItems.addAll(this.inboxRenderServiceDeligate.getInboxItems(this.securityUtils.getCurrentUser().getId()));
        return digitalSignWFItems;
    }

    private String getOwnerName(WaterConnectionDetails waterConnectionDetails) {
        Iterator ownerNameItr;
        String ownerName = "";
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
        if (null != assessmentDetails && null != assessmentDetails.getOwnerNames() && (ownerNameItr = assessmentDetails.getOwnerNames().iterator()).hasNext()) {
            OwnerName owner = (OwnerName)ownerNameItr.next();
            ownerName = owner.getOwnerName() != null ? owner.getOwnerName() : ownerName;
        }
        return ownerName;
    }

    private String getPropertyAddress(WaterConnectionDetails waterConnectionDetails) {
        String propAddress = "";
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
        if (null != assessmentDetails) {
            propAddress = assessmentDetails.getPropertyAddress() != null ? assessmentDetails.getPropertyAddress() : propAddress;
        }
        return propAddress;
    }
}

