/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.eis.entity.Assignment;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.pims.commons.Position;
import org.egov.wtms.application.entity.ApplicationDocuments;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.CloserConnectionService;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.ConnectionCategory;
import org.egov.wtms.masters.entity.DocumentNames;
import org.egov.wtms.masters.entity.PipeSize;
import org.egov.wtms.masters.entity.UsageType;
import org.egov.wtms.masters.entity.enums.ClosureType;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.service.ApplicationTypeService;
import org.egov.wtms.utils.WaterTaxUtils;
import org.egov.wtms.web.controller.application.GenericConnectionController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.SmartValidator;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/application"})
public class CloserConnectionController
extends GenericConnectionController {
    private final WaterConnectionDetailsService waterConnectionDetailsService;
    private final DepartmentService departmentService;
    @Autowired
    private ConnectionDemandService connectionDemandService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private CloserConnectionService closerConnectionService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private UserService userService;
    @Autowired
    private ApplicationTypeService applicationTypeService;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource wcmsMessageSource;

    @Autowired
    public CloserConnectionController(WaterConnectionDetailsService waterConnectionDetailsService, DepartmentService departmentService, ConnectionDemandService connectionDemandService, SmartValidator validator) {
        this.waterConnectionDetailsService = waterConnectionDetailsService;
        this.departmentService = departmentService;
    }

    @ModelAttribute
    public WaterConnectionDetails getWaterConnectionDetails(@PathVariable String applicationCode) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(applicationCode, ConnectionStatus.ACTIVE);
        return waterConnectionDetails;
    }

    @ModelAttribute(value="connectionCategories")
    public List<ConnectionCategory> connectionCategories() {
        return this.connectionCategoryService.getAllActiveConnectionCategory();
    }

    @ModelAttribute(value="usageTypes")
    public List<UsageType> usageTypes() {
        return this.usageTypeService.getActiveUsageTypes();
    }

    @ModelAttribute(value="pipeSizes")
    public List<PipeSize> pipeSizes() {
        return this.pipeSizeService.getAllActivePipeSize();
    }

    @RequestMapping(value={"/close/{applicationCode}"}, method={RequestMethod.GET})
    public String view(Model model, @PathVariable String applicationCode, HttpServletRequest request) {
        WaterConnectionDetails waterConnectionDetails = this.getWaterConnectionDetails(applicationCode);
        return this.loadViewData(model, request, waterConnectionDetails);
    }

    @Transactional(readOnly=true)
    public String loadViewData(Model model, HttpServletRequest request, WaterConnectionDetails waterConnectionDetails) {
        waterConnectionDetails.setPreviousApplicationType(waterConnectionDetails.getApplicationType().getCode());
        model.addAttribute("previousApplicationType", (Object)waterConnectionDetails.getPreviousApplicationType());
        model.addAttribute("stateType", (Object)waterConnectionDetails.getClass().getSimpleName());
        model.addAttribute("applicationDocList", (Object)this.waterConnectionDetailsService.getApplicationDocForExceptClosureAndReConnection(waterConnectionDetails));
        model.addAttribute("additionalRule", (Object)"CLOSECONNECTION");
        model.addAttribute("currentUser", (Object)this.waterTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
        WorkflowContainer workflowContainer = new WorkflowContainer();
        workflowContainer.setAdditionalRule("CLOSECONNECTION");
        this.prepareWorkflow(model, (StateAware)waterConnectionDetails, workflowContainer);
        model.addAttribute("radioButtonMap", Arrays.asList(ClosureType.values()));
        model.addAttribute("loggedInCSCUser", (Object)this.waterTaxUtils.getCurrentUserRole());
        model.addAttribute("waterConnectionDetails", (Object)waterConnectionDetails);
        model.addAttribute("feeDetails", (Object)this.connectionDemandService.getSplitFee(waterConnectionDetails));
        model.addAttribute("connectionType", this.waterConnectionDetailsService.getConnectionTypesMap().get(waterConnectionDetails.getConnectionType().name()));
        model.addAttribute("applicationHistory", (Object)this.waterConnectionDetailsService.getHistory(waterConnectionDetails));
        model.addAttribute("approvalDepartmentList", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("typeOfConnection", (Object)"CLOSINGCONNECTION");
        model.addAttribute("mode", (Object)"closureConnection");
        model.addAttribute("validationMessage", (Object)this.closerConnectionService.validateChangeOfUseConnection(waterConnectionDetails));
        BigDecimal waterTaxDueforParent = this.waterConnectionDetailsService.getTotalAmount(waterConnectionDetails);
        model.addAttribute("waterTaxDueforParent", (Object)waterTaxDueforParent);
        return "connection-closeForm";
    }

    @RequestMapping(value={"/close/{applicationCode}"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute WaterConnectionDetails waterConnectionDetails, BindingResult resultBinder, RedirectAttributes redirectAttributes, HttpServletRequest request, Model model, BindingResult errors, @RequestParam(value="files") MultipartFile[] files) {
        Boolean applicationByOthers;
        String sourceChannel = request.getParameter("Source");
        String workFlowAction = "";
        if (request.getParameter("mode") != null) {
            request.getParameter("mode");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        Long approvalPosition = 0L;
        String approvalComent = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComent = request.getParameter("approvalComent");
        }
        if ((applicationByOthers = this.waterTaxUtils.getCurrentUserRole()) != null && applicationByOthers.equals(true)) {
            Position userPosition = this.waterTaxUtils.getZonalLevelClerkForLoggedInUser(waterConnectionDetails.getConnection().getPropertyIdentifier());
            if (userPosition == null) {
                model.addAttribute("noJAORSAMessage", (Object)"No JA/SA exists to forward the application.");
                return "connection-closeForm";
            }
            approvalPosition = userPosition.getId();
        }
        waterConnectionDetails.setPreviousApplicationType(request.getParameter("previousApplicationType"));
        List documentListForClosed = this.waterConnectionDetailsService.getAllActiveDocumentNames(this.applicationTypeService.findByCode("CLOSINGCONNECTION"));
        if (!documentListForClosed.isEmpty()) {
            ApplicationDocuments applicationDocument = new ApplicationDocuments();
            applicationDocument.setDocumentNames((DocumentNames)documentListForClosed.get(0));
            applicationDocument.setWaterConnectionDetails(waterConnectionDetails);
            applicationDocument.setSupportDocs(this.addToFileStore(files));
            applicationDocument.setDocumentNumber("111");
            applicationDocument.setDocumentDate(new Date());
            waterConnectionDetails.getApplicationDocs().add(applicationDocument);
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if (request.getParameter("closeConnectionType").equals("P")) {
            waterConnectionDetails.setCloseConnectionType(ClosureType.Permanent.getName());
        } else {
            waterConnectionDetails.setCloseConnectionType(ClosureType.Temporary.getName());
        }
        String addrule = request.getParameter("additionalRule");
        waterConnectionDetails.setConnectionStatus(ConnectionStatus.CLOSED);
        waterConnectionDetails.setApplicationType(this.applicationTypeService.findByCode("CLOSINGCONNECTION"));
        WaterConnectionDetails savedWaterConnectionDetails = this.closerConnectionService.updatecloserConnection(waterConnectionDetails, approvalPosition, approvalComent, addrule, workFlowAction, sourceChannel);
        model.addAttribute("waterConnectionDetails", (Object)savedWaterConnectionDetails);
        Assignment currentUserAssignment = this.assignmentService.getPrimaryAssignmentForGivenRange(this.securityUtils.getCurrentUser().getId(), new Date(), new Date());
        String nextDesign = "";
        Assignment assignObj = null;
        List<Object> asignList = null;
        if (approvalPosition != null) {
            assignObj = this.assignmentService.getPrimaryAssignmentForPositon(approvalPosition);
        }
        if (assignObj != null) {
            asignList = new ArrayList<Assignment>();
            asignList.add(assignObj);
        } else if (assignObj == null && approvalPosition != null) {
            asignList = this.assignmentService.getAssignmentsForPosition(approvalPosition, new Date());
        }
        nextDesign = !asignList.isEmpty() ? ((Assignment)asignList.get(0)).getDesignation().getName() : "";
        String pathVars = waterConnectionDetails.getApplicationNumber() + "," + this.waterTaxUtils.getApproverName(approvalPosition) + "," + (currentUserAssignment != null ? currentUserAssignment.getDesignation().getName() : "") + "," + (nextDesign != null ? nextDesign : "");
        return "redirect:/application/application-success?pathVars=" + pathVars;
    }
}

