/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import javax.servlet.http.HttpServletRequest;
import javax.validation.ValidationException;
import org.egov.wtms.application.entity.ActivateConnection;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.WaterRatesDetails;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/application"})
public class ActivateConsumerCodeController {
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private ConnectionDemandService connectionDemandService;

    @RequestMapping(value={"/activateConsumerCode/{consumerCode}"}, method={RequestMethod.GET})
    public String view(Model model, @PathVariable String consumerCode, HttpServletRequest request) {
        ActivateConnection activateConnection = new ActivateConnection();
        activateConnection.setConsumerNo(consumerCode);
        model.addAttribute("activateConnection", (Object)activateConnection);
        return "activate-consumercode";
    }

    @RequestMapping(value={"/activateConsumerCode/{consumerCode}"}, method={RequestMethod.POST})
    public String activateConnection(@ModelAttribute ActivateConnection activateConnection, @PathVariable String consumerCode, BindingResult resultBinder, RedirectAttributes redirectAttrs, Model model) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(consumerCode, ConnectionStatus.INACTIVE);
        if (waterConnectionDetails == null) {
            throw new ValidationException("err.hsc.no.active");
        }
        WaterRatesDetails waterRatesDetails = this.connectionDemandService.getWaterRatesDetailsForDemandUpdate(waterConnectionDetails);
        if (waterRatesDetails == null) {
            throw new ValidationException("err.water.rate.not.found");
        }
        waterConnectionDetails.setExecutionDate(activateConnection.getActivateDate());
        waterConnectionDetails.setReferenceNumber(activateConnection.getReferenceNo());
        waterConnectionDetails.setConnectionStatus(ConnectionStatus.ACTIVE);
        this.waterConnectionDetailsService.save(waterConnectionDetails);
        return "connection-rectification";
    }
}

