/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.rest;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.egov.wtms.application.rest.WaterChargesDetails;
import org.egov.wtms.application.rest.WaterTaxDue;
import org.egov.wtms.application.service.ConnectionDetailService;
import org.egov.wtms.masters.entity.WaterTaxDetailRequest;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RestWaterTaxController {
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    private ConnectionDetailService connectionDetailService;

    @RequestMapping(value={"rest/watertax/due/bycode/{consumerCode}"}, method={RequestMethod.GET}, produces={"application/json"})
    public WaterTaxDue getWaterTaxDueByConsumerCode(@PathVariable String consumerCode) throws JsonGenerationException, JsonMappingException, IOException {
        return this.connectionDetailService.getDueDetailsByConsumerCode(consumerCode);
    }

    @RequestMapping(value={"rest/watertax/totaldemandamount/"}, method={RequestMethod.GET}, produces={"application/json"})
    public WaterTaxDue getTotalDemand() throws JsonGenerationException, JsonMappingException, IOException {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"waterchargeconsumer"}).addAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"totaldemand").field("totalDemand")).build();
        Aggregations aggregations = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQuery, response -> response.getAggregations());
        Sum aggr = (Sum)aggregations.get("totaldemand");
        WaterTaxDue waterTaxDue = new WaterTaxDue();
        waterTaxDue.setCurrentDemand(BigDecimal.valueOf(aggr.getValue()).setScale(0, 4));
        return waterTaxDue;
    }

    @RequestMapping(value={"rest/watertax/due/byptno/{assessmentNumber}"}, method={RequestMethod.GET}, produces={"application/json"})
    public WaterTaxDue getWaterTaxDueByPropertyId(@PathVariable String assessmentNumber) throws JsonGenerationException, JsonMappingException, IOException {
        return this.connectionDetailService.getDueDetailsByPropertyId(assessmentNumber);
    }

    @RequestMapping(value={"rest/watertax/connectiondetails/byptno/{assessmentNumber}"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<WaterChargesDetails> getWaterConnectionDetailsByPropertyId(@PathVariable String assessmentNumber) throws JsonGenerationException, JsonMappingException, IOException {
        return this.connectionDetailService.getWaterTaxDetailsByPropertyId(assessmentNumber, null, null);
    }

    @RequestMapping(value={"rest/watertax/connectiondetails"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<WaterChargesDetails> getWaterConnectionDetailsByPropertyId(WaterTaxDetailRequest waterTaxDetailRequest) throws IOException {
        return this.connectionDetailService.getWaterTaxDetailsByPropertyId(waterTaxDetailRequest.getAssessmentNumber(), waterTaxDetailRequest.getUlbCode(), waterTaxDetailRequest.getConsumerNumber());
    }

    @RequestMapping(value={"rest/watertax/updateConnectionForAmulgamation"}, method={RequestMethod.POST}, produces={"application/json"})
    public String updateWaterConnectionForAmalagamation(@RequestBody WaterTaxDetailRequest waterTaxDetailRequest) throws IOException {
        return this.connectionDetailService.updateWaterConnectionDetails(waterTaxDetailRequest);
    }
}

