/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.reports;

import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.JsonUtils;
import org.egov.wtms.application.entity.DataEntryConnectionReport;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.DataEntryConnectionReportService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.reports.entity.DataEntryConnectionReportAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report/dataEntryConnectionReport/search"})
public class DataEntryConnectionReportController {
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private DataEntryConnectionReportService dataEntryConnectionReportService;
    @Autowired
    public WaterConnectionDetailsService waterConnectionDetailsService;

    @RequestMapping(method={RequestMethod.GET})
    public String search(Model model) {
        model.addAttribute("currentDate", (Object)new Date());
        return "dataEntryReport-search";
    }

    @ModelAttribute
    public DataEntryConnectionReport reportModel() {
        return new DataEntryConnectionReport();
    }

    @ModelAttribute(value="revenueWards")
    public List<Boundary> revenueWardList() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("WARD", "REVENUE");
    }

    @RequestMapping(value={"/result/"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void searchResult(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String ward = "";
        try {
            if (null != request.getParameter("ward")) {
                ward = request.getParameter("ward");
            }
            List dataEntryConnectionReportlist = this.dataEntryConnectionReportService.getDataEntryConnectionReportDetails(ward);
            for (DataEntryConnectionReport dataEntryReport : dataEntryConnectionReportlist) {
                WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCodeAndStatus(dataEntryReport.getHscNo(), ConnectionStatus.ACTIVE);
                if (waterConnectionDetails == null || waterConnectionDetails.getExistingConnection() == null) continue;
                dataEntryReport.setDonationCharges(waterConnectionDetails.getExistingConnection().getDonationCharges().doubleValue());
                dataEntryReport.setMonthlyFee(waterConnectionDetails.getExistingConnection().getMonthlyFee().doubleValue());
            }
            String result = "{ \"data\":" + JsonUtils.toJSON((Collection)dataEntryConnectionReportlist, DataEntryConnectionReport.class, DataEntryConnectionReportAdaptor.class) + "}";
            response.setContentType("application/json");
            IOUtils.write((String)result, (Writer)response.getWriter());
        }
        catch (ParseException e) {
            throw new ApplicationRuntimeException("Error while getting data entry report result " + e);
        }
    }
}

