/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.ValidationException;
import org.egov.eis.entity.Assignment;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.pims.commons.Position;
import org.egov.wtms.application.entity.ApplicationDocuments;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ChangeOfUseService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.DocumentNames;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.service.ApplicationTypeService;
import org.egov.wtms.utils.WaterTaxUtils;
import org.egov.wtms.web.controller.application.GenericConnectionController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/application"})
public class ChangeOfUseController
extends GenericConnectionController {
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private ApplicationTypeService applicationTypeService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private ChangeOfUseService changeOfUseService;

    @ModelAttribute(value="documentNamesList")
    public List<DocumentNames> documentNamesList(@ModelAttribute WaterConnectionDetails changeOfUse) {
        changeOfUse.setApplicationType(this.applicationTypeService.findByCode("CHANGEOFUSE"));
        return this.waterConnectionDetailsService.getAllActiveDocumentNames(changeOfUse.getApplicationType());
    }

    @RequestMapping(value={"/changeOfUse/{consumerCode}"}, method={RequestMethod.GET})
    public String showForm(WaterConnectionDetails parentConnectionDetails, @ModelAttribute WaterConnectionDetails changeOfUse, Model model, @PathVariable String consumerCode) {
        WaterConnectionDetails connectionUnderChange = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(consumerCode, ConnectionStatus.ACTIVE);
        parentConnectionDetails = null != connectionUnderChange.getConnection().getParentConnection() ? this.waterConnectionDetailsService.getParentConnectionDetailsForParentConnectionNotNull(consumerCode, ConnectionStatus.ACTIVE) : this.waterConnectionDetailsService.getParentConnectionDetails(connectionUnderChange.getConnection().getPropertyIdentifier(), ConnectionStatus.ACTIVE);
        if (parentConnectionDetails != null) {
            this.loadBasicData(model, parentConnectionDetails, changeOfUse, connectionUnderChange);
        }
        WorkflowContainer workflowContainer = new WorkflowContainer();
        workflowContainer.setAdditionalRule(changeOfUse.getApplicationType().getCode());
        this.prepareWorkflow(model, (StateAware)changeOfUse, workflowContainer);
        return "changeOfUse-form";
    }

    @RequestMapping(value={"/changeOfUse/changeOfUse-create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute WaterConnectionDetails changeOfUse, BindingResult resultBinder, RedirectAttributes redirectAttributes, HttpServletRequest request, Model model, @RequestParam String workFlowAction, BindingResult errors) {
        Boolean applicationByOthers;
        Boolean isJuniorAsstOrSeniorAsst;
        Boolean isCSCOperator = this.waterTaxUtils.isCSCoperator(this.securityUtils.getCurrentUser());
        if (!isCSCOperator.booleanValue() && !(isJuniorAsstOrSeniorAsst = this.waterTaxUtils.isLoggedInUserJuniorOrSeniorAssistant(this.securityUtils.getCurrentUser().getId())).booleanValue()) {
            throw new ValidationException("err.creator.application");
        }
        ArrayList<ApplicationDocuments> applicationDocs = new ArrayList<ApplicationDocuments>();
        WaterConnectionDetails connectionUnderChange = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(changeOfUse.getConnection().getConsumerCode(), ConnectionStatus.ACTIVE);
        WaterConnectionDetails parent = this.waterConnectionDetailsService.getParentConnectionDetails(connectionUnderChange.getConnection().getPropertyIdentifier(), ConnectionStatus.ACTIVE);
        String message = this.changeOfUseService.validateChangeOfUseConnection(parent);
        String sourceChannel = request.getParameter("Source");
        String consumerCode = "";
        if (!message.isEmpty() && !"".equals(message)) {
            consumerCode = changeOfUse.getConnection().getParentConnection() != null ? changeOfUse.getConnection().getParentConnection().getConsumerCode() : changeOfUse.getConnection().getConsumerCode();
            return "redirect:/application/changeOfUse/" + consumerCode;
        }
        int i = 0;
        if (!changeOfUse.getApplicationDocs().isEmpty()) {
            for (ApplicationDocuments applicationDocument : changeOfUse.getApplicationDocs()) {
                String fieldError;
                if (applicationDocument.getDocumentNumber() == null && applicationDocument.getDocumentDate() != null) {
                    fieldError = "applicationDocs[" + i + "].documentNumber";
                    resultBinder.rejectValue(fieldError, "documentNumber.required");
                }
                if (applicationDocument.getDocumentNumber() != null && applicationDocument.getDocumentDate() == null) {
                    fieldError = "applicationDocs[" + i + "].documentDate";
                    resultBinder.rejectValue(fieldError, "documentDate.required");
                } else if (this.validApplicationDocument(applicationDocument)) {
                    applicationDocs.add(applicationDocument);
                }
                ++i;
            }
        }
        this.waterConnectionDetailsService.validateWaterRateAndDonationHeader(changeOfUse);
        if (resultBinder.hasErrors()) {
            WaterConnectionDetails parentConnectionDetails = this.waterConnectionDetailsService.getActiveConnectionDetailsByConnection(changeOfUse.getConnection());
            this.loadBasicData(model, parentConnectionDetails, changeOfUse, changeOfUse);
            WorkflowContainer workflowContainer = new WorkflowContainer();
            workflowContainer.setAdditionalRule(changeOfUse.getApplicationType().getCode());
            this.prepareWorkflow(model, (StateAware)changeOfUse, workflowContainer);
            model.addAttribute("approvalPosOnValidate", (Object)request.getParameter("approvalPosition"));
            model.addAttribute("additionalRule", (Object)changeOfUse.getApplicationType().getCode());
            model.addAttribute("validationmessage", (Object)(((FieldError)resultBinder.getFieldErrors().get(0)).getField() + " = " + ((FieldError)resultBinder.getFieldErrors().get(0)).getDefaultMessage()));
            model.addAttribute("stateType", (Object)changeOfUse.getClass().getSimpleName());
            model.addAttribute("currentUser", (Object)this.waterTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
            return "changeOfUse-form";
        }
        if (changeOfUse.getState() == null) {
            changeOfUse.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("CREATED", "WATERTAXAPPLICATION"));
        }
        changeOfUse.getApplicationDocs().clear();
        changeOfUse.setApplicationDocs(applicationDocs);
        this.processAndStoreApplicationDocuments(changeOfUse);
        Long approvalPosition = 0L;
        String approvalComent = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComent = request.getParameter("approvalComent");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if ((applicationByOthers = this.waterTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser())) != null && applicationByOthers.equals(true)) {
            Position userPosition = this.waterTaxUtils.getZonalLevelClerkForLoggedInUser(changeOfUse.getConnection().getPropertyIdentifier());
            if (userPosition != null) {
                approvalPosition = userPosition.getId();
            } else {
                WaterConnectionDetails parentConnectionDetails = this.waterConnectionDetailsService.getActiveConnectionDetailsByConnection(changeOfUse.getConnection());
                this.loadBasicData(model, parentConnectionDetails, changeOfUse, changeOfUse);
                WorkflowContainer workflowContainer = new WorkflowContainer();
                workflowContainer.setAdditionalRule(changeOfUse.getApplicationType().getCode());
                this.prepareWorkflow(model, (StateAware)changeOfUse, workflowContainer);
                model.addAttribute("additionalRule", (Object)changeOfUse.getApplicationType().getCode());
                model.addAttribute("stateType", (Object)changeOfUse.getClass().getSimpleName());
                model.addAttribute("currentUser", (Object)this.waterTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
                errors.rejectValue("connection.propertyIdentifier", "err.validate.connection.user.mapping", "err.validate.connection.user.mapping");
                model.addAttribute("noJAORSAMessage", (Object)"No JA/SA exists to forward the application.");
                return "changeOfUse-form";
            }
        }
        changeOfUse.setApplicationDate(new Date());
        this.changeOfUseService.createChangeOfUseApplication(changeOfUse, approvalPosition, approvalComent, changeOfUse.getApplicationType().getCode(), workFlowAction, sourceChannel);
        Assignment currentUserAssignment = this.assignmentService.getPrimaryAssignmentForGivenRange(this.securityUtils.getCurrentUser().getId(), new Date(), new Date());
        String nextDesign = "";
        Assignment assignObj = null;
        List<Object> asignList = null;
        if (approvalPosition != null) {
            assignObj = this.assignmentService.getPrimaryAssignmentForPositon(approvalPosition);
        }
        if (assignObj != null) {
            asignList = new ArrayList<Assignment>();
            asignList.add(assignObj);
        } else if (assignObj == null && approvalPosition != null) {
            asignList = this.assignmentService.getAssignmentsForPosition(approvalPosition, new Date());
        }
        nextDesign = !asignList.isEmpty() ? ((Assignment)asignList.get(0)).getDesignation().getName() : "";
        String pathVars = changeOfUse.getApplicationNumber() + "," + this.waterTaxUtils.getApproverName(approvalPosition) + "," + (currentUserAssignment != null ? currentUserAssignment.getDesignation().getName() : "") + "," + (nextDesign != null ? nextDesign : "");
        return "redirect:/application/citizeenAcknowledgement?pathVars=" + changeOfUse.getApplicationNumber();
    }

    private void loadBasicData(Model model, WaterConnectionDetails parentConnectionDetails, WaterConnectionDetails changeOfUse, WaterConnectionDetails connectionUnderChange) {
        changeOfUse.setConnectionStatus(ConnectionStatus.INPROGRESS);
        changeOfUse.setConnectionType(connectionUnderChange.getConnectionType());
        changeOfUse.setUsageType(connectionUnderChange.getUsageType());
        changeOfUse.setCategory(connectionUnderChange.getCategory());
        changeOfUse.setPropertyType(connectionUnderChange.getPropertyType());
        changeOfUse.setPipeSize(connectionUnderChange.getPipeSize());
        changeOfUse.setSumpCapacity(connectionUnderChange.getSumpCapacity());
        changeOfUse.setConnection(connectionUnderChange.getConnection());
        changeOfUse.setWaterSource(connectionUnderChange.getWaterSource());
        changeOfUse.setNumberOfPerson(connectionUnderChange.getNumberOfPerson());
        changeOfUse.setNumberOfRooms(connectionUnderChange.getNumberOfRooms());
        model.addAttribute("waterConnectionDetails", (Object)parentConnectionDetails);
        model.addAttribute("connectionType", this.waterConnectionDetailsService.getConnectionTypesMap().get(connectionUnderChange.getConnectionType().name()));
        model.addAttribute("changeOfUse", (Object)changeOfUse);
        model.addAttribute("stateType", (Object)connectionUnderChange.getClass().getSimpleName());
        model.addAttribute("mode", (Object)"changeOfUse");
        model.addAttribute("currentUser", (Object)this.waterTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
        model.addAttribute("validationMessage", (Object)this.changeOfUseService.validateChangeOfUseConnection(connectionUnderChange));
        BigDecimal waterTaxDueforParent = this.waterConnectionDetailsService.getTotalAmount(connectionUnderChange);
        model.addAttribute("waterTaxDueforParent", (Object)waterTaxDueforParent);
        model.addAttribute("typeOfConnection", (Object)"CHANGEOFUSE");
        model.addAttribute("usageTypes", (Object)this.usageTypeService.getActiveUsageTypes());
        model.addAttribute("connectionCategories", (Object)this.connectionCategoryService.getAllActiveConnectionCategory());
        model.addAttribute("pipeSizes", (Object)this.pipeSizeService.getAllActivePipeSize());
    }
}

