/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.rest;

import java.io.IOException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.egov.wtms.application.rest.WaterTaxDue;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RestWaterTaxController {
    @Autowired
    private ConnectionDemandService connectionDemandService;

    @RequestMapping(value={"rest/watertax/due/bycode/{consumerCode}"}, method={RequestMethod.GET}, produces={"application/json"})
    public WaterTaxDue getWaterTaxDueByConsumerCode(@PathVariable String consumerCode) throws JsonGenerationException, JsonMappingException, IOException {
        return this.connectionDemandService.getDueDetailsByConsumerCode(consumerCode);
    }

    @RequestMapping(value={"rest/watertax/due/byptno/{assessmentNumber}"}, method={RequestMethod.GET}, produces={"application/json"})
    public WaterTaxDue getWaterTaxDueByPropertyId(@PathVariable String assessmentNumber) throws JsonGenerationException, JsonMappingException, IOException {
        return this.connectionDemandService.getDueDetailsByPropertyId(assessmentNumber);
    }
}

