/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.reports;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.web.controller.reports.DCBReportHelperAdaptor;
import org.egov.wtms.web.controller.reports.DCBReportResult;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports"})
public class DCBReportController {
    public static final String ZONEWISE = "zone";
    public static final String WARDWISE = "ward";
    public static final String BLOCKWISE = "block";
    public static final String LOCALITYWISE = "locality";
    public static final String PROPERTY = "property";
    @PersistenceContext
    EntityManager entityManager;
    @Autowired(required=true)
    protected WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private BoundaryService boundaryService;
    private final DCBReportResult dCBReportResult = new DCBReportResult();

    @ModelAttribute(value="dCBReportResult")
    public DCBReportResult dCBReportResultModel() {
        return this.dCBReportResult;
    }

    @Autowired
    @ModelAttribute(value="connectionTypes")
    public Map<String, String> connectionTypes() {
        return this.waterConnectionDetailsService.getConnectionTypesMap();
    }

    @ModelAttribute(value="zones")
    public List<Boundary> zones() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Zone", "REVENUE");
    }

    @ModelAttribute(value="wards")
    public List<Boundary> wards() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
    }

    @ModelAttribute(value="blocks")
    public List<Boundary> blocks() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Block", "REVENUE");
    }

    @ModelAttribute(value="localitys")
    public List<Boundary> localitys() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName(LOCALITYWISE, "LOCATION");
    }

    @RequestMapping(value={"/dCBReport/zoneWise"}, method={RequestMethod.GET})
    public String zoneWisesearch(Model model) {
        model.addAttribute("mode", (Object)ZONEWISE);
        model.addAttribute("reportType", (Object)"zoneWise");
        return "dCBReport-search";
    }

    @RequestMapping(value={"/dCBReport/wardWise"}, method={RequestMethod.GET})
    public String wardWisesearch(Model model) {
        model.addAttribute("mode", (Object)WARDWISE);
        model.addAttribute("reportType", (Object)"wardWise");
        return "dCBReport-search";
    }

    @RequestMapping(value={"/dCBReport/blockWise"}, method={RequestMethod.GET})
    public String blockWisesearch(Model model) {
        model.addAttribute("mode", (Object)BLOCKWISE);
        model.addAttribute("reportType", (Object)"blockWise");
        return "dCBReport-search";
    }

    @RequestMapping(value={"/dCBReport/localityWise"}, method={RequestMethod.GET})
    public String localityWisesearch(Model model) {
        model.addAttribute("mode", (Object)LOCALITYWISE);
        model.addAttribute("reportType", (Object)"localityWise");
        return "dCBReport-search";
    }

    @RequestMapping(value={"/dCBReportList"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void search(HttpServletRequest request, HttpServletResponse response, Model model) throws IOException {
        List resultList = new ArrayList();
        String connectionType = "";
        String mode = "";
        String reportType = "";
        String[] boundaryId = null;
        StringBuilder zones = new StringBuilder();
        if (request.getParameter("boundaryId[]") != null && !"".equals(request.getParameter("boundaryId[]"))) {
            boundaryId = request.getParameterValues("boundaryId[]");
        } else if (request.getParameter("boundaryId") != null && !"".equals(request.getParameter("boundaryId"))) {
            boundaryId = request.getParameterValues("boundaryId");
        }
        if (boundaryId != null) {
            for (String n : boundaryId) {
                if (zones.length() > 0) {
                    zones.append(',');
                }
                zones.append(n);
            }
        }
        if (request.getParameter("connectionType") != null && !"".equals(request.getParameter("connectionType"))) {
            connectionType = request.getParameter("connectionType");
        }
        if (request.getParameter("mode") != null && !"".equals(request.getParameter("mode"))) {
            mode = request.getParameter("mode");
        }
        if (request.getParameter("reportType") != null && !"".equals(request.getParameter("reportType"))) {
            reportType = request.getParameter("reportType");
        }
        SQLQuery query = this.prepareQuery(zones.toString(), connectionType, mode, reportType);
        resultList = query.list();
        String result = null;
        result = "{ \"data\":" + this.toJSON(resultList) + "}";
        response.setContentType("application/json");
        IOUtils.write((String)result, (Writer)response.getWriter());
    }

    private SQLQuery prepareQuery(String paramList, String connectionType, String mode, String reportType) {
        StringBuilder query = new StringBuilder();
        StringBuilder selectQry1 = new StringBuilder();
        StringBuilder selectQry2 = new StringBuilder();
        StringBuilder fromQry = new StringBuilder();
        StringBuilder whereQry = new StringBuilder();
        StringBuilder groupByQry = new StringBuilder();
        selectQry2.append("  cast(SUM(arr_demand) as bigint) AS arr_demand,cast(SUM(curr_demand) as bigint) AS curr_demand,cast(SUM(arr_coll) as bigint) AS arr_coll,cast(SUM(curr_coll) as bigint) AS curr_coll,cast(SUM(arr_balance) as bigint) AS arr_balance,cast(SUM(curr_balance) as bigint) AS curr_balance ");
        fromQry = new StringBuilder(" from egwtr_mv_dcb_view dcbinfo,eg_boundary boundary ");
        if (mode.equalsIgnoreCase(ZONEWISE)) {
            selectQry1.append("select  distinct cast(dcbinfo.zoneid as integer) as \"zoneid\",boundary.name as \"boundaryName\", count(hscno) as countofconsumerno,");
            groupByQry.append(" group by dcbinfo.zoneid,boundary.name order by boundary.name");
            whereQry.append(" where dcbinfo.zoneid=boundary.id ");
            if (paramList != null && !paramList.equalsIgnoreCase("")) {
                whereQry = whereQry.append(" and dcbinfo.zoneid in (" + paramList + ")");
            }
        } else if (mode.equalsIgnoreCase(WARDWISE)) {
            selectQry1.append("select distinct cast(dcbinfo.wardid as integer) as \"wardid\",boundary.name as \"boundaryName\",count(hscno) as countofconsumerno, ");
            groupByQry.append(" group by dcbinfo.wardid,boundary.name order by boundary.name");
            whereQry.append(" where dcbinfo.wardid=boundary.id ");
            if (paramList != null && !paramList.equalsIgnoreCase("") && reportType.equalsIgnoreCase("wardWise")) {
                whereQry = whereQry.append(" and dcbinfo.wardid in (" + paramList + ")");
            }
            if (paramList != null && !paramList.equalsIgnoreCase("") && !reportType.equalsIgnoreCase("wardWise")) {
                whereQry = whereQry.append(" and dcbinfo.zoneid in (" + paramList + ")");
            }
        } else if (mode.equalsIgnoreCase(BLOCKWISE)) {
            selectQry1.append("select  distinct cast(dcbinfo.block as integer) as \"wardid\",boundary.name as \"boundaryName\", count(hscno) as countofconsumerno,");
            groupByQry.append(" group by dcbinfo.block,boundary.name order by boundary.name");
            whereQry.append(" where dcbinfo.block=boundary.id ");
            if (paramList != null && !paramList.equalsIgnoreCase("") && reportType.equalsIgnoreCase("blockWise")) {
                whereQry = whereQry.append(" and dcbinfo.block in (" + paramList + ")");
            }
            if (paramList != null && !paramList.equalsIgnoreCase("") && !reportType.equalsIgnoreCase("blockWise")) {
                whereQry = whereQry.append(" and dcbinfo.wardid in (" + paramList + ")");
            }
        } else if (mode.equalsIgnoreCase(LOCALITYWISE)) {
            selectQry1.append("select  distinct cast(dcbinfo.locality as integer) as \"locality\",boundary.name as \"boundaryName\",dcbinfo.username as \"username\", count(hscno) as countofconsumerno, ");
            groupByQry.append(" group by dcbinfo.locality,boundary.name,dcbinfo.username order by boundary.name");
            whereQry.append(" where dcbinfo.locality=boundary.id and dcbinfo.locality in (" + paramList + ")");
        } else if (mode.equalsIgnoreCase(PROPERTY)) {
            selectQry1.append("select distinct dcbinfo.hscno as hscno,dcbinfo.propertyid as \"propertyid\" ,dcbinfo.username as \"username\", ");
            fromQry = new StringBuilder(" from egwtr_mv_dcb_view dcbinfo ");
            groupByQry.append("group by dcbinfo.hscno,dcbinfo.propertyid,dcbinfo.username ");
            whereQry.append(" where dcbinfo.hscno is not null  ");
            whereQry = paramList != null && !paramList.equalsIgnoreCase("") && reportType.equalsIgnoreCase("localityWise") ? whereQry.append(" and dcbinfo.locality in (" + paramList + ")") : whereQry.append(" and dcbinfo.block in (" + paramList + ")");
        }
        if (!connectionType.equalsIgnoreCase("")) {
            whereQry.append(" and dcbinfo.connectiontype = '" + connectionType + "'");
        }
        whereQry.append(" and dcbinfo.connectionstatus = 'ACTIVE'");
        query = selectQry1.append((CharSequence)selectQry2).append((CharSequence)fromQry).append((CharSequence)whereQry).append((CharSequence)groupByQry);
        SQLQuery finalQuery = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(query.toString());
        finalQuery.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(DCBReportResult.class));
        return finalQuery;
    }

    private Object toJSON(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(DCBReportResult.class, (Object)new DCBReportHelperAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

