/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.masters;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.validation.Valid;
import org.egov.wtms.masters.entity.WaterRatesDetails;
import org.egov.wtms.masters.entity.WaterRatesHeader;
import org.egov.wtms.masters.entity.enums.ConnectionType;
import org.egov.wtms.masters.service.PipeSizeService;
import org.egov.wtms.masters.service.UsageTypeService;
import org.egov.wtms.masters.service.WaterRatesDetailsService;
import org.egov.wtms.masters.service.WaterRatesHeaderService;
import org.egov.wtms.masters.service.WaterSourceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/masters"})
public class WaterRatesMasterController {
    @Autowired
    private WaterSourceService waterSourceService;
    @Autowired
    private UsageTypeService usageTypeService;
    @Autowired
    private WaterRatesHeaderService waterRatesHeaderService;
    @Autowired
    private WaterRatesDetailsService waterRatesDetailsService;
    @Autowired
    private PipeSizeService pipeSizeService;

    @RequestMapping(value={"/waterRatesMaster"}, method={RequestMethod.GET})
    public String viewForm(Model model) {
        WaterRatesHeader waterRatesHeader = new WaterRatesHeader();
        if (waterRatesHeader.getWaterRatesDetails().isEmpty()) {
            waterRatesHeader.addWaterRatesDetails(new WaterRatesDetails());
        }
        waterRatesHeader.setConnectionType(ConnectionType.NON_METERED);
        model.addAttribute("waterRatesHeader", (Object)waterRatesHeader);
        model.addAttribute("waterRatesConnecionType", (Object)waterRatesHeader.getConnectionType());
        model.addAttribute("typeOfConnection", (Object)"WATERRATES");
        model.addAttribute("usageType", (Object)this.usageTypeService.getActiveUsageTypes());
        model.addAttribute("maxPipeSize", (Object)this.pipeSizeService.getAllActivePipeSize());
        model.addAttribute("waterSourceTypes", (Object)this.waterSourceService.getAllActiveWaterSourceTypes());
        model.addAttribute("reqAttr", (Object)"false");
        model.addAttribute("mode", (Object)"create");
        return "waterRates-master";
    }

    @RequestMapping(value={"/waterRatesMaster"}, method={RequestMethod.POST})
    public String createWaterRatesMasterDetails(@Valid @ModelAttribute WaterRatesHeader waterRatesHeader, RedirectAttributes redirectAttrs, Model model, BindingResult resultBinder) {
        if (resultBinder.hasErrors()) {
            return "waterRates-master";
        }
        List waterRatesHeaderTempList = this.waterRatesHeaderService.findByConnectionTypeAndUsageTypeAndWaterSourceAndPipeSize(waterRatesHeader.getConnectionType(), waterRatesHeader.getUsageType(), waterRatesHeader.getWaterSource(), waterRatesHeader.getPipeSize());
        WaterRatesDetails waterRatesDetailsTemp = null;
        WaterRatesHeader waterRatesHeaderTemp = null;
        for (WaterRatesHeader waterRatesHeadertemp : waterRatesHeaderTempList) {
            waterRatesDetailsTemp = this.waterRatesDetailsService.findByWaterRatesHeaderAndFromDateAndToDate(waterRatesHeadertemp, ((WaterRatesDetails)waterRatesHeader.getWaterRatesDetails().get(0)).getFromDate(), ((WaterRatesDetails)waterRatesHeader.getWaterRatesDetails().get(0)).getToDate());
            if (waterRatesDetailsTemp == null) continue;
            waterRatesHeaderTemp = (WaterRatesHeader)waterRatesHeaderTempList.get(0);
            break;
        }
        if (waterRatesDetailsTemp != null) {
            redirectAttrs.addFlashAttribute("waterRatesHeader", waterRatesHeaderTemp);
            model.addAttribute("message", (Object)"Monthly Rent for Non-Meter Master Data already exists.");
            this.viewForm(model);
            return "waterRates-master";
        }
        waterRatesHeader.setActive(true);
        waterRatesHeader = this.buildWaterRateDetails(waterRatesHeader, waterRatesHeader.getWaterRatesDetails());
        this.waterRatesHeaderService.createWaterRatesHeader(waterRatesHeader);
        model.addAttribute("mode", (Object)"create");
        redirectAttrs.addFlashAttribute("waterRatesHeader", (Object)waterRatesHeader);
        model.addAttribute("message", (Object)"Monthly Rent for Non-Meter Master Data created successfully.");
        return "waterRates-master-success";
    }

    @RequestMapping(value={"/waterRatesMaster/list"}, method={RequestMethod.GET})
    public String getWaterRatesMasterList(Model model) {
        List waterRatesHeaderList = this.waterRatesHeaderService.findAll();
        model.addAttribute("waterRatesHeaderList", (Object)waterRatesHeaderList);
        return "waterRates-master-list";
    }

    @RequestMapping(value={"/waterRatesMaster/edit"}, method={RequestMethod.GET})
    public String getWaterRatesMaster(Model model) {
        model.addAttribute("mode", (Object)"edit");
        return this.getWaterRatesMasterList(model);
    }

    @RequestMapping(value={"/waterRatesMaster/edit/{waterRatesHeaderid}"}, method={RequestMethod.GET})
    public String getWaterRatesMasterData(Model model, @PathVariable String waterRatesHeaderid) {
        WaterRatesHeader waterRatesHeader = this.waterRatesHeaderService.findBy(Long.valueOf(Long.parseLong(waterRatesHeaderid)));
        waterRatesHeader.setConnectionType(ConnectionType.NON_METERED);
        model.addAttribute("typeOfConnection", (Object)"WATERRATES");
        model.addAttribute("waterRatesHeader", (Object)waterRatesHeader);
        model.addAttribute("waterRatesConnecionType", (Object)waterRatesHeader.getConnectionType());
        model.addAttribute("usageType", (Object)this.usageTypeService.getActiveUsageTypes());
        model.addAttribute("maxPipeSize", (Object)this.pipeSizeService.getAllActivePipeSize());
        model.addAttribute("waterSourceTypes", (Object)this.waterSourceService.getAllActiveWaterSourceTypes());
        model.addAttribute("reqAttr", (Object)"true");
        return "waterRates-master";
    }

    @RequestMapping(value={"/waterRatesMaster/edit/{waterRatesHeaderid}"}, method={RequestMethod.POST})
    public String editWaterRatesMasterData(@Valid @ModelAttribute WaterRatesHeader waterRatesHeader, BindingResult resultBinder, RedirectAttributes redirectAttrs, @PathVariable Long waterRatesHeaderid, Model model) {
        if (resultBinder.hasErrors()) {
            return "waterRates-master";
        }
        WaterRatesHeader waterRatesHeaderTemp = this.waterRatesHeaderService.findBy(waterRatesHeaderid);
        WaterRatesDetails waterRatesDetailsTemp = null;
        waterRatesDetailsTemp = this.waterRatesDetailsService.findByWaterRatesHeaderAndFromDateAndToDate(waterRatesHeaderTemp, ((WaterRatesDetails)waterRatesHeader.getWaterRatesDetails().get(0)).getFromDate(), ((WaterRatesDetails)waterRatesHeader.getWaterRatesDetails().get(0)).getToDate());
        if (waterRatesDetailsTemp != null) {
            waterRatesHeaderTemp.setUsageType(waterRatesHeader.getUsageType());
            waterRatesHeaderTemp.setPipeSize(waterRatesHeader.getPipeSize());
            waterRatesHeaderTemp.setWaterSource(waterRatesHeader.getWaterSource());
            waterRatesHeaderTemp.setActive(waterRatesHeader.isActive());
            waterRatesHeader = this.updateWateRatesetails(waterRatesHeaderTemp, waterRatesHeader.getWaterRatesDetails());
        } else {
            waterRatesHeader = this.buildWaterRateDetails(waterRatesHeader, waterRatesHeader.getWaterRatesDetails());
        }
        this.waterRatesHeaderService.updateWaterRatesHeader(waterRatesHeader);
        redirectAttrs.addFlashAttribute("waterRatesHeader", (Object)waterRatesHeader);
        model.addAttribute("message", (Object)"Monthly Rent for Non-Meter Master Data updated successfully.");
        return "waterRates-master-success";
    }

    private WaterRatesHeader buildWaterRateDetails(WaterRatesHeader waterRatesHeader, List<WaterRatesDetails> unitDetail) {
        HashSet<WaterRatesDetails> unitSet = new HashSet<WaterRatesDetails>(0);
        for (WaterRatesDetails unitdetail : unitDetail) {
            if (unitdetail.getFromDate() == null || unitdetail.getToDate() == null || "".equals(unitdetail.getMonthlyRate())) continue;
            unitdetail.setWaterRatesHeader(waterRatesHeader);
            unitSet.add(unitdetail);
            waterRatesHeader.getWaterRatesDetails().clear();
            waterRatesHeader.getWaterRatesDetails().addAll(unitSet);
        }
        return waterRatesHeader;
    }

    private WaterRatesHeader updateWateRatesetails(WaterRatesHeader waterRatesHeader, List<WaterRatesDetails> newWaterRatesList) {
        ArrayList<WaterRatesDetails> unitWaterRatesList = new ArrayList<WaterRatesDetails>(0);
        for (WaterRatesDetails waterRatesOld : waterRatesHeader.getWaterRatesDetails()) {
            for (WaterRatesDetails waterRatesNew : newWaterRatesList) {
                if (waterRatesNew.getFromDate() == null || waterRatesNew.getToDate() == null || "".equals(waterRatesNew.getMonthlyRate())) continue;
                waterRatesOld.setWaterRatesHeader(waterRatesHeader);
                waterRatesOld.setMonthlyRate(waterRatesNew.getMonthlyRate());
                waterRatesOld.setFromDate(waterRatesNew.getFromDate());
                waterRatesOld.setToDate(waterRatesNew.getToDate());
                unitWaterRatesList.add(waterRatesOld);
            }
        }
        waterRatesHeader.setWaterRatesDetails(unitWaterRatesList);
        return waterRatesHeader;
    }
}

