/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.masters;

import java.util.List;
import javax.validation.Valid;
import org.egov.wtms.masters.entity.DocumentNames;
import org.egov.wtms.masters.service.ApplicationTypeService;
import org.egov.wtms.masters.service.DocumentNamesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/masters"})
public class DocumentNamesMasterController {
    private final DocumentNamesService documentNamesService;
    private final ApplicationTypeService applicationTypeService;

    @Autowired
    public DocumentNamesMasterController(DocumentNamesService documentNamesService, ApplicationTypeService applicationTypeService) {
        this.documentNamesService = documentNamesService;
        this.applicationTypeService = applicationTypeService;
    }

    @RequestMapping(value={"/documentNamesMaster"}, method={RequestMethod.GET})
    public String viewForm(@ModelAttribute DocumentNames documentNames, Model model) {
        documentNames = new DocumentNames();
        model.addAttribute("documentNames", (Object)documentNames);
        model.addAttribute("applicationTypes", (Object)this.applicationTypeService.findAll());
        model.addAttribute("reqAttr", (Object)"false");
        model.addAttribute("mode", (Object)"create");
        return "document-name-master";
    }

    @RequestMapping(value={"/documentNamesMaster"}, method={RequestMethod.POST})
    public String createDocumentNamesData(@Valid @ModelAttribute DocumentNames documentNames, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            model.addAttribute("applicationTypes", (Object)this.applicationTypeService.findAll());
            return "document-name-master";
        }
        this.documentNamesService.createDocumentName(documentNames);
        redirectAttrs.addFlashAttribute("documentNames", (Object)documentNames);
        model.addAttribute("message", (Object)"Document Names created successfully.");
        model.addAttribute("mode", (Object)"create");
        return "document-name-master-success";
    }

    @RequestMapping(value={"/documentNamesMaster/list"}, method={RequestMethod.GET})
    public String getDocumentNamesList(Model model) {
        List documentNamesList = this.documentNamesService.findAll();
        model.addAttribute("documentNamesList", (Object)documentNamesList);
        return "document-name-master-list";
    }

    @RequestMapping(value={"/documentNamesMaster/edit"}, method={RequestMethod.GET})
    public String getDocumentNamesMaster(Model model) {
        model.addAttribute("mode", (Object)"edit");
        return this.getDocumentNamesList(model);
    }

    @RequestMapping(value={"/documentNamesMaster/edit/{documentNameId}"}, method={RequestMethod.GET})
    public String getDocumentNamesMasterDetails(Model model, @PathVariable String documentNameId) {
        DocumentNames documentNames = this.documentNamesService.findOne(Long.valueOf(Long.parseLong(documentNameId)));
        model.addAttribute("documentNames", (Object)documentNames);
        model.addAttribute("applicationTypes", (Object)this.applicationTypeService.findAll());
        model.addAttribute("reqAttr", (Object)"true");
        return "document-name-master";
    }

    @RequestMapping(value={"/documentNamesMaster/edit/{documentNameId}"}, method={RequestMethod.POST})
    public String editDocumentNamesMasterData(@Valid @ModelAttribute DocumentNames documentNames, BindingResult errors, RedirectAttributes redirectAttrs, Model model, @PathVariable long documentNameId) {
        if (errors.hasErrors()) {
            model.addAttribute("applicationTypes", (Object)this.applicationTypeService.findAll());
            return "document-name-master";
        }
        this.documentNamesService.updateDocumentName(documentNames);
        redirectAttrs.addFlashAttribute("documentNames", (Object)documentNames);
        model.addAttribute("message", (Object)"Document Names updated successfully.");
        return "document-name-master-success";
    }
}

