/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ValidationException;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.egov.wtms.utils.WaterTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/application"})
public class GenericBillGeneratorController {
    private final WaterConnectionDetailsService waterConnectionDetailsService;
    private final ConnectionDemandService connectionDemandService;
    private final WaterTaxUtils waterTaxUtils;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private UserService userService;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;

    @Autowired
    public GenericBillGeneratorController(WaterConnectionDetailsService waterConnectionDetailsService, ConnectionDemandService connectionDemandService, WaterTaxUtils waterTaxUtils) {
        this.waterConnectionDetailsService = waterConnectionDetailsService;
        this.connectionDemandService = connectionDemandService;
        this.waterTaxUtils = waterTaxUtils;
    }

    @RequestMapping(value={"/generatebill/{applicationCode}"}, method={RequestMethod.GET})
    public String showCollectFeeForm(Model model, @PathVariable String applicationCode) {
        return "redirect:/application/collecttax-view?applicationCode=" + applicationCode;
    }

    @RequestMapping(value={"/collecttax-view"}, method={RequestMethod.GET})
    public ModelAndView collectTaxView(@ModelAttribute WaterConnectionDetails waterConnectionDetails, HttpServletRequest request, Model model) {
        if (request.getParameter("applicationCode") != null) {
            waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCodeAndStatus(request.getParameter("applicationCode"), ConnectionStatus.ACTIVE);
        }
        model.addAttribute("connectionType", this.waterConnectionDetailsService.getConnectionTypesMap().get(waterConnectionDetails.getConnectionType().name()));
        model.addAttribute("mode", (Object)"waterTaxCollection");
        model.addAttribute("checkOperator", (Object)this.waterTaxUtils.checkCollectionOperatorRole());
        model.addAttribute("feeDetails", (Object)this.connectionDemandService.getSplitFee(waterConnectionDetails));
        BigDecimal waterTaxDueforParent = this.waterConnectionDetailsService.getTotalAmount(waterConnectionDetails);
        model.addAttribute("waterTaxDueforParent", (Object)waterTaxDueforParent);
        return new ModelAndView("application/collecttax-view", "waterConnectionDetails", (Object)waterConnectionDetails);
    }

    @RequestMapping(value={"/generatebill/{applicationCode}"}, method={RequestMethod.POST})
    public String payTax(@ModelAttribute WaterConnectionDetails waterConnectionDetails, RedirectAttributes redirectAttributes, @PathVariable String applicationCode, @RequestParam String applicationTypeCode, Model model) throws ValidationException {
        WaterConnectionDetails waterconnectionDetails = this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCodeAndStatus(applicationCode, ConnectionStatus.ACTIVE);
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterconnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
        if (assessmentDetails != null) {
            return this.generateBillAndRedirectToCollection(waterConnectionDetails, applicationCode, applicationTypeCode, model);
        }
        throw new ValidationException("invalid.property");
    }

    @RequestMapping(value={"/generatebillOnline/{applicationCode}"}, method={RequestMethod.GET})
    public String payTaxOnline(@ModelAttribute WaterConnectionDetails waterConnectionDetails, RedirectAttributes redirectAttributes, @PathVariable String applicationCode, @RequestParam String applicationTypeCode, Model model) throws ValidationException {
        WaterConnectionDetails waterconnectionDetails = this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCodeAndStatus(applicationCode, ConnectionStatus.ACTIVE);
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterconnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
        if (assessmentDetails != null) {
            return this.generateBillAndRedirectToCollection(waterConnectionDetails, applicationCode, applicationTypeCode, model);
        }
        throw new ValidationException("invalid.property");
    }

    private String generateBillAndRedirectToCollection(WaterConnectionDetails waterConnectionDetails, String applicationCode, String applicationTypeCode, Model model) {
        waterConnectionDetails = applicationTypeCode.equals("CHANGEOFUSE") || applicationTypeCode.equals("RECONNECTION") ? this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCodeAndStatus(applicationCode, ConnectionStatus.ACTIVE) : this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCodeAndStatus(applicationCode, ConnectionStatus.ACTIVE);
        if (ApplicationThreadLocals.getUserId() == null && this.securityUtils.getCurrentUser().getUsername().equals("anonymous")) {
            ApplicationThreadLocals.setUserId((Long)this.userService.getUserByUsername("anonymous").getId());
        }
        model.addAttribute("collectxml", (Object)this.connectionDemandService.generateBill(applicationCode, applicationTypeCode));
        model.addAttribute("citizenrole", (Object)this.waterTaxUtils.getCitizenUserRole());
        return "collecttax-redirection";
    }
}

