/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.reports;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ValidationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.repository.FileStoreMapperRepository;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.wtms.application.service.GenerateConnectionBillService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.service.bill.WaterConnectionBillService;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/report"})
public class GenerateBillForConsumerCodeController {
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private ApplicationContext beanProvider;
    @Autowired
    private GenerateConnectionBillService generateConnectionBillService;
    @Autowired
    private FileStoreMapperRepository fileStoreMapperRepository;
    @Autowired
    private FileStoreService fileStoreService;

    @RequestMapping(value={"/generateBillForHSCNo/{consumerCode}"}, method={RequestMethod.GET})
    public String newForm(Model model, @PathVariable String consumerCode, HttpServletRequest request, HttpServletResponse response) {
        WaterConnectionBillService waterConnectionBillService = null;
        try {
            waterConnectionBillService = (WaterConnectionBillService)this.beanProvider.getBean("waterConnectionBillService");
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        if (waterConnectionBillService != null) {
            waterConnectionBillService.generateBillForConsumercode(consumerCode);
        }
        List waterChargesDocumentslist = this.generateConnectionBillService.getDocuments(consumerCode, this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCode(consumerCode).getApplicationType().getName());
        model.addAttribute("successMessage", (Object)"Demand Bill got generated, Please click on download.");
        model.addAttribute("fileStoreId", !waterChargesDocumentslist.isEmpty() ? waterChargesDocumentslist.get(0) : "");
        return "generatebill-consumercode";
    }

    @RequestMapping(value={"/generateBillForHSCNo/downloadDemandBill"})
    public void generatePDF(String consumerCode, HttpServletRequest request, HttpServletResponse response) {
        String signedFileStoreId = request.getParameter("signedFileStoreId");
        response.setHeader("content-disposition", "attachment; filename=\"generate_bill.pdf\"");
        if (signedFileStoreId != null) {
            try {
                FileStoreMapper fsm = this.fileStoreMapperRepository.findByFileStoreId(signedFileStoreId);
                File file = this.fileStoreService.fetch(fsm, "WTMS");
                FileInputStream inStream = new FileInputStream(file);
                PrintWriter outStream = response.getWriter();
                int bytesRead = -1;
                while ((bytesRead = inStream.read()) != -1) {
                    outStream.write(bytesRead);
                }
                inStream.close();
                outStream.close();
            }
            catch (FileNotFoundException fileNotFoundExcep) {
                throw new ApplicationRuntimeException("Exception while loading file : " + fileNotFoundExcep);
            }
            catch (IOException ioExcep) {
                throw new ApplicationRuntimeException("Exception while generating bill : " + ioExcep);
            }
        } else {
            throw new ValidationException("err.demand.notice");
        }
    }
}

