/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.reports;

import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.web.utils.WebUtils;
import org.egov.wtms.application.entity.DefaultersReport;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.DefaultersWTReportService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.utils.DemandComparatorByInstallmentOrder;
import org.egov.wtms.utils.WaterTaxUtils;
import org.egov.wtms.web.controller.reports.DefaultersReportAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report/defaultersWTReport/search"})
public class DefaultersWTReportController {
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private DefaultersWTReportService defaultersWTReportService;
    @Autowired
    public WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    public ConnectionDemandService connectionDemandService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;

    @RequestMapping(method={RequestMethod.GET})
    public String search(Model model) {
        model.addAttribute("currentDate", (Object)new Date());
        return "defaultersWTReport-search";
    }

    @ModelAttribute
    public DefaultersReport reportModel() {
        return new DefaultersReport();
    }

    @ModelAttribute(value="revenueWards")
    public List<Boundary> revenueWardList() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("WARD", "REVENUE");
    }

    @ModelAttribute(value="topDefaultersList")
    public List<Integer> defaultersList() {
        ArrayList<Integer> topdefaultersList = new ArrayList<Integer>();
        topdefaultersList.add(10);
        topdefaultersList.add(50);
        topdefaultersList.add(100);
        topdefaultersList.add(500);
        topdefaultersList.add(1000);
        return topdefaultersList;
    }

    @RequestMapping(value={"/result"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void searchResult(HttpServletRequest request, HttpServletResponse response) throws IOException, ParseException {
        String ward = "";
        String topDefaulters = "";
        String fromAmount = "";
        String toAmount = "";
        if (null != request.getParameter("ward")) {
            ward = request.getParameter("ward");
        }
        if (null != request.getParameter("topDefaulters")) {
            topDefaulters = request.getParameter("topDefaulters");
        }
        if (null != request.getParameter("fromAmount")) {
            fromAmount = request.getParameter("fromAmount");
        }
        if (null != request.getParameter("toAmount")) {
            toAmount = request.getParameter("toAmount");
        }
        List defaultersreportlist = new ArrayList();
        defaultersreportlist = this.defaultersWTReportService.getDefaultersReportDetails(fromAmount, toAmount, ward, topDefaulters, Integer.valueOf(request.getParameter("start")).intValue(), Integer.valueOf(request.getParameter("length")).intValue());
        long foundRows = this.defaultersWTReportService.getTotalCount(fromAmount, toAmount, ward, topDefaulters);
        String result = null;
        for (DefaultersReport dd : defaultersreportlist) {
            dd.setDuePeriodFrom(this.getDuePeriodFrom(dd.getHscNo()));
        }
        result = "{ \"draw\":" + request.getParameter("draw") + ", \"recordsTotal\":" + foundRows + ", \"recordsFiltered\":" + foundRows + ", \"data\":" + WebUtils.toJSON(defaultersreportlist, DefaultersReport.class, DefaultersReportAdaptor.class) + "}";
        response.setContentType("application/json");
        IOUtils.write((String)result, (Writer)response.getWriter());
    }

    public String getDuePeriodFrom(String consumerCode) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCodeAndStatus(consumerCode, ConnectionStatus.ACTIVE);
        if (waterConnectionDetails != null) {
            DemandComparatorByInstallmentOrder demandComparatorByOrderId = new DemandComparatorByInstallmentOrder();
            HashSet egdemandtemplist = new HashSet();
            Set demnadDetList = this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand().getEgDemandDetails();
            for (EgDemandDetails egDemandTemp : demnadDetList) {
                if (egDemandTemp.getAmount().equals(egDemandTemp.getAmtCollected())) continue;
                egdemandtemplist.addAll(egDemandTemp.getEgDemand().getEgDemandDetails());
            }
            ArrayList egdemandlist = new ArrayList(egdemandtemplist);
            if (egdemandlist.isEmpty()) {
                return "";
            }
            Collections.sort(egdemandlist, demandComparatorByOrderId);
            return ((EgDemandDetails)egdemandlist.get(0)).getEgDemandReason().getEgInstallmentMaster().getDescription();
        }
        return "";
    }
}

