/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.reports;

import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.commons.Installment;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.web.utils.WebUtils;
import org.egov.wtms.application.entity.BaseRegisterResult;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.entity.enums.ConnectionType;
import org.egov.wtms.web.controller.reports.BaseRegisterReportService;
import org.egov.wtms.web.controller.reports.BaseRegisterResultAdaptor;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report/baseRegister"})
public class BaseRegisterReportController {
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private BaseRegisterReportService baseRegisterReportService;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private ConnectionDemandService connectionDemandService;

    @ModelAttribute(value="wards")
    public List<Boundary> wardBoundaries() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("WARD", "REVENUE");
    }

    @ModelAttribute
    public void getPropertyModel(Model model) {
        BaseRegisterResult baseRegisterResult = new BaseRegisterResult();
        model.addAttribute("baseRegisterResult", (Object)baseRegisterResult);
    }

    @RequestMapping(method={RequestMethod.GET})
    public String searchForm(Model model) {
        model.addAttribute("currDate", (Object)new Date());
        return "baseRegister-form";
    }

    @RequestMapping(value={"/result"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void springPaginationDataTableUpdate(HttpServletRequest request, HttpServletResponse response) throws IOException, ParseException {
        String ward = "";
        if (null != request.getParameter("ward")) {
            ward = request.getParameter("ward");
        }
        List baseRegisterResultList = new ArrayList();
        SQLQuery query = this.baseRegisterReportService.getBaseRegisterReportDetails(ward);
        baseRegisterResultList = query.list();
        for (BaseRegisterResult br : baseRegisterResultList) {
            br.setPeriod(this.getDuePeriodFrom(br.getConsumerNo()));
        }
        String result = "";
        result = "{ \"data\":" + WebUtils.toJSON(baseRegisterResultList, BaseRegisterResult.class, BaseRegisterResultAdaptor.class) + "}";
        response.setContentType("application/json");
        IOUtils.write((String)result, (Writer)response.getWriter());
    }

    public String getDuePeriodFrom(String consumerCode) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCodeAndStatus(consumerCode, ConnectionStatus.ACTIVE);
        Installment currInstallment = null;
        if (waterConnectionDetails != null) {
            currInstallment = waterConnectionDetails.getConnectionType().equals((Object)ConnectionType.NON_METERED) ? this.connectionDemandService.getCurrentInstallment("Property Tax", null, new Date()) : this.connectionDemandService.getCurrentInstallment("Water Tax Management", "Monthly", new Date());
            return currInstallment.getDescription();
        }
        return "";
    }
}

