/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.masters;

import java.util.List;
import javax.validation.Valid;
import org.egov.wtms.masters.entity.WaterPropertyUsage;
import org.egov.wtms.masters.service.PropertyTypeService;
import org.egov.wtms.masters.service.UsageTypeService;
import org.egov.wtms.masters.service.WaterPropertyUsageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/masters"})
public class PropertyUsageMasterController {
    private final PropertyTypeService propertyTypeService;
    private final WaterPropertyUsageService waterPropertyUsageService;
    private final UsageTypeService usageTypeService;

    @Autowired
    public PropertyUsageMasterController(PropertyTypeService propertyTypeService, WaterPropertyUsageService waterPropertyUsageService, UsageTypeService usageTypeService) {
        this.propertyTypeService = propertyTypeService;
        this.waterPropertyUsageService = waterPropertyUsageService;
        this.usageTypeService = usageTypeService;
    }

    @RequestMapping(value={"/propertyUsageMaster"}, method={RequestMethod.GET})
    public String viewForm(Model model) {
        WaterPropertyUsage waterPropertyUsage = new WaterPropertyUsage();
        model.addAttribute("waterPropertyUsage", (Object)waterPropertyUsage);
        model.addAttribute("propertyType", (Object)this.propertyTypeService.getAllActivePropertyTypes());
        model.addAttribute("usageType", (Object)this.usageTypeService.getActiveUsageTypes());
        model.addAttribute("reqAttr", (Object)"false");
        model.addAttribute("mode", (Object)"create");
        return "property-usage-master";
    }

    @RequestMapping(value={"/propertyUsageMaster"}, method={RequestMethod.POST})
    public String createPropertyUsageData(@Valid @ModelAttribute WaterPropertyUsage waterPropertyUsage, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            model.addAttribute("propertyType", (Object)this.propertyTypeService.getAllActivePropertyTypes());
            model.addAttribute("usageType", (Object)this.usageTypeService.getActiveUsageTypes());
            return "property-usage-master";
        }
        this.waterPropertyUsageService.createWaterPropertyUsage(waterPropertyUsage);
        redirectAttrs.addFlashAttribute("waterPropertyUsage", (Object)waterPropertyUsage);
        model.addAttribute("message", (Object)"Property Usage created successfully.");
        model.addAttribute("mode", (Object)"create");
        return "property-usage-master-success";
    }

    @RequestMapping(value={"/propertyUsageMaster/list"}, method={RequestMethod.GET})
    public String getPropertyUsageList(Model model) {
        List waterPropertyUsageList = this.waterPropertyUsageService.findAll();
        model.addAttribute("waterPropertyUsageList", (Object)waterPropertyUsageList);
        return "property-usage-master-list";
    }

    @RequestMapping(value={"/propertyUsageMaster/edit"}, method={RequestMethod.GET})
    public String getPropertyUsageMaster(Model model) {
        model.addAttribute("mode", (Object)"edit");
        return this.getPropertyUsageList(model);
    }

    @RequestMapping(value={"/propertyUsageMaster/edit/{waterPropertyUsageId}"}, method={RequestMethod.GET})
    public String getPropertyUsageDetails(Model model, @PathVariable String waterPropertyUsageId) {
        WaterPropertyUsage waterPropertyUsage = this.waterPropertyUsageService.findOne(Long.valueOf(Long.parseLong(waterPropertyUsageId)));
        model.addAttribute("waterPropertyUsage", (Object)waterPropertyUsage);
        model.addAttribute("propertyType", (Object)this.propertyTypeService.getAllActivePropertyTypes());
        model.addAttribute("usageType", (Object)this.usageTypeService.getActiveUsageTypes());
        model.addAttribute("reqAttr", (Object)"true");
        return "property-usage-master";
    }

    @RequestMapping(value={"/propertyUsageMaster/edit/{waterPropertyUsageId}"}, method={RequestMethod.POST})
    public String editPropertyUsageData(@Valid @ModelAttribute WaterPropertyUsage waterPropertyUsage, BindingResult errors, RedirectAttributes redirectAttrs, Model model, @PathVariable long waterPropertyUsageId) {
        if (errors.hasErrors()) {
            model.addAttribute("propertyType", (Object)this.propertyTypeService.getAllActivePropertyTypes());
            model.addAttribute("usageType", (Object)this.usageTypeService.getActiveUsageTypes());
            return "property-usage-master";
        }
        this.waterPropertyUsageService.updateWaterPropertyUsage(waterPropertyUsage);
        redirectAttrs.addFlashAttribute("waterPropertyUsage", (Object)waterPropertyUsage);
        model.addAttribute("message", (Object)"Property Usage updated successfully.");
        return "property-usage-master-success";
    }
}

