/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.WordUtils;
import org.egov.commons.Installment;
import org.egov.demand.dao.DemandGenericDao;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.MeterReadingConnectionDetails;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.repository.WaterConnectionDetailsRepository;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.egov.wtms.utils.WaterTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/application"})
public class MeterDemandNoticeController {
    @Autowired
    private ReportService reportService;
    @Autowired
    private DemandGenericDao demandGenericDao;
    @Autowired
    private ConnectionDemandService connectionDemandService;
    public static final String METERDEMAND_NOTICE = "meterDemandNotice";
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    private final Map<String, Object> reportParams = new HashMap();
    private ReportRequest reportInput = null;
    private ReportOutput reportOutput = null;
    String errorMessage = "";
    @Autowired
    private WaterConnectionDetailsRepository waterConnectionDetailsRepository;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;

    @RequestMapping(value={"/meterdemandnotice"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateEstimationNotice(HttpServletRequest request, HttpSession session) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(request.getParameter("pathVar"), ConnectionStatus.ACTIVE);
        if (!this.errorMessage.isEmpty()) {
            return this.redirect();
        }
        return this.generateReport(waterConnectionDetails, session);
    }

    private ResponseEntity<byte[]> generateReport(WaterConnectionDetails waterConnectionDetails, HttpSession session) {
        if (waterConnectionDetails != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ACTIVE);
            String ownerName = "";
            Iterator iterator = assessmentDetails.getOwnerNames().iterator();
            if (iterator.hasNext()) {
                OwnerName names = (OwnerName)iterator.next();
                ownerName = names.getOwnerName();
            }
            EgBill billObj = null;
            List billlist = this.demandGenericDao.getAllBillsForDemand(this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand(), "N", "N");
            if (!billlist.isEmpty()) {
                billObj = (EgBill)billlist.get(0);
            }
            MeterReadingConnectionDetails meterReadingpriviousObj = new MeterReadingConnectionDetails();
            List meterReadingpriviousObjlist = this.waterConnectionDetailsRepository.findPreviousMeterReadingReading(waterConnectionDetails.getId());
            if (meterReadingpriviousObjlist.size() > 1) {
                meterReadingpriviousObj.setCurrentReading(((MeterReadingConnectionDetails)meterReadingpriviousObjlist.get(1)).getCurrentReading());
                if (((MeterReadingConnectionDetails)meterReadingpriviousObjlist.get(1)).getCurrentReadingDate() != null) {
                    meterReadingpriviousObj.setCurrentReadingDate(((MeterReadingConnectionDetails)meterReadingpriviousObjlist.get(1)).getCurrentReadingDate());
                } else {
                    meterReadingpriviousObj.setCurrentReadingDate(waterConnectionDetails.getExecutionDate());
                }
            } else {
                if (waterConnectionDetails.getConnection().getInitialReading() != null) {
                    meterReadingpriviousObj.setCurrentReading(waterConnectionDetails.getConnection().getInitialReading());
                } else {
                    meterReadingpriviousObj.setCurrentReading(Long.valueOf(0L));
                }
                meterReadingpriviousObj.setCurrentReadingDate(waterConnectionDetails.getExecutionDate());
            }
            SimpleDateFormat formattermonth = new SimpleDateFormat("MMMM");
            SimpleDateFormat formatterYear = new SimpleDateFormat("YYYY");
            String monthName = formattermonth.format((Object)((MeterReadingConnectionDetails)waterConnectionDetails.getMeterConnection().get(0)).getCurrentReadingDate());
            String yearName = formatterYear.format((Object)((MeterReadingConnectionDetails)waterConnectionDetails.getMeterConnection().get(0)).getCurrentReadingDate());
            this.prepareReportParams(waterConnectionDetails, session, formatter, assessmentDetails, ownerName, billObj, meterReadingpriviousObj, monthName, yearName);
            this.reportInput = new ReportRequest(METERDEMAND_NOTICE, (Collection)waterConnectionDetails.getEstimationDetails(), this.reportParams);
            this.reportInput.setPrintDialogOnOpenReport(true);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=DemandNotice.pdf");
        this.reportOutput = this.reportService.createReport(this.reportInput);
        return new ResponseEntity((Object)this.reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    private void prepareReportParams(WaterConnectionDetails waterConnectionDetails, HttpSession session, SimpleDateFormat formatter, AssessmentDetails assessmentDetails, String ownerName, EgBill billObj, MeterReadingConnectionDetails meterReadingpriviousObj, String monthName, String yearName) {
        if ("NEWCONNECTION".equalsIgnoreCase(waterConnectionDetails.getApplicationType().getCode())) {
            this.reportParams.put("applicationType", WordUtils.capitalize((String)waterConnectionDetails.getApplicationType().getName()).toString());
        } else if ("ADDNLCONNECTION".equalsIgnoreCase(waterConnectionDetails.getApplicationType().getCode())) {
            this.reportParams.put("applicationType", WordUtils.capitalize((String)waterConnectionDetails.getApplicationType().getName()).toString());
        }
        this.reportParams.put("municipality", session.getAttribute("citymunicipalityname"));
        this.reportParams.put("district", session.getAttribute("districtName"));
        this.reportParams.put("waterCharges", waterConnectionDetails.getConnectionType().name());
        this.reportParams.put("propertyassesmentNumber", waterConnectionDetails.getConnection().getPropertyIdentifier());
        this.reportParams.put("consumerNumber", waterConnectionDetails.getConnection().getConsumerCode());
        this.reportParams.put("pipeSize", waterConnectionDetails.getPipeSize().getSizeInInch());
        this.reportParams.put("mterSerialNumber", waterConnectionDetails.getConnection().getMeterSerialNumber());
        this.reportParams.put("applicantName", ownerName);
        this.reportParams.put("demandNoticeNumber", billObj != null && billObj.getBillNo() != null ? billObj.getBillNo() : "");
        this.reportParams.put("billMonth", monthName + "-" + yearName);
        this.reportParams.put("demandNoticeDate", billObj != null && billObj.getCreateDate() != null ? formatter.format(billObj.getCreateDate()) : null);
        this.reportParams.put("previousReading", meterReadingpriviousObj.getCurrentReading());
        if (meterReadingpriviousObj.getCurrentReadingDate() != null) {
            this.reportParams.put("previousReadingDate", formatter.format(meterReadingpriviousObj.getCurrentReadingDate()));
        } else {
            this.reportParams.put("previousReadingDate", "");
        }
        this.reportParams.put("currentReading", ((MeterReadingConnectionDetails)waterConnectionDetails.getMeterConnection().get(0)).getCurrentReading());
        this.reportParams.put("currrentReadingDate", formatter.format(((MeterReadingConnectionDetails)waterConnectionDetails.getMeterConnection().get(0)).getCurrentReadingDate()));
        this.reportParams.put("noofunitsconsume", ((MeterReadingConnectionDetails)waterConnectionDetails.getMeterConnection().get(0)).getCurrentReading() - meterReadingpriviousObj.getCurrentReading());
        this.reportParams.put("totalBilltoCollect", this.waterConnectionDetailsService.getTotalAmount(waterConnectionDetails));
        this.reportParams.put("currentMonthCharges", this.getCurrentMonthDemandAmount(waterConnectionDetails, ((MeterReadingConnectionDetails)waterConnectionDetails.getMeterConnection().get(0)).getCurrentReadingDate()));
        this.reportParams.put("totalDueAmount", this.getTotalDue(waterConnectionDetails, ((MeterReadingConnectionDetails)waterConnectionDetails.getMeterConnection().get(0)).getCurrentReadingDate()));
        this.reportParams.put("address", assessmentDetails.getPropertyAddress());
    }

    public BigDecimal getTotalDue(WaterConnectionDetails waterConnectionDetails, Date givenDate) {
        BigDecimal balance = BigDecimal.ZERO;
        balance = this.waterConnectionDetailsService.getTotalAmount(waterConnectionDetails);
        BigDecimal demnadDetCurrentamount = this.getCurrentMonthDemandAmount(waterConnectionDetails, givenDate);
        balance = balance.subtract(demnadDetCurrentamount);
        return balance;
    }

    private BigDecimal getCurrentMonthDemandAmount(WaterConnectionDetails waterConnectionDetails, Date givenDate) {
        int detLength;
        BigDecimal currentAmount = BigDecimal.ZERO;
        Installment installment = this.connectionDemandService.getCurrentInstallment("Water Tax Management", "Monthly", givenDate);
        EgDemandReason demandReasonObj = this.connectionDemandService.getDemandReasonByCodeAndInstallment("WTAXCHARGES", installment);
        List demnadDetList = this.demandGenericDao.getDemandDetailsForDemandAndReasons(this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand(), Arrays.asList(demandReasonObj));
        if (demnadDetList.size() > 0 && ((EgDemandDetails)demnadDetList.get((detLength = demnadDetList.size() - 1) - detLength)).getAmount() != null) {
            currentAmount = ((EgDemandDetails)demnadDetList.get(detLength)).getAmount();
        }
        return currentAmount;
    }

    @RequestMapping(value={"/meterdemandnotice/view/{applicationNumber}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> viewEstimationNotice(@PathVariable String applicationNumber, HttpSession session) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumber(applicationNumber);
        return this.generateReport(waterConnectionDetails, session);
    }

    private ResponseEntity<byte[]> redirect() {
        this.errorMessage = "<html><body><p style='color:red;border:1px solid gray;padding:15px;'>" + this.errorMessage + "</p></body></html>";
        byte[] byteData = this.errorMessage.getBytes();
        this.errorMessage = "";
        return new ResponseEntity((Object)byteData, HttpStatus.CREATED);
    }
}

