/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.commons.entity.ChairPerson;
import org.egov.commons.service.ChairPersonService;
import org.egov.infra.web.utils.WebUtils;
import org.egov.wtms.web.controller.application.ChairPersonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/application"})
public class CreateChairPersonMasterController {
    @Autowired
    private ChairPersonService chairPersonService;
    public static final String CONTENTTYPE_JSON = "application/json";

    @RequestMapping(value={"/chairPersonDetails"}, method={RequestMethod.GET})
    public String viewForm() {
        return "chairperson-details";
    }

    @RequestMapping(value={"/ajax-activeChairPersonExistsAsOnCurrentDate"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean getChairPersonName(@RequestParam String name) {
        return this.chairPersonService.getActiveChairPersonByCurrentDate() == null;
    }

    @RequestMapping(value={"/ajax-chairpersontable"}, method={RequestMethod.GET})
    @ResponseBody
    public void springPaginationDataTables(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int pageStart = Integer.valueOf(request.getParameter("start"));
        int pageSize = Integer.valueOf(request.getParameter("length"));
        int pageNumber = pageStart / pageSize + 1;
        List totalRecords = this.chairPersonService.findAll();
        if (pageSize == -1) {
            pageSize = totalRecords.size();
        }
        List chairPersonsList = this.chairPersonService.getListOfChairPersons(Integer.valueOf(pageNumber), Integer.valueOf(pageSize)).getContent();
        StringBuilder chairPersonJSONData = new StringBuilder();
        chairPersonJSONData.append("{\"draw\": ").append("0");
        chairPersonJSONData.append(",\"recordsTotal\":").append(totalRecords.size());
        chairPersonJSONData.append(",\"totalDisplayRecords\":").append(chairPersonsList.size());
        chairPersonJSONData.append(",\"recordsFiltered\":").append(totalRecords.size());
        chairPersonJSONData.append(",\"data\":").append(WebUtils.toJSON((Collection)chairPersonsList, ChairPerson.class, ChairPersonAdaptor.class)).append("}");
        response.setContentType(CONTENTTYPE_JSON);
        IOUtils.write((CharSequence)chairPersonJSONData, (Writer)response.getWriter());
    }

    @RequestMapping(value={"/ajax-addChairPersonName"}, method={RequestMethod.GET})
    @ResponseBody
    public void addChairPersonName(@RequestParam String name) {
        Calendar cal = Calendar.getInstance();
        if (this.chairPersonService.getActiveChairPersonByCurrentDate() != null) {
            ChairPerson chairPerson = new ChairPerson();
            chairPerson = this.chairPersonService.getActiveChairPersonByCurrentDate();
            chairPerson.setName(name);
            this.chairPersonService.updateChairPerson(chairPerson);
        } else {
            ChairPerson chairPersonDetails = this.chairPersonService.getActiveChairPerson();
            if (chairPersonDetails != null) {
                chairPersonDetails.setActive(false);
                cal.add(5, -1);
                chairPersonDetails.setToDate(cal.getTime());
                ChairPerson chairPerson = new ChairPerson();
                chairPerson.setName(name);
                chairPerson.setFromDate(new Date());
                chairPerson.setToDate(null);
                chairPerson.setActive(true);
                this.chairPersonService.updateChairPerson(chairPersonDetails);
                this.chairPersonService.createChairPerson(chairPerson);
            } else {
                ChairPerson chairPerson = new ChairPerson();
                chairPerson.setActive(true);
                chairPerson.setName(name);
                chairPerson.setFromDate(new Date());
                chairPerson.setToDate(null);
                this.chairPersonService.createChairPerson(chairPerson);
            }
        }
    }
}

