/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.eis.entity.Assignment;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.pims.commons.Position;
import org.egov.wtms.application.entity.ApplicationDocuments;
import org.egov.wtms.application.entity.WaterConnection;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.AdditionalConnectionService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.WaterConnectionService;
import org.egov.wtms.masters.entity.DocumentNames;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.service.ApplicationTypeService;
import org.egov.wtms.utils.WaterTaxUtils;
import org.egov.wtms.web.controller.application.GenericConnectionController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/application"})
public class AdditionalConnectionController
extends GenericConnectionController {
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private ApplicationTypeService applicationTypeService;
    @Autowired
    private WaterConnectionService waterConnectionService;
    @Autowired
    private AdditionalConnectionService additionalConnectionService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private SecurityUtils securityUtils;

    @ModelAttribute(value="documentNamesList")
    public List<DocumentNames> documentNamesList(@ModelAttribute WaterConnectionDetails addConnection) {
        addConnection.setApplicationType(this.applicationTypeService.findByCode("ADDNLCONNECTION"));
        return this.waterConnectionDetailsService.getAllActiveDocumentNames(addConnection.getApplicationType());
    }

    @RequestMapping(value={"/addconnection/{consumerCode}"}, method={RequestMethod.GET})
    public String showAdditionalApplicationForm(WaterConnectionDetails parentConnectionDetails, @ModelAttribute WaterConnectionDetails addConnection, Model model, @PathVariable String consumerCode) {
        WaterConnection connection = this.waterConnectionService.findByConsumerCode(consumerCode);
        WorkflowContainer workflowContainer = new WorkflowContainer();
        workflowContainer.setAdditionalRule(addConnection.getApplicationType().getCode());
        this.prepareWorkflow(model, (StateAware)addConnection, workflowContainer);
        parentConnectionDetails = this.waterConnectionDetailsService.getParentConnectionDetails(connection.getPropertyIdentifier(), ConnectionStatus.ACTIVE);
        this.loadBasicDetails(addConnection, model, parentConnectionDetails);
        return "addconnection-form";
    }

    private void loadBasicDetails(WaterConnectionDetails addConnection, Model model, WaterConnectionDetails parentConnectionDetails) {
        addConnection.setConnectionStatus(ConnectionStatus.INPROGRESS);
        model.addAttribute("parentConnection", (Object)parentConnectionDetails.getConnection());
        model.addAttribute("waterConnectionDetails", (Object)parentConnectionDetails);
        model.addAttribute("connectionType", this.waterConnectionDetailsService.getConnectionTypesMap().get(parentConnectionDetails.getConnectionType().name()));
        model.addAttribute("addConnection", (Object)addConnection);
        model.addAttribute("stateType", (Object)parentConnectionDetails.getClass().getSimpleName());
        model.addAttribute("currentUser", (Object)this.waterTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
        model.addAttribute("additionalRule", (Object)addConnection.getApplicationType().getCode());
        model.addAttribute("mode", (Object)"addconnection");
        model.addAttribute("validationMessage", (Object)this.additionalConnectionService.validateAdditionalConnection(parentConnectionDetails));
        BigDecimal waterTaxDueforParent = this.waterConnectionDetailsService.getTotalAmount(parentConnectionDetails);
        model.addAttribute("waterTaxDueforParent", (Object)waterTaxDueforParent);
        model.addAttribute("typeOfConnection", (Object)"ADDNLCONNECTION");
    }

    @RequestMapping(value={"/addconnection/addConnection-create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute WaterConnectionDetails addConnection, BindingResult resultBinder, RedirectAttributes redirectAttributes, Model model, @RequestParam String workFlowAction, HttpServletRequest request, BindingResult errors) {
        Boolean applicationByOthers;
        String sourceChannel = request.getParameter("Source");
        WaterConnectionDetails parent = this.waterConnectionDetailsService.findByConnection(addConnection.getConnection().getParentConnection());
        String message = this.additionalConnectionService.validateAdditionalConnection(parent);
        if (!message.isEmpty() && !"".equals(message)) {
            return "redirect:/application/addconnection/" + addConnection.getConnection().getParentConnection().getConsumerCode();
        }
        ArrayList<ApplicationDocuments> applicationDocs = new ArrayList<ApplicationDocuments>();
        int i = 0;
        if (!addConnection.getApplicationDocs().isEmpty()) {
            for (ApplicationDocuments applicationDocument : addConnection.getApplicationDocs()) {
                String fieldError;
                if (applicationDocument.getDocumentNumber() == null && applicationDocument.getDocumentDate() != null) {
                    fieldError = "applicationDocs[" + i + "].documentNumber";
                    resultBinder.rejectValue(fieldError, "documentNumber.required");
                }
                if (applicationDocument.getDocumentNumber() != null && applicationDocument.getDocumentDate() == null) {
                    fieldError = "applicationDocs[" + i + "].documentDate";
                    resultBinder.rejectValue(fieldError, "documentDate.required");
                } else if (this.validApplicationDocument(applicationDocument)) {
                    applicationDocs.add(applicationDocument);
                }
                ++i;
            }
        }
        this.waterConnectionDetailsService.validateWaterRateAndDonationHeader(addConnection, resultBinder);
        if (addConnection.getState() == null) {
            addConnection.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("CREATED", "WATERTAXAPPLICATION"));
        }
        if (resultBinder.hasErrors()) {
            WaterConnectionDetails parentConnectionDetails = this.waterConnectionDetailsService.getActiveConnectionDetailsByConnection(addConnection.getConnection());
            this.loadBasicDetails(addConnection, model, parentConnectionDetails);
            WorkflowContainer workflowContainer = new WorkflowContainer();
            workflowContainer.setAdditionalRule(addConnection.getApplicationType().getCode());
            this.prepareWorkflow(model, (StateAware)addConnection, workflowContainer);
            model.addAttribute("approvalPosOnValidate", (Object)request.getParameter("approvalPosition"));
            model.addAttribute("additionalRule", (Object)addConnection.getApplicationType().getCode());
            model.addAttribute("stateType", (Object)addConnection.getClass().getSimpleName());
            model.addAttribute("currentUser", (Object)this.waterTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
            return "addconnection-form";
        }
        addConnection.setApplicationDate(new Date());
        addConnection.getApplicationDocs().clear();
        addConnection.setApplicationDocs(applicationDocs);
        this.processAndStoreApplicationDocuments(addConnection);
        Long approvalPosition = 0L;
        String approvalComent = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComent = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if ((applicationByOthers = this.waterTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser())) != null && applicationByOthers.equals(true)) {
            Position userPosition = this.waterTaxUtils.getZonalLevelClerkForLoggedInUser(addConnection.getConnection().getPropertyIdentifier());
            if (userPosition == null) {
                WaterConnectionDetails parentConnectionDetails = this.waterConnectionDetailsService.getActiveConnectionDetailsByConnection(addConnection.getConnection());
                this.loadBasicDetails(addConnection, model, parentConnectionDetails);
                WorkflowContainer workflowContainer = new WorkflowContainer();
                workflowContainer.setAdditionalRule(addConnection.getApplicationType().getCode());
                this.prepareWorkflow(model, (StateAware)addConnection, workflowContainer);
                model.addAttribute("additionalRule", (Object)addConnection.getApplicationType().getCode());
                model.addAttribute("stateType", (Object)addConnection.getClass().getSimpleName());
                model.addAttribute("currentUser", (Object)this.waterTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
                errors.rejectValue("connection.propertyIdentifier", "err.validate.connection.user.mapping", "err.validate.connection.user.mapping");
                return "addconnection-form";
            }
            approvalPosition = userPosition.getId();
        }
        this.waterConnectionDetailsService.createNewWaterConnection(addConnection, approvalPosition, approvalComent, addConnection.getApplicationType().getCode(), workFlowAction, sourceChannel);
        Assignment currentUserAssignment = this.assignmentService.getPrimaryAssignmentForGivenRange(this.securityUtils.getCurrentUser().getId(), new Date(), new Date());
        String nextDesign = "";
        Assignment assignObj = null;
        List<Object> asignList = null;
        if (approvalPosition != null) {
            assignObj = this.assignmentService.getPrimaryAssignmentForPositon(approvalPosition);
        }
        if (assignObj != null) {
            asignList = new ArrayList<Assignment>();
            asignList.add(assignObj);
        } else if (assignObj == null && approvalPosition != null) {
            asignList = this.assignmentService.getAssignmentsForPosition(approvalPosition, new Date());
        }
        nextDesign = !asignList.isEmpty() ? ((Assignment)asignList.get(0)).getDesignation().getName() : "";
        String pathVars = addConnection.getApplicationNumber() + "," + this.waterTaxUtils.getApproverName(approvalPosition) + "," + (currentUserAssignment != null ? currentUserAssignment.getDesignation().getName() : "") + "," + (nextDesign != null ? nextDesign : "");
        return "redirect:/application/application-success?pathVars=" + pathVars;
    }
}

