/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.search;

import java.util.Arrays;
import java.util.List;
import org.egov.config.search.Index;
import org.egov.config.search.IndexType;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.search.domain.Document;
import org.egov.search.domain.Page;
import org.egov.search.domain.SearchResult;
import org.egov.search.domain.Sort;
import org.egov.search.service.SearchService;
import org.egov.wtms.elasticSearch.entity.ConnectionSearchRequest;
import org.egov.wtms.utils.WaterTaxUtils;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/search/waterSearch/"})
public class WaterTaxSearchController {
    private final SearchService searchService;
    private final CityService cityService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private UserService userService;
    @Autowired
    private BoundaryService boundaryService;

    @Autowired
    public WaterTaxSearchController(SearchService searchService, CityService cityService) {
        this.searchService = searchService;
        this.cityService = cityService;
    }

    @ModelAttribute
    public ConnectionSearchRequest searchRequest() {
        return new ConnectionSearchRequest();
    }

    @ModelAttribute(value="cscUserRole")
    public String getCurrentUserRole() {
        String cscUserRole = "";
        User currentUser = null;
        currentUser = ApplicationThreadLocals.getUserId() != null ? this.userService.getUserById(ApplicationThreadLocals.getUserId()) : this.securityUtils.getCurrentUser();
        for (Role userrole : currentUser.getRoles()) {
            if (!userrole.getName().equals("CSC Operator")) continue;
            cscUserRole = userrole.getName();
            break;
        }
        return cscUserRole;
    }

    @ModelAttribute(value="citizenRole")
    public Boolean getCitizenUserRole() {
        Boolean citizenrole = Boolean.FALSE;
        if (ApplicationThreadLocals.getUserId() != null) {
            User currentUser = this.userService.getUserById(ApplicationThreadLocals.getUserId());
            for (Role userrole : currentUser.getRoles()) {
                if (!userrole.getName().equals("Citizen")) continue;
                citizenrole = Boolean.TRUE;
                break;
            }
        } else {
            citizenrole = Boolean.TRUE;
        }
        return citizenrole;
    }

    @ModelAttribute(value="ulbUserRole")
    public String getUlbOperatorUserRole() {
        String userRole = "";
        User currentUser = null;
        currentUser = ApplicationThreadLocals.getUserId() != null ? this.userService.getUserById(ApplicationThreadLocals.getUserId()) : this.securityUtils.getCurrentUser();
        for (Role userrole : currentUser.getRoles()) {
            if (!userrole.getName().equals("ULB Operator")) continue;
            userRole = userrole.getName();
            break;
        }
        return userRole;
    }

    @ModelAttribute(value="superUserRole")
    public String getSuperUserRole() {
        String userRole = "";
        User currentUser = null;
        currentUser = ApplicationThreadLocals.getUserId() != null ? this.userService.getUserById(ApplicationThreadLocals.getUserId()) : this.securityUtils.getCurrentUser();
        for (Role userrole : currentUser.getRoles()) {
            if (!userrole.getName().equals("Super User")) continue;
            userRole = userrole.getName();
            break;
        }
        return userRole;
    }

    @ModelAttribute(value="administratorRole")
    public String getAdminstratorRole() {
        String userRole = "";
        User currentUser = null;
        currentUser = ApplicationThreadLocals.getUserId() != null ? this.userService.getUserById(ApplicationThreadLocals.getUserId()) : this.securityUtils.getCurrentUser();
        for (Role userrole : currentUser.getRoles()) {
            if (!userrole.getName().equals("Property Administrator")) continue;
            userRole = userrole.getName();
            break;
        }
        return userRole;
    }

    @ModelAttribute(value="approverUserRole")
    public String getApproverUserRole() {
        String userRole = "";
        User currentUser = null;
        this.waterTaxUtils.getUserRolesForLoggedInUser();
        currentUser = ApplicationThreadLocals.getUserId() != null ? this.userService.getUserById(ApplicationThreadLocals.getUserId()) : this.securityUtils.getCurrentUser();
        for (Role userrole : currentUser.getRoles()) {
            if (!userrole.getName().equals("Water Tax Approver")) continue;
            userRole = userrole.getName();
            break;
        }
        return userRole;
    }

    @ModelAttribute(value="operatorRole")
    public String getOperatorUserRole() {
        String userRole = "";
        User currentUser = null;
        currentUser = ApplicationThreadLocals.getUserId() != null ? this.userService.getUserById(ApplicationThreadLocals.getUserId()) : this.securityUtils.getCurrentUser();
        for (Role userrole : currentUser.getRoles()) {
            if (!userrole.getName().equals("Operator")) continue;
            userRole = userrole.getName();
            break;
        }
        return userRole;
    }

    @ModelAttribute(value="billcollectionRole")
    public String getBillOperatorUserRole() {
        String userRole = "";
        User currentUser = null;
        currentUser = ApplicationThreadLocals.getUserId() != null ? this.userService.getUserById(ApplicationThreadLocals.getUserId()) : this.securityUtils.getCurrentUser();
        for (Role userrole : currentUser.getRoles()) {
            if (!userrole.getName().equals("Collection Operator")) continue;
            userRole = userrole.getName();
            break;
        }
        return userRole;
    }

    @ModelAttribute(value="revenueWards")
    public List<Boundary> revenueWardList() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("WARD", "REVENUE");
    }

    @RequestMapping(method={RequestMethod.GET})
    public String newSearchForm(Model model) {
        return "waterTaxSearch-newForm";
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public List<Document> searchConnection(@ModelAttribute ConnectionSearchRequest searchRequest) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        searchRequest.setUlbName(cityWebsite.getName());
        Sort sort = Sort.by().field("common.createdDate", SortOrder.DESC);
        SearchResult searchResult = this.searchService.search(Arrays.asList(Index.WATERCHARGES.toString()), Arrays.asList(IndexType.CONNECTIONSEARCH.toString()), searchRequest.searchQuery(), searchRequest.searchFilters(), sort, Page.NULL);
        return searchResult.getDocuments();
    }
}

