/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.reports;

import java.text.ParseException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.egov.wtms.application.entity.BaseRegisterResult;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BaseRegisterReportService {
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public SQLQuery getBaseRegisterReportDetails(String ward) throws ParseException {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select dcbinfo.hscno as \"consumerNo\",dcbinfo.propertyid as \"assementNo\", dcbinfo.username as \"ownerName\",dcbinfo.categorytype as \"categoryType\",dcbinfo.username as \"period\",");
        queryStr.append("dcbinfo.houseno as \"doorNo\", dcbinfo.connectiontype as \"connectionType\" , dcbinfo.arr_demand as \"arrears\" ,  dcbinfo.curr_demand as \"current\" ,  ");
        queryStr.append("dcbinfo.arr_coll as \"arrearsCollection\" ,  dcbinfo.curr_coll as \"currentCollection\" , dcbinfo.arr_demand+dcbinfo.curr_demand as \"totalDemand\" ,  ");
        queryStr.append("dcbinfo.usagetype as \"usageType\" ,  dcbinfo.pipesize as \"pipeSize\" , dcbinfo.arr_coll+dcbinfo.curr_coll as \"totalCollection\"  , ");
        queryStr.append(" (dcbinfo.curr_demand /12) as \"monthlyRate\"  from egwtr_mv_dcb_view dcbinfo");
        queryStr.append(" INNER JOIN eg_boundary wardboundary on dcbinfo.wardid = wardboundary.id INNER JOIN eg_boundary localboundary on dcbinfo.locality = localboundary.id");
        queryStr.append(" where dcbinfo.connectionstatus = '" + ConnectionStatus.ACTIVE.toString() + "'");
        if (StringUtils.isNotBlank((String)ward)) {
            queryStr.append(" and wardboundary.id = :ward");
        }
        SQLQuery finalQuery = this.getCurrentSession().createSQLQuery(queryStr.toString());
        if (StringUtils.isNotBlank((String)ward)) {
            finalQuery.setLong("ward", Long.valueOf(ward).longValue());
        }
        finalQuery.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(BaseRegisterResult.class));
        return finalQuery;
    }
}

