/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import javax.validation.ValidationException;
import org.egov.commons.entity.ChairPerson;
import org.egov.commons.service.ChairPersonService;
import org.egov.eis.entity.Assignment;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.wtms.application.entity.ApplicationDocuments;
import org.egov.wtms.application.entity.ConnectionEstimationDetails;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.entity.WaterDemandConnection;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.ReportGenerationService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.WaterDemandConnectionService;
import org.egov.wtms.autonumber.WorkOrderNumberGenerator;
import org.egov.wtms.masters.entity.ConnectionCategory;
import org.egov.wtms.masters.entity.enums.ClosureType;
import org.egov.wtms.masters.service.MeterCostService;
import org.egov.wtms.masters.service.RoadCategoryService;
import org.egov.wtms.masters.service.UsageTypeService;
import org.egov.wtms.utils.WaterTaxNumberGenerator;
import org.egov.wtms.utils.WaterTaxUtils;
import org.egov.wtms.web.controller.application.GenericConnectionController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.SmartValidator;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/application"})
public class UpdateConnectionController
extends GenericConnectionController {
    private final WaterConnectionDetailsService waterConnectionDetailsService;
    private final DepartmentService departmentService;
    @Autowired
    private ConnectionDemandService connectionDemandService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private RoadCategoryService roadCategoryService;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;
    @Autowired
    protected UsageTypeService usageTypeService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private UserService userService;
    @Autowired
    private WaterTaxNumberGenerator waterTaxNumberGenerator;
    @Autowired
    private ChairPersonService chairPersonService;
    @Autowired
    private MeterCostService meterCostService;
    @Autowired
    private ReportGenerationService reportGenerationService;
    @Autowired
    private WaterDemandConnectionService waterDemandConnectionService;

    @Autowired
    public UpdateConnectionController(WaterConnectionDetailsService waterConnectionDetailsService, DepartmentService departmentService, ConnectionDemandService connectionDemandService, SmartValidator validator) {
        this.waterConnectionDetailsService = waterConnectionDetailsService;
        this.departmentService = departmentService;
    }

    @ModelAttribute
    public WaterConnectionDetails getWaterConnectionDetails(@PathVariable String applicationNumber) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumber(applicationNumber);
        return waterConnectionDetails;
    }

    @RequestMapping(value={"/update/{applicationNumber}"}, method={RequestMethod.GET})
    public String view(Model model, @PathVariable String applicationNumber, HttpServletRequest request) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumber(applicationNumber);
        return this.loadViewData(model, request, waterConnectionDetails);
    }

    private String loadViewData(Model model, HttpServletRequest request, WaterConnectionDetails waterConnectionDetails) {
        model.addAttribute("stateType", (Object)waterConnectionDetails.getClass().getSimpleName());
        WorkflowContainer workflowContainer = new WorkflowContainer();
        if (waterConnectionDetails.getCloseConnectionType() != null && waterConnectionDetails.getReConnectionReason() == null) {
            model.addAttribute("additionalRule", (Object)"CLOSECONNECTION");
            workflowContainer.setAdditionalRule("CLOSECONNECTION");
            if (waterConnectionDetails.getCloseConnectionType().equals("P")) {
                waterConnectionDetails.setCloseConnectionType(ClosureType.Permanent.getName());
            } else {
                waterConnectionDetails.setCloseConnectionType(ClosureType.Temporary.getName());
            }
            model.addAttribute("radioButtonMap", Arrays.asList(ClosureType.values()));
        }
        model.addAttribute("applicationDocList", (Object)this.waterConnectionDetailsService.getApplicationDocForExceptClosureAndReConnection(waterConnectionDetails));
        if (waterConnectionDetails.getCloseConnectionType() != null && (waterConnectionDetails.getReConnectionReason() == null || waterConnectionDetails.getReConnectionReason() != null)) {
            if (!waterConnectionDetails.getApplicationDocs().isEmpty()) {
                for (ApplicationDocuments appDoc : waterConnectionDetails.getApplicationDocs()) {
                    if (appDoc.getDocumentNames() != null && appDoc.getDocumentNames().getApplicationType().getCode().equals("CLOSINGCONNECTION")) {
                        ArrayList<ApplicationDocuments> tempListDoc = new ArrayList<ApplicationDocuments>();
                        tempListDoc.add(appDoc);
                        model.addAttribute("appforDocumentList", tempListDoc);
                    }
                    if (appDoc.getDocumentNames() == null || !appDoc.getDocumentNames().getApplicationType().getCode().equals("RECONNECTION")) continue;
                    ArrayList<ApplicationDocuments> tempListDocrecon = new ArrayList<ApplicationDocuments>();
                    tempListDocrecon.add(appDoc);
                    model.addAttribute("appforDocumentList", tempListDocrecon);
                }
            } else {
                model.addAttribute("appforDocumentList", (Object)waterConnectionDetails.getApplicationDocs());
            }
        }
        if (waterConnectionDetails.getCloseConnectionType() != null && waterConnectionDetails.getReConnectionReason() != null) {
            model.addAttribute("additionalRule", (Object)"RECONNECTION");
            workflowContainer.setAdditionalRule("RECONNECTION");
        } else if ("".equals(workflowContainer.getAdditionalRule()) || workflowContainer.getAdditionalRule() == null) {
            workflowContainer.setAdditionalRule(waterConnectionDetails.getApplicationType().getCode());
            model.addAttribute("additionalRule", (Object)waterConnectionDetails.getApplicationType().getCode());
        }
        this.prepareWorkflow(model, (StateAware)waterConnectionDetails, workflowContainer);
        model.addAttribute("currentState", (Object)waterConnectionDetails.getCurrentState().getValue());
        model.addAttribute("currentUser", (Object)this.waterTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
        model.addAttribute("waterConnectionDetails", (Object)waterConnectionDetails);
        model.addAttribute("feeDetails", (Object)this.connectionDemandService.getSplitFee(waterConnectionDetails));
        model.addAttribute("connectionType", this.waterConnectionDetailsService.getConnectionTypesMap().get(waterConnectionDetails.getConnectionType().name()));
        model.addAttribute("applicationHistory", (Object)this.waterConnectionDetailsService.getHistory(waterConnectionDetails));
        model.addAttribute("approvalDepartmentList", (Object)this.departmentService.getAllDepartments());
        if (waterConnectionDetails.getStatus() != null && waterConnectionDetails.getStatus().getCode().equalsIgnoreCase("WORKORDERGENERATED")) {
            model.addAttribute("meterCostMasters", (Object)this.meterCostService.findByPipeSize(waterConnectionDetails.getPipeSize()));
        }
        if (waterConnectionDetails.getStatus() != null && waterConnectionDetails.getStatus().getCode().equalsIgnoreCase("ESTIMATIONAMOUNTPAID")) {
            ChairPerson chairPerson = this.chairPersonService.getActiveChairPersonAsOnCurrentDate();
            model.addAttribute("chairPerson", (Object)chairPerson);
        }
        if ("CHANGEOFUSE".equalsIgnoreCase(waterConnectionDetails.getApplicationType().getCode())) {
            waterConnectionDetails.getConnection().setMeter(null);
            waterConnectionDetails.getConnection().setInitialReading(null);
            waterConnectionDetails.getConnection().setMeterSerialNumber("");
        }
        this.appendModeBasedOnApplicationCreator(model, request, waterConnectionDetails);
        BigDecimal waterTaxDueforParent = this.waterConnectionDetailsService.getTotalAmount(waterConnectionDetails);
        model.addAttribute("waterTaxDueforParent", (Object)waterTaxDueforParent);
        model.addAttribute("usageTypes", (Object)this.usageTypeService.getActiveUsageTypes());
        model.addAttribute("connectionCategories", (Object)this.connectionCategoryService.getAllActiveConnectionCategory());
        model.addAttribute("pipeSizes", (Object)this.pipeSizeService.getAllActivePipeSize());
        model.addAttribute("typeOfConnection", (Object)waterConnectionDetails.getApplicationType().getCode());
        return "newconnection-edit";
    }

    private void appendModeBasedOnApplicationCreator(Model model, HttpServletRequest request, WaterConnectionDetails waterConnectionDetails) {
        Boolean recordCreatedBYNonEmployee = this.waterTaxUtils.getCurrentUserRole(waterConnectionDetails.getCreatedBy());
        if ((recordCreatedBYNonEmployee.booleanValue() || this.userService.getUserById(waterConnectionDetails.getCreatedBy().getId()).getUsername().equals("anonymous")) && null == request.getAttribute("mode") && waterConnectionDetails.getState().getHistory().isEmpty()) {
            model.addAttribute("mode", (Object)"edit");
            model.addAttribute("approvalPositionExist", (Object)this.waterConnectionDetailsService.getApprovalPositionByMatrixDesignation(waterConnectionDetails, Long.valueOf(0L), waterConnectionDetails.getApplicationType().getCode(), "edit", ""));
        } else if (recordCreatedBYNonEmployee.booleanValue() && request.getAttribute("mode") == null && waterConnectionDetails.getStatus().getCode().equals("CREATED") && waterConnectionDetails.getState().getHistory() != null || !recordCreatedBYNonEmployee.booleanValue() && waterConnectionDetails.getStatus() != null && waterConnectionDetails.getStatus().getCode().equals("CREATED")) {
            model.addAttribute("mode", (Object)"fieldInspection");
            model.addAttribute("approvalPositionExist", (Object)this.waterConnectionDetailsService.getApprovalPositionByMatrixDesignation(waterConnectionDetails, Long.valueOf(0L), waterConnectionDetails.getApplicationType().getCode(), "fieldInspection", ""));
            model.addAttribute("roadCategoryList", (Object)this.roadCategoryService.getAllRoadCategory());
        } else if (waterConnectionDetails.getCloseConnectionType() != null && waterConnectionDetails.getReConnectionReason() == null) {
            model.addAttribute("approvalPositionExist", (Object)this.waterConnectionDetailsService.getApprovalPositionByMatrixDesignation(waterConnectionDetails, Long.valueOf(0L), "CLOSECONNECTION", "", ""));
        } else if (waterConnectionDetails.getCloseConnectionType() != null && waterConnectionDetails.getReConnectionReason() != null) {
            model.addAttribute("approvalPositionExist", (Object)this.waterConnectionDetailsService.getApprovalPositionByMatrixDesignation(waterConnectionDetails, Long.valueOf(0L), "RECONNECTION", "", ""));
        } else {
            model.addAttribute("approvalPositionExist", (Object)this.waterConnectionDetailsService.getApprovalPositionByMatrixDesignation(waterConnectionDetails, Long.valueOf(0L), waterConnectionDetails.getApplicationType().getCode(), "", ""));
        }
        if (waterConnectionDetails.getCurrentState().getValue().equals("Rejected")) {
            model.addAttribute("mode", (Object)"");
        }
        if (waterConnectionDetails.getCloseConnectionType() != null && waterConnectionDetails.getReConnectionReason() == null && waterConnectionDetails.getStatus().getCode().equals("CLOSERINITIATED")) {
            model.addAttribute("mode", (Object)"closereditForAE");
        }
        if ((waterConnectionDetails.getStatus().getCode().equals("CLOSERINPROGRESS") || waterConnectionDetails.getStatus().getCode().equals("CLOSERINITIATED")) && waterConnectionDetails.getReConnectionReason() == null && waterConnectionDetails.getCloseConnectionType() != null && waterConnectionDetails.getState().getValue().equals("Rejected")) {
            model.addAttribute("mode", (Object)"closeredit");
        }
        if (waterConnectionDetails.getReConnectionReason() != null && waterConnectionDetails.getState().getValue().equals("Rejected") && waterConnectionDetails.getReConnectionReason() != null && waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONINITIATED")) {
            model.addAttribute("mode", (Object)"reconnectioneredit");
        }
        if (waterConnectionDetails.getReConnectionReason() != null && waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONINITIATED")) {
            model.addAttribute("mode", (Object)"reconEditForAE");
        }
    }

    @RequestMapping(value={"/update/{applicationNumber}"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute WaterConnectionDetails waterConnectionDetails, BindingResult resultBinder, RedirectAttributes redirectAttributes, HttpServletRequest request, Model model, @RequestParam(value="files") MultipartFile[] files) {
        String mode = "";
        String workFlowAction = "";
        String sourceChannel = request.getParameter("Source");
        if (request.getParameter("mode") != null) {
            mode = request.getParameter("mode");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        request.getSession().setAttribute("workFlowAction", (Object)workFlowAction);
        if (waterConnectionDetails.getStatus().getCode().equalsIgnoreCase("CREATED") && mode.equalsIgnoreCase("fieldInspection")) {
            if (workFlowAction.equalsIgnoreCase("Submit")) {
                ConnectionCategory connectionCategory = this.connectionCategoryService.findOne(waterConnectionDetails.getCategory().getId());
                if (connectionCategory != null && !connectionCategory.getCode().equalsIgnoreCase("BPL") && waterConnectionDetails.getBplCardHolderName() != null) {
                    waterConnectionDetails.setBplCardHolderName(null);
                }
                this.populateEstimationDetails(waterConnectionDetails);
                WaterDemandConnection waterDemandConnection = this.waterTaxUtils.getCurrentDemand(waterConnectionDetails);
                waterDemandConnection.setDemand(this.connectionDemandService.createDemand(waterConnectionDetails));
                waterDemandConnection.setWaterConnectionDetails(waterConnectionDetails);
                waterConnectionDetails.addWaterDemandConnection(waterDemandConnection);
                this.waterDemandConnectionService.createWaterDemandConnection(waterDemandConnection);
                this.waterConnectionDetailsService.save(waterConnectionDetails);
                this.waterConnectionDetailsService.getCurrentSession().flush();
                Set fileStoreSet = this.addToFileStore(files);
                Iterator fsIterator = null;
                if (fileStoreSet != null && !fileStoreSet.isEmpty()) {
                    fsIterator = fileStoreSet.iterator();
                }
                if (fsIterator != null && fsIterator.hasNext()) {
                    waterConnectionDetails.setFileStore((FileStoreMapper)fsIterator.next());
                }
            } else if (workFlowAction.equalsIgnoreCase("Reject")) {
                this.waterConnectionDetailsService.getCurrentSession().evict((Object)waterConnectionDetails);
                waterConnectionDetails = this.waterConnectionDetailsService.findBy(waterConnectionDetails.getId());
            }
        }
        Long approvalPosition = 0L;
        String approvalComent = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComent = request.getParameter("approvalComent");
        }
        if (workFlowAction != null && workFlowAction.equals("Approve") && waterConnectionDetails.getStatus() != null && waterConnectionDetails.getStatus().getCode() != null && waterConnectionDetails.getStatus().getCode().equals("ESTIMATIONAMOUNTPAID")) {
            this.validateSanctionDetails(waterConnectionDetails, resultBinder);
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if (approvalPosition == null || approvalPosition.equals(0L)) {
            approvalPosition = waterConnectionDetails.getCloseConnectionType() != null ? this.waterConnectionDetailsService.getApprovalPositionByMatrixDesignation(waterConnectionDetails, approvalPosition, request.getParameter("additionalRule"), mode, workFlowAction) : this.waterConnectionDetailsService.getApprovalPositionByMatrixDesignation(waterConnectionDetails, approvalPosition, waterConnectionDetails.getApplicationType().getCode(), mode, workFlowAction);
        }
        request.getSession().setAttribute("APPROVAL_POSITION", (Object)approvalPosition);
        this.appendModeBasedOnApplicationCreator(model, request, waterConnectionDetails);
        if ((approvalPosition == null || approvalPosition.equals(0L)) && request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if (!resultBinder.hasErrors()) {
            try {
                if (waterConnectionDetails.getCloseConnectionType() != null) {
                    if (waterConnectionDetails.getCloseConnectionType().equals("P")) {
                        waterConnectionDetails.setCloseConnectionType(ClosureType.Permanent.getName());
                    } else {
                        waterConnectionDetails.setCloseConnectionType(ClosureType.Temporary.getName());
                    }
                }
                if (null != workFlowAction) {
                    if (workFlowAction.equalsIgnoreCase("Preview") && (waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("ADDNLCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("CHANGEOFUSE"))) {
                        return "redirect:/application/workorder?pathVar=" + waterConnectionDetails.getApplicationNumber();
                    }
                    if (workFlowAction.equalsIgnoreCase("Preview") && waterConnectionDetails.getApplicationType().getCode().equals("CLOSINGCONNECTION")) {
                        return "redirect:/application/acknowlgementNotice?pathVar=" + waterConnectionDetails.getApplicationNumber();
                    }
                    if (workFlowAction.equalsIgnoreCase("Preview") && waterConnectionDetails.getApplicationType().getCode().equals("RECONNECTION")) {
                        return "redirect:/application/ReconnacknowlgementNotice?pathVar=" + waterConnectionDetails.getApplicationNumber();
                    }
                    if (workFlowAction.equals("Sign")) {
                        WaterConnectionDetails upadtedWaterConnectionDetails = null;
                        WorkOrderNumberGenerator workOrderGen = (WorkOrderNumberGenerator)this.beanResolver.getAutoNumberServiceFor(WorkOrderNumberGenerator.class);
                        if (waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("ADDNLCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("CHANGEOFUSE")) {
                            waterConnectionDetails.setWorkOrderDate(new Date());
                            waterConnectionDetails.setWorkOrderNumber(workOrderGen.generateWorkOrderNumber());
                        }
                        String cityMunicipalityName = (String)request.getSession().getAttribute("citymunicipalityname");
                        String districtName = (String)request.getSession().getAttribute("districtName");
                        ReportOutput reportOutput = null;
                        reportOutput = this.getReportOutputObject(waterConnectionDetails, workFlowAction, cityMunicipalityName, districtName);
                        if (reportOutput != null) {
                            String fileName = "";
                            fileName = waterConnectionDetails.getApplicationType().getCode().equals("CLOSINGCONNECTION") ? "SN/" + waterConnectionDetails.getApplicationNumber() + ".pdf" : (waterConnectionDetails.getApplicationType().getCode().equals("RECONNECTION") ? "SN/" + waterConnectionDetails.getApplicationNumber() + ".pdf" : "SN/" + waterConnectionDetails.getWorkOrderNumber() + ".pdf");
                            ByteArrayInputStream fileStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
                            FileStoreMapper fileStore = this.fileStoreService.store((InputStream)fileStream, fileName, "application/pdf", "WTMS");
                            waterConnectionDetails.setFileStore(fileStore);
                            upadtedWaterConnectionDetails = this.waterConnectionDetailsService.updateWaterConnectionDetailsWithFileStore(waterConnectionDetails);
                        }
                        model.addAttribute("fileStoreIds", (Object)upadtedWaterConnectionDetails.getFileStore().getFileStoreId());
                        model.addAttribute("ulbCode", (Object)ApplicationThreadLocals.getCityCode());
                        HttpSession session = request.getSession();
                        session.setAttribute("mode", (Object)mode);
                        session.setAttribute("approvalPosition", (Object)approvalPosition);
                        session.setAttribute("approvalComment", (Object)approvalComent);
                        session.setAttribute("applicationNumber", (Object)upadtedWaterConnectionDetails.getApplicationNumber());
                        HashMap<String, String> fileStoreIdsApplicationNoMap = new HashMap<String, String>();
                        fileStoreIdsApplicationNoMap.put(upadtedWaterConnectionDetails.getFileStore().getFileStoreId(), upadtedWaterConnectionDetails.getApplicationNumber());
                        session.setAttribute("fileStoreIdApplicationNumber", fileStoreIdsApplicationNoMap);
                        model.addAttribute("isDigitalSignatureEnabled", (Object)this.waterTaxUtils.isDigitalSignatureEnabled());
                        return "newConnection-digitalSignatureRedirection";
                    }
                    this.waterConnectionDetailsService.updateWaterConnection(waterConnectionDetails, approvalPosition, approvalComent, waterConnectionDetails.getApplicationType().getCode(), workFlowAction, mode, null, sourceChannel);
                }
            }
            catch (ValidationException e) {
                throw new ValidationException(e.getMessage());
            }
            if (workFlowAction != null && !workFlowAction.isEmpty() && workFlowAction.equalsIgnoreCase("Generate Estimation Notice")) {
                return "redirect:/application/estimationNotice?pathVar=" + waterConnectionDetails.getApplicationNumber();
            }
            if (null != workFlowAction && !workFlowAction.isEmpty() && workFlowAction.equalsIgnoreCase("Generate WorkOrder")) {
                return "redirect:/application/workorder?pathVar=" + waterConnectionDetails.getApplicationNumber();
            }
            if (workFlowAction != null && !workFlowAction.isEmpty() && workFlowAction.equalsIgnoreCase("Generate Acknowledgement")) {
                return "redirect:/application/acknowlgementNotice?pathVar=" + waterConnectionDetails.getApplicationNumber();
            }
            if (workFlowAction != null && !workFlowAction.isEmpty() && workFlowAction.equalsIgnoreCase("Generate Reconnection Ack")) {
                return "redirect:/application/ReconnacknowlgementNotice?pathVar=" + waterConnectionDetails.getApplicationNumber();
            }
            if ((workFlowAction.equals("Reject") || workFlowAction.equalsIgnoreCase("Generate Reconnection Ack")) && (waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONINITIATED") || waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONINPROGRESS") || waterConnectionDetails.getStatus().getCode().equals("CLOSERINPROGRESS") || waterConnectionDetails.getStatus().getCode().equals("CLOSERINITIATED"))) {
                approvalPosition = this.waterTaxUtils.getApproverPosition("Senior Assistant,Junior Assistant", waterConnectionDetails);
            }
            Assignment currentUserAssignment = this.assignmentService.getPrimaryAssignmentForGivenRange(this.securityUtils.getCurrentUser().getId(), new Date(), new Date());
            String nextDesign = "";
            Assignment assignObj = null;
            List<Object> asignList = null;
            if (approvalPosition != null) {
                assignObj = this.assignmentService.getPrimaryAssignmentForPositon(approvalPosition);
            }
            if (assignObj != null) {
                asignList = new ArrayList<Assignment>();
                asignList.add(assignObj);
            } else if (assignObj == null && approvalPosition != null) {
                asignList = this.assignmentService.getAssignmentsForPosition(approvalPosition, new Date());
            }
            nextDesign = !asignList.isEmpty() ? ((Assignment)asignList.get(0)).getDesignation().getName() : "";
            String pathVars = waterConnectionDetails.getApplicationNumber() + "," + this.waterTaxUtils.getApproverName(approvalPosition) + "," + (currentUserAssignment != null ? currentUserAssignment.getDesignation().getName() : "") + "," + (nextDesign != null ? nextDesign : "");
            return "redirect:/application/application-success?pathVars=" + pathVars;
        }
        if (waterConnectionDetails.getStatus().getCode().equalsIgnoreCase("WORKORDERGENERATED")) {
            model.addAttribute("meterFocus", (Object)true);
        }
        return this.loadViewData(model, request, waterConnectionDetails);
    }

    private ReportOutput getReportOutputObject(WaterConnectionDetails waterConnectionDetails, String workFlowAction, String cityMunicipalityName, String districtName) {
        ReportOutput reportOutput = waterConnectionDetails.getApplicationType().getCode().equals("CLOSINGCONNECTION") ? this.reportGenerationService.generateClosureConnectionReport(waterConnectionDetails, workFlowAction, cityMunicipalityName, districtName) : (waterConnectionDetails.getApplicationType().getCode().equals("RECONNECTION") ? this.reportGenerationService.generateReconnectionReport(waterConnectionDetails, workFlowAction, cityMunicipalityName, districtName) : this.reportGenerationService.getReportOutput(waterConnectionDetails, workFlowAction, cityMunicipalityName, districtName));
        return reportOutput;
    }

    private void validateSanctionDetails(WaterConnectionDetails waterConnectionDetails, BindingResult errors) {
        if (waterConnectionDetails.getApprovalNumber() == null) {
            errors.rejectValue("approvalNumber", "approvalNumber.required");
        }
        if (waterConnectionDetails.getApprovalDate() == null) {
            errors.rejectValue("approvalDate", "approvalDate.required");
        }
    }

    private void populateEstimationDetails(WaterConnectionDetails waterConnectionDetails) {
        ArrayList<ConnectionEstimationDetails> estimationDetails = new ArrayList<ConnectionEstimationDetails>();
        if (!waterConnectionDetails.getEstimationDetails().isEmpty()) {
            for (ConnectionEstimationDetails estimationDetail : waterConnectionDetails.getEstimationDetails()) {
                if (!this.validEstimationDetail(estimationDetail)) continue;
                estimationDetail.setWaterConnectionDetails(waterConnectionDetails);
                estimationDetails.add(estimationDetail);
            }
        }
        waterConnectionDetails.getEstimationDetails().clear();
        waterConnectionDetails.setEstimationDetails(estimationDetails);
    }

    private boolean validEstimationDetail(ConnectionEstimationDetails connectionEstimationDetails) {
        return connectionEstimationDetails != null && (connectionEstimationDetails == null || connectionEstimationDetails.getItemDescription() != null);
    }
}

