/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ReportGenerationService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/application"})
public class ReconnectionAckController {
    public static final String ESTIMATION_NOTICE = "ReconnacknowlgementNotice";
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private ReportGenerationService reportGenerationService;

    @RequestMapping(value={"/ReconnacknowlgementNotice"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateEstimationNotice(HttpServletRequest request, HttpSession session) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumber(request.getParameter("pathVar"));
        String cityMaunicipalityName = (String)session.getAttribute("citymunicipalityname");
        String districtName = (String)session.getAttribute("districtName");
        ReportOutput reportOutput = this.reportGenerationService.generateReconnectionReport(waterConnectionDetails, null, cityMaunicipalityName, districtName);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=Re-ConnectionAcknowledgement.pdf");
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/ReconnacknowlgementNotice/view/{applicationNumber}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> viewEstimationNotice(@PathVariable String applicationNumber, HttpSession session) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumber(applicationNumber);
        String cityMaunicipalityName = (String)session.getAttribute("citymunicipalityname");
        String districtName = (String)session.getAttribute("districtName");
        ReportOutput reportOutput = this.reportGenerationService.generateReconnectionReport(waterConnectionDetails, null, cityMaunicipalityName, districtName);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=Re-ConnectionAcknowledgement.pdf");
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

