/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.reports;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.entity.Source;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.wtms.application.entity.DailyWTCollectionReportSearch;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/report/dailyWTCollectionReport/search/"})
public class DailyWTCollectionReportController {
    @Autowired
    public EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    public AssignmentService assignmentService;
    @Autowired
    public AppConfigValueService appConfigValueService;
    @Autowired
    private CityService cityService;
    @Autowired
    private BoundaryService boundaryService;

    @ModelAttribute
    public void reportModel(Model model) {
        DailyWTCollectionReportSearch dailyCollectionReportResut = new DailyWTCollectionReportSearch();
        model.addAttribute("dailyWTCollectionReport", (Object)dailyCollectionReportResut);
    }

    @ModelAttribute(value="collectionMode")
    public Map<String, String> loadInstrumentTypes() {
        LinkedHashMap<String, String> collectionModeMap = new LinkedHashMap<String, String>(0);
        collectionModeMap.put(Source.ESEVA.toString(), Source.ESEVA.toString());
        collectionModeMap.put(Source.MEESEVA.toString(), Source.MEESEVA.toString());
        collectionModeMap.put(Source.APONLINE.toString(), Source.APONLINE.toString());
        collectionModeMap.put(Source.SOFTTECH.toString(), Source.SOFTTECH.toString());
        collectionModeMap.put(Source.SYSTEM.toString(), Source.SYSTEM.toString());
        return collectionModeMap;
    }

    @ModelAttribute(value="operators")
    public Set<User> loadCollectionOperators() {
        String operatorDesignation = this.appConfigValueService.getAppConfigValueByDate("Collection", "COLLECTIONDESIGNATIONFORCSCOPERATORASCLERK", new Date()).getValue();
        return this.assignmentService.getUsersByDesignations(operatorDesignation.split(","));
    }

    @ModelAttribute(value="status")
    public List<EgwStatus> loadStatus() {
        return this.egwStatusHibernateDAO.getStatusByModule("ReceiptHeader");
    }

    @ModelAttribute(value="wards")
    public List<Boundary> wardBoundaries() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
    }

    @RequestMapping(method={RequestMethod.GET})
    public String search(Model model) {
        model.addAttribute("currentDate", (Object)new Date());
        return "dailyWTCollection-search";
    }
}

