/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.mobile;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.egov.collection.integration.models.BillInfo;
import org.egov.collection.integration.models.BillInfoImpl;
import org.egov.collection.integration.pgi.PaymentRequest;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.model.EgBill;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.ptis.client.integration.utils.SpringBeanUtil;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.collection.ConnectionBillService;
import org.egov.wtms.application.service.collection.WaterConnectionBillable;
import org.egov.wtms.application.service.collection.WaterTaxExternalService;
import org.egov.wtms.autonumber.BillReferenceNumberGenerator;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/public/mobile", "/mobile"})
public class WaterTaxMobilePaymentController {
    private static final String PAYTAX_FORM = "mobilePayment-form";
    @Autowired
    @Qualifier(value="waterConnectionBillable")
    private WaterConnectionBillable waterConnectionBillable;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private WaterTaxExternalService waterTaxExternalService;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private ConnectionDemandService connectionDemandService;
    @Autowired
    private ConnectionBillService connectionBillService;
    @Autowired
    private EgBillDao egBillDAO;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;
    @Autowired
    private FinancialYearDAO financialYearDAO;

    @RequestMapping(value={"/payWatertax/{consumerNo},{ulbCode},{amountToBePaid},{mobileNumber},{emailId}"}, method={RequestMethod.GET})
    public String collectTax(Model model, @PathVariable String consumerNo, @PathVariable String ulbCode, @PathVariable BigDecimal amountToBePaid, @PathVariable String mobileNumber, @PathVariable String emailId, HttpServletRequest request) throws ParseException {
        String redirectUrl = "";
        BillInfoImpl billInfo = this.getBillInfo(consumerNo, amountToBePaid);
        if (billInfo != null) {
            PaymentRequest paymentRequest = SpringBeanUtil.getCollectionIntegrationService().processMobilePayments(billInfo);
            if (paymentRequest != null) {
                for (Object obj : paymentRequest.getRequestParameters().values()) {
                    redirectUrl = obj.toString();
                }
                model.addAttribute("redirectUrl", (Object)redirectUrl);
            }
        } else {
            model.addAttribute("errorMsg", (Object)"Bill data is incorrect");
            return "propertyValidation";
        }
        return PAYTAX_FORM;
    }

    public BillInfoImpl getBillInfo(String consumerNo, BigDecimal amountToBePaid) {
        BillInfoImpl billInfoImpl = null;
        WaterConnectionDetails waterConnectionDetails = null;
        String currentInstallmentYear = null;
        SimpleDateFormat formatYear = new SimpleDateFormat("yyyy");
        BillReferenceNumberGenerator billRefeNumber = (BillReferenceNumberGenerator)this.beanResolver.getAutoNumberServiceFor(BillReferenceNumberGenerator.class);
        if (consumerNo != null) {
            waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCodeAndStatus(consumerNo, ConnectionStatus.ACTIVE);
        }
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
        this.waterConnectionBillable.setWaterConnectionDetails(waterConnectionDetails);
        this.waterConnectionBillable.setAssessmentDetails(assessmentDetails);
        this.waterConnectionBillable.setUserId(Long.valueOf(2L));
        ApplicationThreadLocals.setUserId((Long)2L);
        currentInstallmentYear = formatYear.format(this.connectionDemandService.getCurrentInstallment("Property Tax", null, new Date()).getInstallmentYear());
        this.waterConnectionBillable.setReferenceNumber(billRefeNumber.generateBillNumber(currentInstallmentYear));
        this.waterConnectionBillable.setBillType(this.connectionDemandService.getBillTypeByCode("MANUAL"));
        EgBill egBill = this.generateBill((Billable)this.waterConnectionBillable, this.financialYearDAO);
        billInfoImpl = this.prepareBillForCollection(amountToBePaid, egBill, null);
        return billInfoImpl;
    }

    public final EgBill generateBill(Billable billObj, FinancialYearDAO financialYearDAO) {
        EgBill bill = this.waterTaxExternalService.generateBillForConnection(billObj, financialYearDAO);
        this.egBillDAO.create(bill);
        return bill;
    }

    @Transactional
    public BillInfoImpl prepareBillForCollection(BigDecimal amountToBePaid, EgBill bill, String source) {
        if (!this.waterTaxExternalService.isCollectionPermitted(bill)) {
            throw new ApplicationRuntimeException("Collection is not allowed - current balance is zero and advance coll exists.");
        }
        BillInfoImpl billInfo = this.waterTaxExternalService.prepareBillInfo(amountToBePaid, BillInfo.COLLECTIONTYPE.O, bill, source);
        return billInfo;
    }
}

