/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.masters;

import java.util.List;
import javax.validation.Valid;
import org.egov.wtms.masters.entity.UsageType;
import org.egov.wtms.masters.service.UsageTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/masters"})
public class UsageTypeMasterController {
    @Autowired
    private UsageTypeService usageTypeService;

    @RequestMapping(value={"/usageTypeMaster"}, method={RequestMethod.GET})
    public String viewForm(Model model) {
        UsageType usagetype = new UsageType();
        model.addAttribute("usageType", (Object)usagetype);
        model.addAttribute("reqAttr", (Object)false);
        model.addAttribute("mode", (Object)"create");
        return "usage-type-master";
    }

    @RequestMapping(value={"/usageTypeMaster"}, method={RequestMethod.POST})
    public String createUsageType(@Valid @ModelAttribute UsageType usageType, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            return "usage-type-master";
        }
        this.usageTypeService.createUsageType(usageType);
        redirectAttrs.addFlashAttribute("usageType", (Object)usageType);
        model.addAttribute("message", (Object)"Usage Type created successfully.");
        model.addAttribute("mode", (Object)"create");
        return "usage-type-sucess";
    }

    @RequestMapping(value={"/usageTypeMaster/list"}, method={RequestMethod.GET})
    public String getUsageTypeList(Model model) {
        List usageTypeList = this.usageTypeService.findAll();
        model.addAttribute("usageTypeList", (Object)usageTypeList);
        return "usage-type-master-list";
    }

    @RequestMapping(value={"/usageTypeMaster/edit"}, method={RequestMethod.GET})
    public String getUsageTypeMaster(Model model) {
        model.addAttribute("mode", (Object)"edit");
        return this.getUsageTypeList(model);
    }

    @RequestMapping(value={"/usageTypeMaster/edit/{usageTypeId}"}, method={RequestMethod.GET})
    public String getUsageTypeDetails(Model model, @PathVariable String usageTypeId) {
        UsageType usageType = this.usageTypeService.findOne(Long.valueOf(Long.parseLong(usageTypeId)));
        model.addAttribute("usageType", (Object)usageType);
        model.addAttribute("reqAttr", (Object)"true");
        return "usage-type-master";
    }

    @RequestMapping(value={"/usageTypeMaster/edit/{usageTypeId}"}, method={RequestMethod.POST})
    public String editUsageTypeData(@Valid @ModelAttribute UsageType usageType, BindingResult errors, RedirectAttributes redirectAttrs, Model model, @PathVariable long usageTypeId) {
        if (errors.hasErrors()) {
            return "usage-type-master";
        }
        this.usageTypeService.updateUsageType(usageType);
        redirectAttrs.addFlashAttribute("UsageType", (Object)usageType);
        model.addAttribute("message", (Object)"Usage Type updated successfully.");
        model.addAttribute("mode", (Object)"edit");
        return "usage-type-sucess";
    }
}

