/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.wtms.application.entity.ApplicationDocuments;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.PropertyType;
import org.egov.wtms.masters.entity.WaterSource;
import org.egov.wtms.masters.service.ConnectionCategoryService;
import org.egov.wtms.masters.service.DocumentNamesService;
import org.egov.wtms.masters.service.MeterCostService;
import org.egov.wtms.masters.service.PipeSizeService;
import org.egov.wtms.masters.service.PropertyTypeService;
import org.egov.wtms.masters.service.UsageTypeService;
import org.egov.wtms.masters.service.WaterSourceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;

public abstract class GenericConnectionController
extends GenericWorkFlowController {
    @Autowired(required=true)
    protected WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    protected UsageTypeService usageTypeService;
    @Autowired
    protected ConnectionCategoryService connectionCategoryService;
    @Autowired
    protected WaterSourceService waterSourceService;
    @Autowired
    protected PipeSizeService pipeSizeService;
    @Autowired
    protected PropertyTypeService propertyTypeService;
    @Autowired
    private DocumentNamesService documentNamesService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private MeterCostService meterCostService;
    @Autowired
    protected AssignmentService assignmentService;

    @ModelAttribute(value="waterSourceTypes")
    public List<WaterSource> waterSourceTypes() {
        return this.waterSourceService.getAllActiveWaterSourceTypes();
    }

    @ModelAttribute(value="connectionTypes")
    public Map<String, String> connectionTypes() {
        return this.waterConnectionDetailsService.getConnectionTypesMap();
    }

    @ModelAttribute(value="propertyTypes")
    public List<PropertyType> propertyTypes() {
        return this.propertyTypeService.getAllActivePropertyTypes();
    }

    protected Set<FileStoreMapper> addToFileStore(MultipartFile[] files) {
        if (ArrayUtils.isNotEmpty((Object[])files)) {
            return Arrays.asList(files).stream().filter(file -> !file.isEmpty()).map(file -> {
                try {
                    return this.fileStoreService.store(file.getInputStream(), file.getOriginalFilename(), file.getContentType(), "WTMS");
                }
                catch (Exception e) {
                    throw new ApplicationRuntimeException("Error occurred while getting inputstream", (Throwable)e);
                }
            }).collect(Collectors.toSet());
        }
        return null;
    }

    protected void processAndStoreApplicationDocuments(WaterConnectionDetails waterConnectionDetails) {
        if (!waterConnectionDetails.getApplicationDocs().isEmpty()) {
            for (ApplicationDocuments applicationDocument : waterConnectionDetails.getApplicationDocs()) {
                applicationDocument.setDocumentNames(this.documentNamesService.load(applicationDocument.getDocumentNames().getId()));
                applicationDocument.setWaterConnectionDetails(waterConnectionDetails);
                applicationDocument.setSupportDocs(this.addToFileStore(applicationDocument.getFiles()));
            }
        }
    }

    protected boolean validApplicationDocument(ApplicationDocuments applicationDocument) {
        return applicationDocument.getDocumentNames().isRequired() || applicationDocument.getDocumentNumber() != null || applicationDocument.getDocumentDate() != null;
    }
}

