/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.masters;

import java.util.List;
import javax.validation.Valid;
import org.egov.wtms.masters.entity.PropertyPipeSize;
import org.egov.wtms.masters.service.PipeSizeService;
import org.egov.wtms.masters.service.PropertyPipeSizeService;
import org.egov.wtms.masters.service.PropertyTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/masters"})
public class PropertyPipeSizeMasterController {
    private final PropertyTypeService propertyTypeService;
    private final PipeSizeService pipeSizeService;
    private final PropertyPipeSizeService propertyPipeSizeService;

    @Autowired
    public PropertyPipeSizeMasterController(PropertyTypeService propertyTypeService, PipeSizeService pipeSizeService, PropertyPipeSizeService propertyPipeSizeService) {
        this.propertyTypeService = propertyTypeService;
        this.pipeSizeService = pipeSizeService;
        this.propertyPipeSizeService = propertyPipeSizeService;
    }

    @RequestMapping(value={"/propertyPipeSizeMaster"}, method={RequestMethod.GET})
    public String viewForm(Model model) {
        PropertyPipeSize propertyPipeSize = new PropertyPipeSize();
        model.addAttribute("propertyPipeSize", (Object)propertyPipeSize);
        model.addAttribute("pipeSize", (Object)this.pipeSizeService.getAllActivePipeSize());
        model.addAttribute("propertyTypeList", (Object)this.propertyTypeService.getAllActivePropertyTypes());
        model.addAttribute("reqAttr", (Object)"false");
        model.addAttribute("mode", (Object)"create");
        return "property-pipesize-master";
    }

    @RequestMapping(value={"/propertyPipeSizeMaster"}, method={RequestMethod.POST})
    public String createPropertyPipeSizeMasterData(@Valid @ModelAttribute PropertyPipeSize propertyPipeSize, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            model.addAttribute("propertyTypeList", (Object)this.propertyTypeService.getAllActivePropertyTypes());
            model.addAttribute("pipeSize", (Object)this.pipeSizeService.getAllActivePipeSize());
            return "property-pipesize-master";
        }
        this.propertyPipeSizeService.createPropertyPipeSize(propertyPipeSize);
        redirectAttrs.addFlashAttribute("propertyPipeSize", (Object)propertyPipeSize);
        model.addAttribute("message", (Object)"Property PipeSize created successfully.");
        model.addAttribute("mode", (Object)"create");
        return "property-pipesize-master-success";
    }

    @RequestMapping(value={"/propertyPipeSizeMaster/list"}, method={RequestMethod.GET})
    public String getPropertyPipeSizeMasterList(Model model) {
        List propertyPipeSizeList = this.propertyPipeSizeService.findAll();
        model.addAttribute("propertyPipeSizeList", (Object)propertyPipeSizeList);
        return "property-pipesize-list";
    }

    @RequestMapping(value={"/propertyPipeSizeMaster/edit"}, method={RequestMethod.GET})
    public String getPropertyPipeSizeMaster(Model model) {
        model.addAttribute("mode", (Object)"edit");
        return this.getPropertyPipeSizeMasterList(model);
    }

    @RequestMapping(value={"/propertyPipeSizeMaster/edit/{propertyPipeSizeId}"}, method={RequestMethod.GET})
    public String getPropertyPipeSizeDetails(Model model, @PathVariable String propertyPipeSizeId) {
        PropertyPipeSize propertyPipeSize = this.propertyPipeSizeService.findOne(Long.valueOf(Long.parseLong(propertyPipeSizeId)));
        model.addAttribute("propertyPipeSize", (Object)propertyPipeSize);
        model.addAttribute("pipeSize", (Object)this.pipeSizeService.getAllActivePipeSize());
        model.addAttribute("propertyTypeList", (Object)this.propertyTypeService.getAllActivePropertyTypes());
        model.addAttribute("reqAttr", (Object)"true");
        return "property-pipesize-master";
    }

    @RequestMapping(value={"/propertyPipeSizeMaster/edit/{propertyPipeSizeId}"}, method={RequestMethod.POST})
    public String editPropertyPipeSizeData(@Valid @ModelAttribute PropertyPipeSize propertyPipeSize, BindingResult errors, RedirectAttributes redirectAttrs, Model model, @PathVariable long propertyPipeSizeId) {
        if (errors.hasErrors()) {
            model.addAttribute("propertyTypeList", (Object)this.propertyTypeService.getAllActivePropertyTypes());
            model.addAttribute("pipeSize", (Object)this.pipeSizeService.getAllActivePipeSize());
            return "property-pipesize-master";
        }
        this.propertyPipeSizeService.updatePropertyPipeSize(propertyPipeSize);
        redirectAttrs.addFlashAttribute("propertyPipeSize", (Object)propertyPipeSize);
        model.addAttribute("message", (Object)"Property PipeSize updated successfully.");
        return "property-pipesize-master-success";
    }
}

