/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.masters;

import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.validation.Valid;
import org.egov.wtms.masters.entity.DonationDetails;
import org.egov.wtms.masters.entity.DonationHeader;
import org.egov.wtms.masters.service.ConnectionCategoryService;
import org.egov.wtms.masters.service.DonationDetailsService;
import org.egov.wtms.masters.service.DonationHeaderService;
import org.egov.wtms.masters.service.PipeSizeService;
import org.egov.wtms.masters.service.PropertyTypeService;
import org.egov.wtms.masters.service.UsageTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/masters"})
public class DonationMasterController {
    @Autowired
    private DonationDetailsService donationDetailsService;
    @Autowired
    private final PropertyTypeService propertyTypeService;
    @Autowired
    private final DonationHeaderService donationHeaderService;
    @Autowired
    private final ConnectionCategoryService connectionCategoryService;
    @Autowired
    private final UsageTypeService usageTypeService;
    @Autowired
    private final PipeSizeService pipeSizeService;

    @Autowired
    public DonationMasterController(PropertyTypeService propertyTypeService, ConnectionCategoryService connectionCategoryService, UsageTypeService usageTypeService, PipeSizeService pipeSizeService, DonationHeaderService donationHeaderService) {
        this.propertyTypeService = propertyTypeService;
        this.connectionCategoryService = connectionCategoryService;
        this.usageTypeService = usageTypeService;
        this.pipeSizeService = pipeSizeService;
        this.donationHeaderService = donationHeaderService;
    }

    @RequestMapping(value={"/donationMaster"}, method={RequestMethod.GET})
    public String viewForm(Model model) {
        DonationDetails donationDetails = new DonationDetails();
        model.addAttribute("donationDetails", (Object)donationDetails);
        model.addAttribute("typeOfConnection", (Object)"DONATIONMASTER");
        model.addAttribute("categoryType", (Object)this.connectionCategoryService.getAllActiveConnectionCategory());
        model.addAttribute("propertyType", (Object)this.propertyTypeService.getAllActivePropertyTypes());
        model.addAttribute("usageType", (Object)this.usageTypeService.getActiveUsageTypes());
        model.addAttribute("reqAttr", (Object)"false");
        model.addAttribute("mode", (Object)"create");
        return "donation-master";
    }

    @RequestMapping(value={"/donationMaster"}, method={RequestMethod.POST})
    public String createDonationMasterDetails(@Valid @ModelAttribute DonationDetails donationDetails, BindingResult resultBinder, RedirectAttributes redirectAttrs, Model model) {
        if (resultBinder.hasErrors()) {
            return "donation-master";
        }
        List donationHeaderTempList = this.donationHeaderService.findDonationDetailsByPropertyAndCategoryAndUsageandPipeSize(donationDetails.getDonationHeader().getPropertyType(), donationDetails.getDonationHeader().getCategory(), donationDetails.getDonationHeader().getUsageType(), donationDetails.getDonationHeader().getMinPipeSize().getSizeInInch(), donationDetails.getDonationHeader().getMaxPipeSize().getSizeInInch());
        DonationDetails donationDetailsTempObj = null;
        Calendar.getInstance();
        if (!donationHeaderTempList.isEmpty()) {
            DonationHeader donationHeaderTemp;
            Iterator iterator = donationHeaderTempList.iterator();
            while (iterator.hasNext() && (donationDetailsTempObj = this.donationDetailsService.findByDonationHeaderAndFromDateAndToDate(donationHeaderTemp = (DonationHeader)iterator.next(), donationDetails.getFromDate(), donationDetails.getToDate())) == null) {
            }
            if (donationDetailsTempObj == null) {
                donationDetails.getDonationHeader().setActive(true);
                this.donationHeaderService.persistDonationHeader(donationDetails.getDonationHeader());
                this.donationDetailsService.persistDonationDetails(donationDetails);
                model.addAttribute("mode", (Object)"create");
                redirectAttrs.addFlashAttribute("donationDetails", (Object)donationDetails);
                model.addAttribute("message", (Object)"Donation Master Data created successfully.");
            }
        } else {
            donationDetails.getDonationHeader().setActive(true);
            this.donationHeaderService.persistDonationHeader(donationDetails.getDonationHeader());
            this.donationDetailsService.persistDonationDetails(donationDetails);
            redirectAttrs.addFlashAttribute("donationDetails", (Object)donationDetails);
            model.addAttribute("message", (Object)"Donation Master Data created successfully.");
            model.addAttribute("mode", (Object)"create");
        }
        return "donation-master-success";
    }

    @RequestMapping(value={"/donationMaster/list"}, method={RequestMethod.GET})
    public String getdonationMasterList(Model model) {
        List donationDetailsList = this.donationDetailsService.findAll();
        model.addAttribute("donationDetailsList", (Object)donationDetailsList);
        return "donation-master-list";
    }

    @RequestMapping(value={"/donationMaster/edit"}, method={RequestMethod.GET})
    public String getDonationMaster(Model model) {
        model.addAttribute("mode", (Object)"edit");
        return this.getdonationMasterList(model);
    }

    @RequestMapping(value={"/donationMaster/edit/{donationDetailsId}"}, method={RequestMethod.GET})
    public String getWaterRatesMasterData(Model model, @PathVariable Long donationDetailsId) {
        DonationDetails donationDetails = this.donationDetailsService.findBy(donationDetailsId);
        model.addAttribute("donationDetails", (Object)donationDetails);
        model.addAttribute("typeOfConnection", (Object)"DONATIONMASTER");
        model.addAttribute("categoryType", (Object)this.connectionCategoryService.getAllActiveConnectionCategory());
        model.addAttribute("propertyType", (Object)this.propertyTypeService.getAllActivePropertyTypes());
        model.addAttribute("usageType", (Object)this.usageTypeService.getActiveUsageTypes());
        model.addAttribute("maxPipeSizeList", (Object)this.pipeSizeService.getAllActivePipeSize());
        model.addAttribute("minPipeSizeList", (Object)this.pipeSizeService.getAllActivePipeSize());
        model.addAttribute("reqAttr", (Object)"true");
        return "donation-master";
    }

    @RequestMapping(value={"/donationMaster/edit/{donationDetailsId}"}, method={RequestMethod.POST})
    public String editDonationMasterData(@Valid @ModelAttribute DonationDetails donationDetails, BindingResult resultBinder, @PathVariable Long donationDetailsId, RedirectAttributes redirectAttrs, Model model) {
        if (resultBinder.hasErrors()) {
            return "donation-master";
        }
        DonationHeader donationheader = donationDetails.getDonationHeader();
        DonationDetails donationdetails = this.donationDetailsService.findBy(donationDetailsId);
        DonationHeader donationHeader = donationdetails.getDonationHeader();
        List donationHeaderTempList = this.donationHeaderService.findDonationDetailsByPropertyAndCategoryAndUsageandPipeSize(donationDetails.getDonationHeader().getPropertyType(), donationDetails.getDonationHeader().getCategory(), donationDetails.getDonationHeader().getUsageType(), donationDetails.getDonationHeader().getMinPipeSize().getSizeInInch(), donationDetails.getDonationHeader().getMaxPipeSize().getSizeInInch());
        Calendar.getInstance();
        DonationDetails donationDetailsTemp = null;
        if (!donationHeaderTempList.isEmpty()) {
            DonationHeader donationHeaderTemp;
            Iterator iterator = donationHeaderTempList.iterator();
            while (iterator.hasNext() && (donationDetailsTemp = this.donationDetailsService.findByDonationHeaderAndFromDateAndToDate(donationHeaderTemp = (DonationHeader)iterator.next(), donationDetails.getFromDate(), donationDetails.getToDate())) == null) {
            }
            if (donationDetailsTemp == null) {
                donationDetails.getDonationHeader().setActive(true);
                this.donationHeaderService.persistDonationHeader(donationDetails.getDonationHeader());
                this.donationDetailsService.persistDonationDetails(donationDetails);
            }
        }
        if (donationHeaderTempList.isEmpty() || !donationDetails.getDonationHeader().isActive()) {
            donationHeader.setActive(donationheader.isActive());
            donationHeader.setCategory(donationheader.getCategory());
            donationHeader.setMaxPipeSize(donationheader.getMaxPipeSize());
            donationHeader.setMinPipeSize(donationheader.getMinPipeSize());
            donationHeader.setPropertyType(donationheader.getPropertyType());
            donationHeader.setUsageType(donationheader.getUsageType());
            donationdetails.setAmount(donationDetails.getAmount());
            donationdetails.setFromDate(donationDetails.getFromDate());
            donationdetails.setToDate(donationDetails.getToDate());
            donationdetails.setDonationHeader(donationHeader);
            this.donationHeaderService.persistDonationHeader(donationdetails.getDonationHeader());
            this.donationDetailsService.persistDonationDetails(donationdetails);
            redirectAttrs.addFlashAttribute("donationDetails", (Object)donationDetails);
            model.addAttribute("message", (Object)"Donation Master Data updated successfully.");
        }
        return "donation-master-success";
    }
}

