/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.utils.DateUtils;
import org.egov.wtms.application.entity.MeterReadingConnectionDetails;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.repository.WaterConnectionDetailsRepository;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.WaterRatesDetails;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.repository.WaterRatesDetailsRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/application"})
public class MeterReadingController {
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    private final WaterConnectionDetailsRepository waterConnectionDetailsRepository;
    private final WaterRatesDetailsRepository waterRatesDetailsRepository;
    private final ConnectionDemandService connectionDemandService;

    @Autowired
    public MeterReadingController(WaterConnectionDetailsRepository waterConnectionDetailsRepository, WaterRatesDetailsRepository waterRatesDetailsRepository, ConnectionDemandService connectionDemandService) {
        this.waterConnectionDetailsRepository = waterConnectionDetailsRepository;
        this.waterRatesDetailsRepository = waterRatesDetailsRepository;
        this.connectionDemandService = connectionDemandService;
    }

    @ModelAttribute
    public WaterConnectionDetails getWaterConnectionDetails(@PathVariable String consumerCode) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(consumerCode, ConnectionStatus.ACTIVE);
        return waterConnectionDetails;
    }

    private String loadViewData(Model model, WaterConnectionDetails waterConnectionDetails) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        model.addAttribute("waterConnectionDetails", (Object)waterConnectionDetails);
        model.addAttribute("executionDate", (Object)formatter.format(waterConnectionDetails.getExecutionDate()));
        model.addAttribute("feeDetails", (Object)this.connectionDemandService.getSplitFee(waterConnectionDetails));
        model.addAttribute("connectionType", this.waterConnectionDetailsService.getConnectionTypesMap().get(waterConnectionDetails.getConnectionType().name()));
        model.addAttribute("mode", (Object)"meterEntry");
        model.addAttribute("meterReadingCurrentObj", (Object)new MeterReadingConnectionDetails());
        BigDecimal waterTaxDueforParent = this.waterConnectionDetailsService.getTotalAmount(waterConnectionDetails);
        model.addAttribute("waterTaxDueforParent", (Object)waterTaxDueforParent);
        return "newconnection-meterEntry";
    }

    @RequestMapping(value={"/meterentry/{consumerCode}"}, method={RequestMethod.GET})
    public String view(Model model, @PathVariable String consumerCode, HttpServletRequest request) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(consumerCode, ConnectionStatus.ACTIVE);
        MeterReadingConnectionDetails meterReadingpriviousObj = null;
        List meterReadingpriviousObjlist = this.waterConnectionDetailsRepository.findPreviousMeterReadingReading(waterConnectionDetails.getId());
        if (!meterReadingpriviousObjlist.isEmpty()) {
            meterReadingpriviousObj = (MeterReadingConnectionDetails)meterReadingpriviousObjlist.get(0);
        } else {
            meterReadingpriviousObj = new MeterReadingConnectionDetails();
            if (waterConnectionDetails.getConnection().getInitialReading() != null) {
                meterReadingpriviousObj.setCurrentReading(waterConnectionDetails.getConnection().getInitialReading());
            } else {
                meterReadingpriviousObj.setCurrentReading(Long.valueOf(0L));
            }
        }
        model.addAttribute("meterReadingpriviousObj", (Object)meterReadingpriviousObj);
        if (this.connectionDemandService.meterEntryAllReadyExistForCurrentMonth(waterConnectionDetails, new Date()).booleanValue()) {
            return "redirect:/application/meterdemandnotice?pathVar=" + waterConnectionDetails.getConnection().getConsumerCode();
        }
        return this.loadViewData(model, waterConnectionDetails);
    }

    @RequestMapping(value={"/meterentry/{consumerCode}"}, method={RequestMethod.POST})
    public String updateMeterEntry(@ModelAttribute WaterConnectionDetails waterConnectionDetails, BindingResult errors, RedirectAttributes redirectAttrs, Model model, HttpServletRequest request) {
        String sourceChannel = request.getParameter("Source");
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault());
        Date givenDate = null;
        try {
            givenDate = dateFormat.parse(request.getParameter("metercurrentReadingDate"));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (this.connectionDemandService.meterEntryAllReadyExistForCurrentMonth(waterConnectionDetails, givenDate).booleanValue()) {
            return "redirect:/application/meterdemandnotice?pathVar=" + waterConnectionDetails.getConnection().getConsumerCode();
        }
        MeterReadingConnectionDetails meterReadingConnectionDeatilObj = new MeterReadingConnectionDetails();
        Long previousReading = 0L;
        if (errors.hasErrors()) {
            return "newconnection-meterEntry";
        }
        if (null != request.getParameter("previousreading") && !"".equals(request.getParameter("previousreading"))) {
            previousReading = Long.valueOf(request.getParameter("previousreading"));
        }
        if (Long.valueOf(request.getParameter("metercurrentReading")) < previousReading) {
            String message = "Current rate should not be less than Previous reading";
            model.addAttribute("message", (Object)"Current rate should not be less than Previous reading");
            return "newconnection-meterEntry";
        }
        WaterConnectionDetails waterconnectionDetails = this.billCalculationAndDemandUpdate(waterConnectionDetails, errors, request, meterReadingConnectionDeatilObj, previousReading, dateFormat);
        WaterConnectionDetails savedWaterConnectionDetails = (WaterConnectionDetails)this.waterConnectionDetailsRepository.save((Object)waterconnectionDetails);
        this.waterConnectionDetailsService.updateIndexes(savedWaterConnectionDetails, sourceChannel);
        return "redirect:/application/meterdemandnotice?pathVar=" + savedWaterConnectionDetails.getConnection().getConsumerCode();
    }

    private WaterConnectionDetails billCalculationAndDemandUpdate(WaterConnectionDetails waterConnectionDetails, BindingResult errors, HttpServletRequest request, MeterReadingConnectionDetails meterReadingConnectionDeatilObj, Long previousReading, SimpleDateFormat dateFormat) {
        Date currentDate = null;
        Date previousDate = null;
        int noofmonths = 0;
        String readingDate = request.getParameter("metercurrentReadingDate");
        try {
            currentDate = dateFormat.parse(readingDate);
            if (request.getParameter("previousreadingDate") != null) {
                previousDate = dateFormat.parse(request.getParameter("previousreadingDate"));
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        meterReadingConnectionDeatilObj.setCurrentReading(Long.valueOf(request.getParameter("metercurrentReading")));
        meterReadingConnectionDeatilObj.setCurrentReadingDate(currentDate);
        this.populateMeterReadingDetails(meterReadingConnectionDeatilObj, waterConnectionDetails);
        noofmonths = previousDate != null ? DateUtils.noOfMonths((Date)previousDate, (Date)currentDate) : DateUtils.noOfMonths((Date)new Date(), (Date)currentDate);
        Long currentToPreviousDiffOfUnits = Long.valueOf(request.getParameter("metercurrentReading")) - previousReading;
        Long noOfUnitsForPerMonth = 0L;
        noOfUnitsForPerMonth = noofmonths > 0 ? Long.valueOf(currentToPreviousDiffOfUnits / (long)noofmonths) : currentToPreviousDiffOfUnits;
        double finalAmountToBePaid = this.calculateAmountTobePaid(waterConnectionDetails, noofmonths, noOfUnitsForPerMonth);
        WaterConnectionDetails waterconnectionDetails = null;
        if (BigDecimal.valueOf(finalAmountToBePaid).compareTo(BigDecimal.ZERO) > 0) {
            waterconnectionDetails = this.connectionDemandService.updateDemandForMeteredConnection(waterConnectionDetails, BigDecimal.valueOf(finalAmountToBePaid), currentDate);
        }
        return waterconnectionDetails;
    }

    private double calculateAmountTobePaid(WaterConnectionDetails waterConnectionDetails, int noofmonths, Long noOfUnitsForPerMonth) {
        WaterRatesDetails waterRateDetail = null;
        List waterDetList = this.waterRatesDetailsRepository.findByWaterRate(waterConnectionDetails.getConnectionType(), waterConnectionDetails.getUsageType(), noOfUnitsForPerMonth);
        if (!waterDetList.isEmpty()) {
            waterRateDetail = (WaterRatesDetails)waterDetList.get(0);
        }
        double amountToBeCollectedWithUnitRatePerMonth = (double)noOfUnitsForPerMonth.longValue() * (waterRateDetail != null ? waterRateDetail.getUnitRate() : 0.0);
        double finalAmountToBePaid = 0.0;
        finalAmountToBePaid = noofmonths > 0 ? amountToBeCollectedWithUnitRatePerMonth * (double)noofmonths : amountToBeCollectedWithUnitRatePerMonth;
        return finalAmountToBePaid;
    }

    private void populateMeterReadingDetails(MeterReadingConnectionDetails meterReadingConnectionDeatilObj, WaterConnectionDetails waterConnectionDetails) {
        ArrayList<MeterReadingConnectionDetails> meterentryDetailsList = new ArrayList<MeterReadingConnectionDetails>(0);
        if (meterReadingConnectionDeatilObj != null && this.validMeterEntryDetail(meterReadingConnectionDeatilObj)) {
            meterReadingConnectionDeatilObj.setWaterConnectionDetails(waterConnectionDetails);
            meterentryDetailsList.add(meterReadingConnectionDeatilObj);
        }
        waterConnectionDetails.getMeterConnection().clear();
        waterConnectionDetails.setMeterConnection(meterentryDetailsList);
    }

    private boolean validMeterEntryDetail(MeterReadingConnectionDetails meterReadingConnectionDetails) {
        return meterReadingConnectionDetails != null && (meterReadingConnectionDetails == null || meterReadingConnectionDetails.getCurrentReading() != null || meterReadingConnectionDetails.getCurrentReadingDate() != null);
    }
}

