/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.reports;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.wtms.application.entity.DataEntryConnectionReport;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.DataEntryConnectionReportService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.web.controller.reports.DataEntryConnectionReportAdaptor;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report/dataEntryConnectionReport/search"})
public class DataEntryConnectionReportController {
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private DataEntryConnectionReportService dataEntryConnectionReportService;
    @Autowired
    public WaterConnectionDetailsService waterConnectionDetailsService;

    @RequestMapping(method={RequestMethod.GET})
    public String search(Model model) {
        model.addAttribute("currentDate", (Object)new Date());
        return "dataEntryReport-search";
    }

    @ModelAttribute
    public DataEntryConnectionReport reportModel() {
        return new DataEntryConnectionReport();
    }

    @ModelAttribute(value="revenueWards")
    public List<Boundary> revenueWardList() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("WARD", "REVENUE");
    }

    @RequestMapping(value={"/result/"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void searchResult(HttpServletRequest request, HttpServletResponse response) throws IOException, ParseException {
        String ward = "";
        if (null != request.getParameter("ward")) {
            ward = request.getParameter("ward");
        }
        List dataEntryConnectionReportlist = new ArrayList();
        SQLQuery query = this.dataEntryConnectionReportService.getDataEntryConnectionReportDetails(ward);
        dataEntryConnectionReportlist = query.list();
        String result = null;
        for (DataEntryConnectionReport dataEntryReport : dataEntryConnectionReportlist) {
            WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCode(dataEntryReport.getHscNo());
            if (waterConnectionDetails.getExistingConnection() == null) continue;
            dataEntryReport.setDonationCharges(waterConnectionDetails.getExistingConnection().getDonationCharges().doubleValue());
            dataEntryReport.setMonthlyFee(waterConnectionDetails.getExistingConnection().getMonthlyFee().doubleValue());
        }
        result = "{ \"data\":" + this.toJSON(dataEntryConnectionReportlist) + "}";
        response.setContentType("application/json");
        IOUtils.write((String)result, (Writer)response.getWriter());
    }

    private Object toJSON(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(DataEntryConnectionReport.class, (Object)new DataEntryConnectionReportAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

