/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.elasticSearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.egov.config.search.Index;
import org.egov.config.search.IndexType;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.search.elastic.entity.ApplicationIndex;
import org.egov.search.domain.Document;
import org.egov.search.domain.Page;
import org.egov.search.domain.SearchResult;
import org.egov.search.domain.Sort;
import org.egov.search.service.SearchService;
import org.egov.wtms.elasticSearch.entity.ApplicationSearchRequest;
import org.egov.wtms.elasticSearch.service.ApplicationSearchService;
import org.egov.wtms.utils.WaterTaxUtils;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/elastic/appSearch/"})
public class ApplicationSearchController {
    private final ApplicationSearchService applicationSearchService;
    private final SearchService searchService;
    private final CityService cityService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;

    @Autowired
    public ApplicationSearchController(ApplicationSearchService applicationSearchService, SearchService searchService, CityService cityService) {
        this.applicationSearchService = applicationSearchService;
        this.searchService = searchService;
        this.cityService = cityService;
    }

    @RequestMapping(value={"/ajax-moduleTypepopulate"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<ApplicationIndex> getAppConfigs(@ModelAttribute(value="appConfig") @RequestParam String appModuleName) {
        List applicationIndexList = this.applicationSearchService.findApplicationIndexApplicationTypes(appModuleName);
        return applicationIndexList;
    }

    @ModelAttribute(value="sourceList")
    public List<ApplicationIndex> getSourceList() {
        return this.applicationSearchService.getSourceList();
    }

    @ModelAttribute
    public ApplicationSearchRequest searchRequest() {
        return new ApplicationSearchRequest();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String newSearchForm(Model model) {
        model.addAttribute("citizenRole", (Object)this.waterTaxUtils.getCitizenUserRole());
        return "applicationSearch-newForm";
    }

    @ModelAttribute(value="modulesList")
    public List<ApplicationIndex> findApplicationIndexModules() {
        return this.applicationSearchService.findApplicationIndexModules();
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public List<Document> searchApplication(@ModelAttribute ApplicationSearchRequest searchRequest) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        searchRequest.setUlbName(cityWebsite.getName());
        Sort sort = Sort.by().field("searchable.applicationdate", SortOrder.DESC);
        SearchResult searchResult = this.searchService.search(Arrays.asList(Index.APPLICATION.toString()), Arrays.asList(IndexType.APPLICATIONSEARCH.toString()), searchRequest.searchQuery(), searchRequest.searchFilters(), sort, Page.NULL);
        ArrayList<Document> searchResultFomatted = new ArrayList<Document>(0);
        for (Document document : searchResult.getDocuments()) {
            document.getResource().remove((Object)"searchable.mobilenumber");
            document.getResource().remove((Object)"searchable.aadharnumber");
            searchResultFomatted.add(document);
        }
        return searchResultFomatted;
    }
}

