/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.io.ByteArrayInputStream;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.WordUtils;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/application"})
public class WorkOrderController {
    @Autowired
    private ReportService reportService;
    @Autowired
    private ResourceBundleMessageSource messageSource;
    public static final String CONNECTIONWORKORDER = "connectionWorkOrder";
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    private final Map<String, Object> reportParams = new HashMap();
    private ReportRequest reportInput = null;
    private ReportOutput reportOutput = null;
    String errorMessage = "";
    private String workFlowAction = "";
    @Autowired
    private WaterConnectionDetailsService wcdService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private SecurityUtils securityUtils;

    @RequestMapping(value={"/workorder"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> createWorkOrderReport(HttpServletRequest request, HttpSession session) {
        WaterConnectionDetails connectionDetails = this.wcdService.findByApplicationNumber(request.getParameter("pathVar"));
        this.workFlowAction = (String)session.getAttribute("workFlowAction");
        Boolean isDigSignPending = Boolean.parseBoolean(request.getParameter("isDigSignPending"));
        if (isDigSignPending.booleanValue()) {
            this.workFlowAction = request.getParameter("workFlowAction");
        }
        if (null != this.workFlowAction && !this.workFlowAction.isEmpty() && this.workFlowAction.equalsIgnoreCase("Generate WorkOrder")) {
            this.validateWorkOrder(connectionDetails, Boolean.valueOf(true));
        }
        if (!this.errorMessage.isEmpty()) {
            return this.redirect();
        }
        return this.generateReport(connectionDetails, session);
    }

    private ResponseEntity<byte[]> generateReport(WaterConnectionDetails connectionDetails, HttpSession session) {
        if (null != connectionDetails) {
            AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(connectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ACTIVE);
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            String[] doorno = assessmentDetails.getPropertyAddress().split(",");
            String ownerName = "";
            Iterator iterator = assessmentDetails.getOwnerNames().iterator();
            if (iterator.hasNext()) {
                OwnerName names = (OwnerName)iterator.next();
                ownerName = names.getOwnerName();
            }
            if ("NEWCONNECTION".equalsIgnoreCase(connectionDetails.getApplicationType().getCode())) {
                this.reportParams.put("conntitle", WordUtils.capitalize((String)connectionDetails.getApplicationType().getName()).toString());
                this.reportParams.put("applicationtype", this.messageSource.getMessage("msg.new.watertap.conn", null, null));
            } else if ("ADDNLCONNECTION".equalsIgnoreCase(connectionDetails.getApplicationType().getCode())) {
                this.reportParams.put("conntitle", WordUtils.capitalize((String)connectionDetails.getApplicationType().getName()).toString());
                this.reportParams.put("applicationtype", this.messageSource.getMessage("msg.add.watertap.conn", null, null));
            } else {
                this.reportParams.put("conntitle", WordUtils.capitalize((String)connectionDetails.getApplicationType().getName()).toString());
                this.reportParams.put("applicationtype", this.messageSource.getMessage("msg.changeofuse.watertap.conn", null, null));
            }
            this.reportParams.put("municipality", session.getAttribute("citymunicipalityname"));
            this.reportParams.put("district", session.getAttribute("districtName"));
            this.reportParams.put("purpose", connectionDetails.getUsageType().getName());
            if (null != this.workFlowAction) {
                if (this.workFlowAction.equalsIgnoreCase("Generate WorkOrder")) {
                    this.reportParams.put("workorderdate", formatter.format(connectionDetails.getWorkOrderDate()));
                    this.reportParams.put("workorderno", connectionDetails.getWorkOrderNumber());
                }
                if (this.workFlowAction.equalsIgnoreCase("Preview")) {
                    this.reportParams.put("workorderdate", "");
                    this.reportParams.put("workorderno", "");
                }
                if (this.workFlowAction.equalsIgnoreCase("Sign")) {
                    this.reportParams.put("workorderdate", formatter.format(connectionDetails.getWorkOrderDate()));
                    this.reportParams.put("workorderno", connectionDetails.getWorkOrderNumber());
                    User user = this.securityUtils.getCurrentUser();
                    this.reportParams.put("userId", user.getId());
                }
            }
            this.reportParams.put("workFlowAction", this.workFlowAction);
            this.reportParams.put("consumerNumber", connectionDetails.getConnection().getConsumerCode());
            this.reportParams.put("applicantname", WordUtils.capitalize((String)ownerName));
            this.reportParams.put("address", assessmentDetails.getPropertyAddress());
            this.reportParams.put("doorno", doorno[0]);
            this.reportParams.put("usersignature", this.securityUtils.getCurrentUser().getSignature() != null ? new ByteArrayInputStream(this.securityUtils.getCurrentUser().getSignature()) : null);
            this.reportParams.put("applicationDate", formatter.format(connectionDetails.getApplicationDate()));
            this.reportInput = new ReportRequest(CONNECTIONWORKORDER, (Object)connectionDetails, this.reportParams);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=Work Order.pdf");
        this.reportOutput = this.reportService.createReport(this.reportInput);
        return new ResponseEntity((Object)this.reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    public void validateWorkOrder(WaterConnectionDetails connectionDetails, Boolean isView) {
        if (null != connectionDetails && connectionDetails.getLegacy().booleanValue()) {
            this.errorMessage = this.messageSource.getMessage("err.validate.workorder.for.legacy", (Object[])new String[]{""}, null);
        } else if (isView.booleanValue() && null == connectionDetails.getWorkOrderNumber()) {
            this.errorMessage = this.messageSource.getMessage("err.validate.workorder.view", (Object[])new String[]{connectionDetails.getApplicationNumber()}, null);
        } else if (!isView.booleanValue() && !connectionDetails.getStatus().getCode().equalsIgnoreCase("WORKORDERGENERATED")) {
            this.errorMessage = this.messageSource.getMessage("err.validate.workorder.view", (Object[])new String[]{connectionDetails.getApplicationNumber()}, null);
        }
    }

    @RequestMapping(value={"/workorder/view/{applicationNumber}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> viewReport(@PathVariable String applicationNumber, HttpSession session) {
        WaterConnectionDetails connectionDetails = this.wcdService.findByApplicationNumber(applicationNumber);
        this.validateWorkOrder(connectionDetails, Boolean.valueOf(true));
        if (!this.errorMessage.isEmpty()) {
            return this.redirect();
        }
        return this.generateReport(connectionDetails, session);
    }

    private ResponseEntity<byte[]> redirect() {
        this.errorMessage = "<html><body><p style='color:red;border:1px solid gray;padding:15px;'>" + this.errorMessage + "</p></body></html>";
        byte[] byteData = this.errorMessage.getBytes();
        this.errorMessage = "";
        return new ResponseEntity((Object)byteData, HttpStatus.CREATED);
    }
}

