/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.WordUtils;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/application"})
public class EstimationNoticeController {
    @Autowired
    private ReportService reportService;
    public static final String ESTIMATION_NOTICE = "estimationNotice";
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    private final Map<String, Object> reportParams = new HashMap();
    private ReportRequest reportInput = null;
    private ReportOutput reportOutput = null;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;

    @RequestMapping(value={"/estimationNotice"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateEstimationNotice(HttpServletRequest request, HttpSession session) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumber(request.getParameter("pathVar"));
        return this.generateReport(waterConnectionDetails, session);
    }

    private ResponseEntity<byte[]> generateReport(WaterConnectionDetails waterConnectionDetails, HttpSession session) {
        if (waterConnectionDetails != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ACTIVE);
            String[] doorNo = assessmentDetails.getPropertyAddress().split(",");
            String ownerName = "";
            Iterator iterator = assessmentDetails.getOwnerNames().iterator();
            if (iterator.hasNext()) {
                OwnerName names = (OwnerName)iterator.next();
                ownerName = names.getOwnerName();
            }
            if ("NEWCONNECTION".equalsIgnoreCase(waterConnectionDetails.getApplicationType().getCode())) {
                this.reportParams.put("applicationType", WordUtils.capitalize((String)waterConnectionDetails.getApplicationType().getName()).toString());
            } else if ("ADDNLCONNECTION".equalsIgnoreCase(waterConnectionDetails.getApplicationType().getCode())) {
                this.reportParams.put("applicationType", WordUtils.capitalize((String)waterConnectionDetails.getApplicationType().getName()).toString());
            } else {
                this.reportParams.put("applicationType", WordUtils.capitalize((String)waterConnectionDetails.getApplicationType().getName()).toString());
            }
            this.reportParams.put("cityName", session.getAttribute("citymunicipalityname"));
            this.reportParams.put("district", session.getAttribute("districtName"));
            this.reportParams.put("estimationDate", formatter.format(waterConnectionDetails.getFieldInspectionDetails().getCreatedDate()));
            this.reportParams.put("estimationCharges", waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges());
            this.reportParams.put("donationCharges", waterConnectionDetails.getDonationCharges());
            this.reportParams.put("totalCharges", waterConnectionDetails.getDonationCharges() + waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges());
            this.reportParams.put("applicationDate", formatter.format(waterConnectionDetails.getApplicationDate()));
            this.reportParams.put("applicantName", ownerName);
            this.reportParams.put("address", assessmentDetails.getPropertyAddress());
            this.reportParams.put("houseNo", doorNo[0]);
            this.reportInput = new ReportRequest(ESTIMATION_NOTICE, (Collection)waterConnectionDetails.getEstimationDetails(), this.reportParams);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=EstimationNotice.pdf");
        this.reportOutput = this.reportService.createReport(this.reportInput);
        return new ResponseEntity((Object)this.reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/estimationNotice/view/{applicationNumber}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> viewEstimationNotice(@PathVariable String applicationNumber, HttpSession session) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumber(applicationNumber);
        return this.generateReport(waterConnectionDetails, session);
    }
}

