/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.repository.FileStoreMapperRepository;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.WorkflowTypes;
import org.egov.infra.workflow.inbox.InboxRenderServiceDeligate;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ReportGenerationService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.service.UsageTypeService;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.egov.wtms.utils.WaterTaxNumberGenerator;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/digitalSignature"})
public class DigitalSignatureConnectionController {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private InboxRenderServiceDeligate<StateAware> inboxRenderServiceDeligate;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private WaterTaxNumberGenerator waterTaxNumberGenerator;
    @Autowired
    protected UsageTypeService usageTypeService;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private ReportGenerationService reportGenerationService;
    @Autowired
    private FileStoreMapperRepository fileStoreMapperRepository;

    @RequestMapping(value={"/waterTax/transitionWorkflow"})
    public String transitionWorkflow(HttpServletRequest request, Model model) {
        String fileStoreIds = request.getParameter("fileStoreId");
        String[] fileStoreIdArr = fileStoreIds.split(",");
        HttpSession session = request.getSession();
        String sourceChannel = request.getParameter("Source");
        Long approvalPosition = (Long)session.getAttribute("approvalPosition");
        String approvalComent = (String)session.getAttribute("approvalComment");
        Map appNoFileStoreIdsMap = (Map)session.getAttribute("fileStoreIdApplicationNumber");
        WaterConnectionDetails waterConnectionDetails = null;
        for (String fileStoreId : fileStoreIdArr) {
            String applicationNumber = (String)appNoFileStoreIdsMap.get(fileStoreId);
            if (null == applicationNumber || applicationNumber.isEmpty()) continue;
            waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumber(applicationNumber);
            if (null == approvalPosition) {
                String additionalRule = waterConnectionDetails.getApplicationType().getCode();
                if (additionalRule.equalsIgnoreCase("CLOSINGCONNECTION")) {
                    additionalRule = "CLOSECONNECTION";
                }
                approvalPosition = this.waterConnectionDetailsService.getApprovalPositionByMatrixDesignation(waterConnectionDetails, approvalPosition, additionalRule, "", "Sign");
            }
            this.waterConnectionDetailsService.updateWaterConnection(waterConnectionDetails, approvalPosition, approvalComent, waterConnectionDetails.getApplicationType().getCode(), "Sign", "", null, sourceChannel);
        }
        model.addAttribute("successMessage", (Object)"Digitally Signed Successfully");
        model.addAttribute("fileStoreId", (Object)(fileStoreIdArr.length == 1 ? fileStoreIdArr[0] : ""));
        return "digitalSignature-success";
    }

    @RequestMapping(value={"/waterTax/downloadSignedWorkOrderConnection"})
    public void downloadSignedWorkOrderConnection(HttpServletRequest request, HttpServletResponse response) {
        String signedFileStoreId = request.getParameter("signedFileStoreId");
        File file = this.fileStoreService.fetch(signedFileStoreId, "WTMS");
        FileStoreMapper fileStoreMapper = this.fileStoreMapperRepository.findByFileStoreId(signedFileStoreId);
        response.setContentType("application/pdf");
        response.setContentType("application/octet-stream");
        response.setHeader("content-disposition", "attachment; filename=\"" + fileStoreMapper.getFileName() + "\"");
        try {
            FileInputStream inStream = new FileInputStream(file);
            PrintWriter outStream = response.getWriter();
            int bytesRead = -1;
            while ((bytesRead = inStream.read()) != -1) {
                outStream.write(bytesRead);
            }
            inStream.close();
            outStream.close();
        }
        catch (FileNotFoundException fileNotFoundExcep) {
            throw new ApplicationRuntimeException("Exception while loading file : " + fileNotFoundExcep);
        }
        catch (IOException ioExcep) {
            throw new ApplicationRuntimeException("Exception while generating work order : " + ioExcep);
        }
    }

    @RequestMapping(value={"/digitalSignaturePending-form"}, method={RequestMethod.GET})
    public String searchForm(HttpServletRequest request, Model model) {
        String cityMunicipalityName = (String)request.getSession().getAttribute("citymunicipalityname");
        String districtName = (String)request.getSession().getAttribute("districtName");
        List resultList = this.getRecordsForDigitalSignature();
        model.addAttribute("digitalSignatureReportList", (Object)resultList);
        model.addAttribute("noticeType", (Object)"Special Notice");
        model.addAttribute("cityMunicipalityName", (Object)cityMunicipalityName);
        model.addAttribute("districtName", (Object)districtName);
        return "digitalSignaturePending-form";
    }

    @RequestMapping(value={"/waterTax/signWorkOrder"}, method={RequestMethod.POST})
    public String signWorkOrder(HttpServletRequest request, Model model) {
        WaterConnectionDetails waterConnectionDetails = null;
        String[] applicationNumbers = null;
        String[] appNumberConTypePair = null;
        HashMap<String, String> fileStoreIdsApplicationNoMap = new HashMap<String, String>();
        StringBuffer fileStoreIds = new StringBuffer();
        String pathVar = request.getParameter("pathVar");
        String applicationNoStatePair = request.getParameter("applicationNoStatePair");
        String currentState = request.getParameter("currentState");
        String signAll = request.getParameter("signAll");
        String fileName = "";
        if (pathVar != null) {
            applicationNumbers = request.getParameter("pathVar").split(",");
            if (applicationNoStatePair != null) {
                appNumberConTypePair = applicationNoStatePair.split(",");
            }
            for (int i = 0; i < applicationNumbers.length; ++i) {
                waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumber(applicationNumbers[i]);
                String cityMunicipalityName = (String)request.getSession().getAttribute("citymunicipalityname");
                String districtName = (String)request.getSession().getAttribute("districtName");
                waterConnectionDetails.setWorkOrderDate(new Date());
                waterConnectionDetails.setWorkOrderNumber(this.waterTaxNumberGenerator.generateWorkOrderNumber());
                ReportOutput reportOutput = null;
                if (signAll != null && signAll.equalsIgnoreCase("SIGN_ALL")) {
                    for (int j = 0; j < appNumberConTypePair.length; ++j) {
                        String[] appNoStatePair = appNumberConTypePair[j].split(":");
                        if (!applicationNumbers[i].equalsIgnoreCase(appNoStatePair[0])) continue;
                        currentState = appNoStatePair[1];
                    }
                }
                if (currentState.equalsIgnoreCase("CLOSECONNECTION")) {
                    reportOutput = this.reportGenerationService.generateClosureConnectionReport(waterConnectionDetails, "Sign", cityMunicipalityName, districtName);
                    fileName = "SN/" + waterConnectionDetails.getApplicationNumber() + ".pdf";
                } else if (currentState.equalsIgnoreCase("RECONNECTION")) {
                    reportOutput = this.reportGenerationService.generateReconnectionReport(waterConnectionDetails, "Sign", cityMunicipalityName, districtName);
                    fileName = "SN/" + waterConnectionDetails.getApplicationNumber() + ".pdf";
                } else {
                    reportOutput = this.reportGenerationService.getReportOutput(waterConnectionDetails, "Sign", cityMunicipalityName, districtName);
                    fileName = "SN/" + waterConnectionDetails.getWorkOrderNumber() + ".pdf";
                }
                if (reportOutput == null) continue;
                ByteArrayInputStream fileStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
                FileStoreMapper fileStore = this.fileStoreService.store((InputStream)fileStream, fileName, "application/pdf", "WTMS");
                waterConnectionDetails.setFileStore(fileStore);
                waterConnectionDetails = this.waterConnectionDetailsService.updateWaterConnectionDetailsWithFileStore(waterConnectionDetails);
                fileStoreIdsApplicationNoMap.put(waterConnectionDetails.getFileStore().getFileStoreId(), applicationNumbers[i]);
                fileStoreIds.append(waterConnectionDetails.getFileStore().getFileStoreId());
                if (i >= applicationNumbers.length - 1) continue;
                fileStoreIds.append(",");
            }
            request.getSession().setAttribute("fileStoreIdApplicationNumber", fileStoreIdsApplicationNoMap);
            model.addAttribute("fileStoreIds", (Object)fileStoreIds.toString());
            model.addAttribute("ulbCode", (Object)ApplicationThreadLocals.getCityCode());
        }
        return "newConnection-digitalSignatureRedirection";
    }

    public List<HashMap<String, Object>> getRecordsForDigitalSignature() {
        ArrayList<HashMap<String, Object>> resultList = new ArrayList<HashMap<String, Object>>();
        List stateAwareList = this.fetchItems();
        WaterConnectionDetails waterConnectionDetails = null;
        if (null != stateAwareList && !stateAwareList.isEmpty()) {
            HashMap<String, String> tempMap = new HashMap<String, String>();
            WorkflowTypes workflowTypes = null;
            List workflowTypesList = new ArrayList();
            for (StateAware record : stateAwareList) {
                if (record == null || record.getState() == null || record.getState().getNextAction() == null || !record.getState().getNextAction().equalsIgnoreCase("Digital Signature Pending")) continue;
                tempMap = new HashMap();
                workflowTypesList = this.getCurrentSession().getNamedQuery("WF_TYPE_BY_TYPE_AND_RENDER_Y").setString(0, record.getStateType()).list();
                workflowTypes = workflowTypesList != null && !workflowTypesList.isEmpty() ? (WorkflowTypes)workflowTypesList.get(0) : null;
                if (!"Water Tax Management".equalsIgnoreCase(workflowTypes.getModule().getName())) continue;
                waterConnectionDetails = (WaterConnectionDetails)record;
                tempMap.put("objectId", ((WaterConnectionDetails)record).getApplicationNumber());
                tempMap.put("type", record.getState().getNatureOfTask());
                tempMap.put("module", workflowTypes != null ? workflowTypes.getModule().getDisplayName() : null);
                tempMap.put("details", record.getStateDetails());
                tempMap.put("hscNumber", waterConnectionDetails.getConnection().getConsumerCode());
                tempMap.put("status", record.getCurrentState().getValue());
                tempMap.put("applicationNumber", waterConnectionDetails.getApplicationNumber());
                tempMap.put("waterConnectionDetails", (String)waterConnectionDetails);
                tempMap.put("ownerName", this.getOwnerName(waterConnectionDetails));
                tempMap.put("propertyAddress", this.getPropertyAddress(waterConnectionDetails));
                String additionalRule = waterConnectionDetails.getApplicationType().getCode();
                if (additionalRule.equals("CLOSINGCONNECTION")) {
                    additionalRule = "CLOSECONNECTION";
                }
                tempMap.put("state", additionalRule);
                resultList.add(tempMap);
            }
        }
        return resultList;
    }

    public List<StateAware> fetchItems() {
        ArrayList<StateAware> digitalSignWFItems = new ArrayList<StateAware>();
        digitalSignWFItems.addAll(this.inboxRenderServiceDeligate.getInboxItems(this.securityUtils.getCurrentUser().getId()));
        return digitalSignWFItems;
    }

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    private String getOwnerName(WaterConnectionDetails waterConnectionDetails) {
        Iterator ownerNameItr;
        String ownerName = "";
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
        if (null != assessmentDetails && null != assessmentDetails.getOwnerNames() && (ownerNameItr = assessmentDetails.getOwnerNames().iterator()).hasNext()) {
            OwnerName owner = (OwnerName)ownerNameItr.next();
            ownerName = owner.getOwnerName() != null ? owner.getOwnerName() : ownerName;
        }
        return ownerName;
    }

    private String getPropertyAddress(WaterConnectionDetails waterConnectionDetails) {
        String propAddress = "";
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
        if (null != assessmentDetails) {
            propAddress = assessmentDetails.getPropertyAddress() != null ? assessmentDetails.getPropertyAddress() : propAddress;
        }
        return propAddress;
    }
}

