/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.service.es;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.entity.es.WaterChargeDocument;
import org.egov.wtms.repository.es.WaterChargeDocumentRepository;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.geo.GeoPoint;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class WaterChargeDocumentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WaterChargeDocumentService.class);
    private final WaterChargeDocumentRepository waterChargeIndexRepository;
    @Autowired
    private CityService cityService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private ConnectionDemandService connectionDemandService;

    @Autowired
    public WaterChargeDocumentService(WaterChargeDocumentRepository waterChargeIndexRepository) {
        this.waterChargeIndexRepository = waterChargeIndexRepository;
    }

    public Iterable<WaterChargeDocument> searchwaterChargeIndex(BoolQueryBuilder searchQuery) {
        return this.waterChargeIndexRepository.search((QueryBuilder)searchQuery);
    }

    public WaterChargeDocument updateWaterChargeIndex(WaterChargeDocument waterChargeDocument, WaterConnectionDetails waterConnectionDetails, AssessmentDetails assessmentDetails, BigDecimal amountTodisplayInIndex) {
        Iterator ownerNameItr = assessmentDetails.getOwnerNames().iterator();
        Long monthlyRate = null;
        String consumername = "";
        String aadharNumber = "";
        String mobilNumber = "";
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        String createdDate = null;
        if (waterConnectionDetails.getLegacy().booleanValue()) {
            if (waterConnectionDetails.getApplicationDate() != null) {
                createdDate = dateFormatter.format(waterConnectionDetails.getApplicationDate());
            }
        } else {
            createdDate = dateFormatter.format(waterConnectionDetails.getExecutionDate());
        }
        monthlyRate = this.monthlyRateFirld(waterConnectionDetails);
        if (ownerNameItr != null && ownerNameItr.hasNext()) {
            ((OwnerName)ownerNameItr.next()).getMobileNumber();
        }
        if ((ownerNameItr = assessmentDetails.getOwnerNames().iterator()).hasNext()) {
            OwnerName ownerName = (OwnerName)ownerNameItr.next();
            consumername = ownerName.getOwnerName();
            mobilNumber = ownerName.getMobileNumber();
            String string = aadharNumber = ownerName.getAadhaarNumber() != null ? ownerName.getAadhaarNumber() : "";
            while (ownerNameItr.hasNext()) {
                OwnerName multipleOwner = (OwnerName)ownerNameItr.next();
                consumername = consumername.concat(",".concat(multipleOwner.getOwnerName()));
                aadharNumber = aadharNumber.concat(",".concat(multipleOwner.getAadhaarNumber() != null ? multipleOwner.getAadhaarNumber() : ""));
            }
        }
        Map cityInfo = this.cityService.cityDataAsMap();
        try {
            waterChargeDocument.setZone(assessmentDetails.getBoundaryDetails().getZoneName());
            waterChargeDocument.setRevenueWard(assessmentDetails.getBoundaryDetails().getWardName());
            waterChargeDocument.setAdminWard(assessmentDetails.getBoundaryDetails().getAdminWardName());
            waterChargeDocument.setDoorNo(assessmentDetails.getHouseNo());
            waterChargeDocument.setTotalDue(assessmentDetails.getPropertyDetails().getTaxDue().longValue());
            waterChargeDocument.setLegacy(waterConnectionDetails.getLegacy());
            waterChargeDocument.setCityGrade(StringUtils.defaultString((String)((String)cityInfo.get("cityGrade"))));
            waterChargeDocument.setRegionName(StringUtils.defaultString((String)((String)cityInfo.get("cityRegion"))));
            waterChargeDocument.setClosureType(waterConnectionDetails.getCloseConnectionType() != null ? waterConnectionDetails.getCloseConnectionType() : "");
            waterChargeDocument.setLocality(assessmentDetails.getBoundaryDetails().getLocalityName() != null ? assessmentDetails.getBoundaryDetails().getLocalityName() : "");
            waterChargeDocument.setPropertyId(waterConnectionDetails.getConnection().getPropertyIdentifier());
            waterChargeDocument.setApplicationCode(waterConnectionDetails.getApplicationType().getCode());
            waterChargeDocument.setCreatedDate(dateFormatter.parse(createdDate));
            waterChargeDocument.setMobileNumber(mobilNumber);
            waterChargeDocument.setStatus(waterConnectionDetails.getConnectionStatus().name());
            waterChargeDocument.setDistrictName(StringUtils.defaultString((String)((String)cityInfo.get("districtName"))));
            waterChargeDocument.setConnectionType(waterConnectionDetails.getConnectionType().name());
            waterChargeDocument.setWaterTaxDue(amountTodisplayInIndex.longValue());
            waterChargeDocument.setUsage(waterConnectionDetails.getUsageType().getName());
            waterChargeDocument.setConsumerCode(waterConnectionDetails.getConnection().getConsumerCode());
            waterChargeDocument.setWaterSource(waterConnectionDetails.getWaterSource().getWaterSourceType());
            waterChargeDocument.setPropertyType(waterConnectionDetails.getPropertyType().getName());
            waterChargeDocument.setCategory(waterConnectionDetails.getCategory().getName());
            waterChargeDocument.setCityName(StringUtils.defaultString((String)((String)cityInfo.get("cityname"))));
            waterChargeDocument.setCityCode(StringUtils.defaultString((String)((String)cityInfo.get(this.cityService.getCityCode()))));
            waterChargeDocument.setSumpCapacity(waterConnectionDetails.getSumpCapacity());
            waterChargeDocument.setPipeSize(waterConnectionDetails.getPipeSize().getCode());
            waterChargeDocument.setNumberOfPerson(waterConnectionDetails.getNumberOfPerson() != null ? Long.valueOf(waterConnectionDetails.getNumberOfPerson().intValue()) : 0L);
            waterChargeDocument.setCurrentDue(this.waterConnectionDetailsService.getTotalAmountTillCurrentFinYear(waterConnectionDetails).subtract(this.waterConnectionDetailsService.getTotalAmountTillPreviousFinYear(waterConnectionDetails)).longValue());
            waterChargeDocument.setArrearsDue(this.waterConnectionDetailsService.getTotalAmountTillPreviousFinYear(waterConnectionDetails).longValue());
            waterChargeDocument.setCurrentDemand(this.waterConnectionDetailsService.getTotalDemandTillCurrentFinYear(waterConnectionDetails).subtract(this.waterConnectionDetailsService.getArrearsDemand(waterConnectionDetails)).longValue());
            waterChargeDocument.setArrearsDemand(this.waterConnectionDetailsService.getArrearsDemand(waterConnectionDetails).longValue());
            waterChargeDocument.setMonthlyRate(monthlyRate);
            waterChargeDocument.setConsumerName(consumername);
            waterChargeDocument.setAadhaarNumber(aadharNumber);
            waterChargeDocument.setWardlocation(this.commonWardlocationField(assessmentDetails));
            waterChargeDocument.setPropertylocation(this.commonPropertylocationField(assessmentDetails));
        }
        catch (ParseException exp) {
            LOGGER.error("Exception parsing Date " + exp.getMessage());
        }
        this.createWaterChargeDocument(waterChargeDocument);
        return waterChargeDocument;
    }

    private Long monthlyRateFirld(WaterConnectionDetails waterConnectionDetails) {
        Long monthlyRate = this.connectionDemandService.getWaterRatesDetailsForDemandUpdate(waterConnectionDetails) != null && this.connectionDemandService.getWaterRatesDetailsForDemandUpdate(waterConnectionDetails).getMonthlyRate() != null ? Long.valueOf(new BigDecimal(this.connectionDemandService.getWaterRatesDetailsForDemandUpdate(waterConnectionDetails).getMonthlyRate()).longValue()) : Long.valueOf(BigDecimal.ZERO.longValue());
        return monthlyRate;
    }

    public WaterChargeDocument createWaterChargeIndex(WaterConnectionDetails waterConnectionDetails, AssessmentDetails assessmentDetails, BigDecimal amountTodisplayInIndex) {
        WaterChargeDocument waterChargeDocument = null;
        Map cityInfo = this.cityService.cityDataAsMap();
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        if (waterConnectionDetails.getConnection() != null && waterConnectionDetails.getConnection().getConsumerCode() != null) {
            waterChargeDocument = this.waterChargeIndexRepository.findByConsumerCodeAndCityName(waterConnectionDetails.getConnection().getConsumerCode(), StringUtils.defaultString((String)((String)cityInfo.get("cityname"))));
        }
        if (waterChargeDocument == null) {
            Iterator ownerNameItr = assessmentDetails.getOwnerNames().iterator();
            Long monthlyRate = null;
            String consumername = "";
            String aadharNumber = "";
            String mobilNumber = "";
            monthlyRate = this.monthlyRateFirld(waterConnectionDetails);
            if (ownerNameItr != null && ownerNameItr.hasNext()) {
                ((OwnerName)ownerNameItr.next()).getMobileNumber();
            }
            if ((ownerNameItr = assessmentDetails.getOwnerNames().iterator()).hasNext()) {
                OwnerName ownerName = (OwnerName)ownerNameItr.next();
                consumername = ownerName.getOwnerName();
                mobilNumber = ownerName.getMobileNumber();
                String string = aadharNumber = ownerName.getAadhaarNumber() != null ? ownerName.getAadhaarNumber() : "";
                while (ownerNameItr.hasNext()) {
                    OwnerName multipleOwner = (OwnerName)ownerNameItr.next();
                    consumername = consumername.concat(",".concat(multipleOwner.getOwnerName()));
                    aadharNumber = aadharNumber.concat(",".concat(multipleOwner.getAadhaarNumber() != null ? multipleOwner.getAadhaarNumber() : ""));
                }
            }
            String createdDateStr = dateFormatter.format(waterConnectionDetails.getExecutionDate());
            try {
                waterChargeDocument = WaterChargeDocument.builder().withZone(assessmentDetails.getBoundaryDetails().getZoneName()).withRevenueWard(assessmentDetails.getBoundaryDetails().getWardName()).withAdminward(assessmentDetails.getBoundaryDetails().getAdminWardName()).withDoorNo(assessmentDetails.getHouseNo()).withTotaldue(assessmentDetails.getPropertyDetails().getTaxDue().longValue()).withLegacy(waterConnectionDetails.getLegacy()).withCityGrade(StringUtils.defaultString((String)((String)cityInfo.get("cityGrade")))).withRegionname(StringUtils.defaultString((String)((String)cityInfo.get("cityRegion")))).withClosureType(waterConnectionDetails.getCloseConnectionType() != null ? waterConnectionDetails.getCloseConnectionType() : "").withLocality(assessmentDetails.getBoundaryDetails().getLocalityName() != null ? assessmentDetails.getBoundaryDetails().getLocalityName() : "").withPropertyid(waterConnectionDetails.getConnection().getPropertyIdentifier()).withApplicationcode(waterConnectionDetails.getApplicationType().getCode()).withCreatedDate(dateFormatter.parse(createdDateStr)).withMobileNumber(mobilNumber).withStatus(waterConnectionDetails.getConnectionStatus().name()).withDistrictName(StringUtils.defaultString((String)((String)cityInfo.get("districtName")))).withConnectiontype(waterConnectionDetails.getConnectionType().name()).withWaterTaxDue(amountTodisplayInIndex.longValue()).withUsage(waterConnectionDetails.getUsageType().getName()).withConsumerCode(waterConnectionDetails.getConnection().getConsumerCode()).withWatersource(waterConnectionDetails.getWaterSource().getWaterSourceType()).withPropertytype(waterConnectionDetails.getPropertyType().getName()).withCategory(waterConnectionDetails.getCategory().getName()).withCityName(StringUtils.defaultString((String)((String)cityInfo.get("cityname")))).withCityCode(StringUtils.defaultString((String)((String)cityInfo.get(this.cityService.getCityCode())))).withSumpcapacity(waterConnectionDetails.getSumpCapacity()).withPipesize(waterConnectionDetails.getPipeSize().getCode()).withNumberOfPerson(waterConnectionDetails.getNumberOfPerson() != null ? Long.valueOf(waterConnectionDetails.getNumberOfPerson().intValue()) : 0L).withCurrentDue(this.waterConnectionDetailsService.getTotalAmountTillCurrentFinYear(waterConnectionDetails).subtract(this.waterConnectionDetailsService.getTotalAmountTillPreviousFinYear(waterConnectionDetails)).longValue()).withArrearsDue(this.waterConnectionDetailsService.getTotalAmountTillPreviousFinYear(waterConnectionDetails).longValue()).withCurrentDemand(this.waterConnectionDetailsService.getTotalDemandTillCurrentFinYear(waterConnectionDetails).subtract(this.waterConnectionDetailsService.getArrearsDemand(waterConnectionDetails)).longValue()).withArrearsDemand(this.waterConnectionDetailsService.getArrearsDemand(waterConnectionDetails).longValue()).withMonthlyRate(monthlyRate).withConsumername(consumername).withAadhaarnumber(aadharNumber).withWardlocation(this.commonWardlocationField(assessmentDetails)).withPropertylocation(this.commonPropertylocationField(assessmentDetails)).build();
            }
            catch (ParseException exp) {
                LOGGER.error("Exception parsing Date " + exp.getMessage());
            }
            this.createWaterChargeDocument(waterChargeDocument);
        } else {
            this.updateWaterChargeIndex(waterChargeDocument, waterConnectionDetails, assessmentDetails, amountTodisplayInIndex);
        }
        return waterChargeDocument;
    }

    public GeoPoint commonWardlocationField(AssessmentDetails assessmentDetails) {
        Boundary adminBoundary;
        GeoPoint wardlocation = null;
        if (assessmentDetails.getBoundaryDetails().getAdminWardId() != null && (adminBoundary = this.boundaryService.getBoundaryById(assessmentDetails.getBoundaryDetails().getAdminWardId())).getLatitude() != null && adminBoundary.getLongitude() != null) {
            wardlocation = new GeoPoint((double)adminBoundary.getLatitude().floatValue(), (double)adminBoundary.getLongitude().floatValue());
        }
        return wardlocation;
    }

    public GeoPoint commonPropertylocationField(AssessmentDetails assessmentDetails) {
        GeoPoint propertylocation = null;
        if (assessmentDetails.getLatitude() != 0.0 && assessmentDetails.getLongitude() != 0.0) {
            propertylocation = new GeoPoint(assessmentDetails.getLatitude(), assessmentDetails.getLongitude());
        }
        return propertylocation;
    }

    @Transactional
    public WaterChargeDocument createWaterChargeDocument(WaterChargeDocument waterChargeIndex) {
        this.waterChargeIndexRepository.save(waterChargeIndex);
        return waterChargeIndex;
    }
}

