/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.masters.service;

import java.util.ArrayList;
import java.util.List;
import org.egov.wtms.masters.entity.WaterSource;
import org.egov.wtms.masters.repository.WaterSourceRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class WaterSourceService {
    private final WaterSourceRepository waterSourceRepository;

    @Autowired
    public WaterSourceService(WaterSourceRepository waterSourceRepository) {
        this.waterSourceRepository = waterSourceRepository;
    }

    public WaterSource findOne(Long waterSourceId) {
        return (WaterSource)((Object)this.waterSourceRepository.findOne(waterSourceId));
    }

    @Transactional
    public WaterSource createWaterSource(WaterSource waterSource) {
        waterSource.setActive(true);
        return (WaterSource)((Object)this.waterSourceRepository.save((Object)waterSource));
    }

    @Transactional
    public void updateWaterSource(WaterSource waterSource) {
        this.waterSourceRepository.save((Object)waterSource);
    }

    public List<WaterSource> findAll() {
        return this.waterSourceRepository.findAll(new Sort(Sort.Direction.DESC, new String[]{"waterSourceType"}));
    }

    public WaterSource findByWaterSourceType(String waterSourceType) {
        return this.waterSourceRepository.findByWaterSourceType(waterSourceType);
    }

    public WaterSource load(Long id) {
        return (WaterSource)((Object)this.waterSourceRepository.getOne(id));
    }

    public Page<WaterSource> getListOfWaterSources(Integer pageNumber, Integer pageSize) {
        PageRequest pageable = new PageRequest(pageNumber - 1, pageSize.intValue(), Sort.Direction.ASC, new String[]{"waterSourceType"});
        return this.waterSourceRepository.findAll((Pageable)pageable);
    }

    public WaterSource findByCode(String code) {
        return this.waterSourceRepository.findByCode(code);
    }

    public WaterSource findByCodeIgnoreCase(String code) {
        return this.waterSourceRepository.findByCodeIgnoreCase(code);
    }

    public WaterSource findByWaterSourceTypeIgnoreCase(String waterSourceType) {
        return this.waterSourceRepository.findByWaterSourceTypeIgnoreCase(waterSourceType);
    }

    public List<WaterSource> getAllActiveWaterSourceTypes() {
        return this.waterSourceRepository.findByActiveTrueOrderByWaterSourceTypeAsc();
    }

    public WaterSource findByCodeAndWaterSourceType(String code, String waterSourceType) {
        return this.waterSourceRepository.findByCodeAndWaterSourceType(code, waterSourceType);
    }

    public List<WaterSource> getWaterSourceListForRest() {
        List<WaterSource> waterSourceList = this.waterSourceRepository.findByActiveTrueOrderByWaterSourceTypeAsc();
        ArrayList<WaterSource> prepareListForRest = new ArrayList<WaterSource>(0);
        for (WaterSource waterSource : waterSourceList) {
            WaterSource waterSourceRest = new WaterSource();
            waterSourceRest.setCode(waterSource.getCode());
            waterSourceRest.setWaterSourceType(waterSource.getWaterSourceType());
            waterSourceRest.setActive(waterSource.isActive());
            prepareListForRest.add(waterSourceRest);
        }
        return prepareListForRest;
    }
}

