/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.masters.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.infstr.services.Page;
import org.egov.wtms.application.entity.UsageSlabSearchRequest;
import org.egov.wtms.masters.entity.UsageSlab;
import org.egov.wtms.masters.repository.UsageSlabRepository;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class UsageSlabService {
    @Autowired
    private UsageSlabRepository usageSlabRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Transactional
    public void save(UsageSlab usageSlab) {
        this.usageSlabRepository.save((Object)usageSlab);
    }

    public Page<UsageSlab> search(UsageSlabSearchRequest usageSlabSearchRequest) {
        StringBuilder queryString = new StringBuilder(512);
        queryString.append("from UsageSlab U where U.active=:active ");
        if (usageSlabSearchRequest.getUsage() != null) {
            queryString.append(" and U.usage=:usage");
        }
        if (usageSlabSearchRequest.getSlabName() != null) {
            queryString.append(" and U.slabName=:slabName");
        }
        if (usageSlabSearchRequest.getFromVolume() != null) {
            queryString.append(" and U.fromVolume=:fromVolume");
        }
        if (usageSlabSearchRequest.getToVolume() != null) {
            queryString.append(" and U.toVolume=:toVolume");
        }
        Query query = ((Session)this.entityManager.unwrap(Session.class)).createQuery(queryString.toString());
        query.setParameter("active", (Object)usageSlabSearchRequest.isActive());
        if (usageSlabSearchRequest.getUsage() != null) {
            query.setParameter("usage", (Object)usageSlabSearchRequest.getUsage());
        }
        if (usageSlabSearchRequest.getSlabName() != null) {
            query.setParameter("slabName", (Object)usageSlabSearchRequest.getSlabName());
        }
        if (usageSlabSearchRequest.getFromVolume() != null) {
            query.setParameter("fromVolume", (Object)usageSlabSearchRequest.getFromVolume());
        }
        if (usageSlabSearchRequest.getToVolume() != null) {
            query.setParameter("toVolume", (Object)usageSlabSearchRequest.getToVolume());
        }
        query.setParameter("active", (Object)usageSlabSearchRequest.isActive());
        int size = this.getTotalRecords(query);
        return new Page(query, usageSlabSearchRequest.pageNumber(), usageSlabSearchRequest.pageSize(), size);
    }

    public UsageSlab findById(Long id) {
        return (UsageSlab)((Object)this.usageSlabRepository.findOne(id));
    }

    public List<UsageSlab> getActiveUsageSlabs() {
        return this.usageSlabRepository.findByActiveTrue();
    }

    public List<UsageSlab> findAllUsageSlabs() {
        return this.usageSlabRepository.findAll();
    }

    public int getTotalRecords(Query query) {
        return query.list().size();
    }

    public UsageSlab checkSlabOverlap(String usage, Long fromVolume, Long toVolume) {
        List<UsageSlab> usageSlabList = this.usageSlabRepository.isSlabOverLap(usage, fromVolume, toVolume);
        if (usageSlabList.isEmpty()) {
            return new UsageSlab();
        }
        return usageSlabList.get(0);
    }

    public UsageSlab checkSlabGap(String usage, Long fromVolume, Long toVolume) {
        List usageSlabList;
        UsageSlab slab;
        List<UsageSlab> slabList = this.usageSlabRepository.getActiveSlabLessThanGivenFromVolume(usage, fromVolume);
        if (!slabList.isEmpty() && (slab = slabList.get(0)).getFromVolume() != null && slab.getToVolume() == null) {
            return slab;
        }
        StringBuilder queryString = new StringBuilder();
        queryString.append("from UsageSlab u where u.usage=:usage and u.active=true");
        if (fromVolume != null) {
            queryString.append(" and (u.fromVolume<=:fromVolume and (u.toVolume<=:fromVolume or u.toVolume is null))");
        }
        if (toVolume != null) {
            queryString.append(" or (u.fromVolume>=:toVolume and u.toVolume>=:toVolume)");
        }
        if (!slabList.isEmpty()) {
            queryString.append(" order by fromVolume desc");
        } else {
            queryString.append(" order by fromVolume asc");
        }
        Query query = ((Session)this.entityManager.unwrap(Session.class)).createQuery(queryString.toString());
        if (usage != null) {
            query.setParameter("usage", (Object)usage);
        }
        if (fromVolume != null) {
            query.setParameter("fromVolume", (Object)fromVolume);
        }
        if (toVolume != null) {
            query.setParameter("toVolume", (Object)toVolume);
        }
        if ((usageSlabList = query.list()).isEmpty()) {
            return new UsageSlab();
        }
        return (UsageSlab)((Object)usageSlabList.get(0));
    }

    public UsageSlab findBySlabName(String slabName) {
        return this.usageSlabRepository.findBySlabName(slabName);
    }

    public UsageSlab getUsageSlabForWaterVolumeConsumed(String usage, Long noOfUnitsPerMonth) {
        return this.usageSlabRepository.getUsageSlabForWaterVolumeConsumed(usage, noOfUnitsPerMonth);
    }
}

